/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jbase.util;

import ch.javasoft.jbase.MemoryTable;
import ch.javasoft.jbase.Table;
import ch.javasoft.jbase.util.TableList;
import ch.javasoft.jbase.util.UnsupportedOperationException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tables {
    public static final Table<?> EMPTY_TABLE = Tables.unmodifyableTable(new MemoryTable());

    public static <E> Table<E> emptyTable() {
        return EMPTY_TABLE;
    }

    public static <E> Table<E> unmodifyableTable(final Table<E> table) {
        return new Table<E>(){

            @Override
            public int add(E entity) throws UnsupportedOperationException {
                throw new UnsupportedOperationException("unmodifyable table");
            }

            @Override
            public void remove(int index) throws UnsupportedOperationException {
                throw new UnsupportedOperationException("unmodifyable table");
            }

            @Override
            public void set(int index, E entity) throws UnsupportedOperationException {
                throw new UnsupportedOperationException("unmodifyable table");
            }

            @Override
            public void swap(int indexA, int indexB) throws IOException {
                throw new UnsupportedOperationException("unmodifyable table");
            }

            @Override
            public void removeAll() throws UnsupportedOperationException {
                throw new UnsupportedOperationException("unmodifyable table");
            }

            @Override
            public E get(int index) throws IOException {
                return table.get(index);
            }

            @Override
            public int size() throws IOException {
                return table.size();
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close(boolean erase) throws IOException {
                if (erase) {
                    throw new UnsupportedOperationException("unmodifyable table");
                }
                table.close(false);
            }
        };
    }

    public static <E> Table<E> synchronizedTable(final Table<E> table) {
        return new Table<E>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int add(E entity) throws IOException {
                Table table2 = table;
                synchronized (table2) {
                    return table.add(entity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove(int index) throws IOException {
                Table table2 = table;
                synchronized (table2) {
                    table.remove(index);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(int index, E entity) throws IOException {
                Table table2 = table;
                synchronized (table2) {
                    table.set(index, entity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void swap(int indexA, int indexB) throws IOException {
                Table table2 = table;
                synchronized (table2) {
                    table.swap(indexA, indexB);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAll() throws IOException {
                Table table2 = table;
                synchronized (table2) {
                    table.removeAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public E get(int index) throws IOException {
                Table table2 = table;
                synchronized (table2) {
                    return table.get(index);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int size() throws IOException {
                Table table2 = table;
                synchronized (table2) {
                    return table.size();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flush() throws IOException {
                Table table2 = table;
                synchronized (table2) {
                    table.flush();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close(boolean erase) throws IOException {
                Table table2 = table;
                synchronized (table2) {
                    table.close(erase);
                }
            }
        };
    }

    public static <E> Table<E> autoflushTable(final Table<E> table) {
        return new Table<E>(){

            @Override
            public int add(E entity) throws IOException {
                int pos = table.add(entity);
                table.flush();
                return pos;
            }

            @Override
            public void remove(int index) throws IOException {
                table.remove(index);
                table.flush();
            }

            @Override
            public void set(int index, E entity) throws IOException {
                table.set(index, entity);
                table.flush();
            }

            @Override
            public void swap(int indexA, int indexB) throws IOException {
                table.swap(indexA, indexB);
                table.flush();
            }

            @Override
            public void removeAll() throws IOException {
                table.removeAll();
                table.flush();
            }

            @Override
            public E get(int index) throws IOException {
                return table.get(index);
            }

            @Override
            public int size() throws IOException {
                return table.size();
            }

            @Override
            public void flush() throws IOException {
                table.flush();
            }

            @Override
            public void close(boolean erase) throws IOException {
                table.close(erase);
            }
        };
    }

    public static <E> List<E> asList(Table<E> table) {
        return new TableList<E>(table);
    }

    public static Object[] asArray(Table<?> table) {
        return Tables.asList(table).toArray();
    }

    public static <A, E extends A> A[] asArray(Table<E> table, A[] array) {
        return Tables.asList(table).toArray(array);
    }

    public static <E> Enumeration<E> enumeration(final Table<E> table) {
        return new Enumeration<E>(){
            int current = 0;

            @Override
            public boolean hasMoreElements() {
                try {
                    return this.current < table.size();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public E nextElement() {
                try {
                    if (this.current < table.size()) {
                        Object e = table.get(this.current);
                        ++this.current;
                        return e;
                    }
                    throw new NoSuchElementException();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    public static <E> void fill(Table<E> table, E value) throws IOException {
        int size = table.size();
        table.removeAll();
        int i = 0;
        while (i < size) {
            table.add(value);
            ++i;
        }
    }

    public static <E> void addAll(Iterable<? extends E> src, Table<E> dst) throws IOException {
        for (E e : src) {
            dst.add(e);
        }
    }

    public static <E> void addAll(Table<? extends E> src, Table<E> dst) throws IOException {
        int i = 0;
        while (i < src.size()) {
            dst.add(src.get(i));
            ++i;
        }
    }

    private Tables() {
    }
}

