########################################
# Physical Constants
########################################

# Standard energy scale is eV
# Standard length scale is nm
# Standard temperature scale is K
# Constants in SI units have _SI in name

me = 511e3 #electron mass in eV/c2
bohr_a0 = 0.0529 # Bohr length in nm
hartree = 27.211 # eV
e2 = 1.4399 # Elemental charge squared in eV nm
alpha = 1/137
hbarc = 0.197326e3 # eV nm
me_SI = 9e-31 # electron mass in kg
qe_SI = 1.6e-19 # electron charge in C
kB_SI = 1.38e-23 # Boltzmann constant in SI units
kB = 8.617e-5 # boltzmann constant in eV/K
kE_SI = 8.99e9 # 1/(4 pi epsilon0) in SI units

#######################################
# Material Constants
#######################################

epsR_Si = 11.8 # Relative dielectric strength of Silicon
E0gap_Si = 1.1692 # eV
Fano_Si = 0.11

DIMENSIONS=3
