# OpenTimelineIO drp adapter plugin

This repository aims at storing an adapter for the OpenTimelineIO project allowing to import .drp files from the Blackmagic ATEM Mini ISO. The initial goal is to be able to import them directly in KDEnlive for further editing, but any OTIO adapter can be used, by design.

It works as is, for simple file based sources, and the .drp file generated by the ATEM Mini ISO. Do not expect it to work right away for every use-case, and obviously not for an actual DaVinci Resolve generated file.

## Installation and Usage

### Installation

The adapter is not included in OTIO, but is published on Pypi as otio-drp-adapter, so either you can clone the repository and run `pip install .`, or just install it using pip / PyPi (it will install OpenTimelineIO if needed):

`pip install otio-drp-adpater`


### Usage

If you have a .drp file from the Blackmagic ATEM ISO, you can use `otioconvert -i Video.drp -o Video.kdenlive` once you've installed the adapter. It won't be available for now from KDEnlive menu, as it requires adapters to enable read and write to be listed, and we only implement reading for now.

## Adapter Arguments

You can use arguments with otio tools (-a param=value) to modify the adapter's behaviour.

### main_mix=False

This adds a Main Mix track with all the clips attached to it. By default all the sources are set on their track, the timeline is the main mix. It may help for further editing to have an explicit track there, this argument enables it. It's built while processing the .drp file, not using the flatten tools in OTIO.

### full_tracks=False

Instead of having each source as a track with gaps, this fills each track source with the full length clip. This is mostly useful combined with main_mix=True, to make it possible to re-decide on the source selection, e.g. using the Multicam tool in KDEnlive.

## Notes about .drp file format

Note: the .drp format here is the one generated by the BlackMagic ATEM ISO switcher, not DaVinci Resolve, though it may work for such files.

There wasn't an obvious spec for that file, so the adapter is written based on guesses about the file format itself. It seems the file is line-based, with the first line being some metadata, including the sources using JSON. Then each line represent a live switch between sources, using JSON as well.

### Metadata
 
The header looks like this (taken from a simple ISO recording on the Blackmagic ATEM Mini Pro ISO):
```json
{"version":1,"masterTimecode":"20:58:44:03","videoMode":"1080p25","sources":[{"name":"Camera 1","type":"Video","volume":"ATEM","projectPath":"Test 3","file":"Video ISO Files/Test CAM 1.mp4","startTimecode":"20:58:44:03","_index_":1},{"name":"Camera 2","type":"Video","volume":"ATEM","projectPath":"Test 3","file":"Video ISO Files/Test CAM 2.mp4","startTimecode":"20:58:44:03","_index_":2},{"name":"Camera 3","type":"Video","volume":"ATEM","projectPath":"Test 3","file":"Video ISO Files/Test CAM 3.mp4","startTimecode":"20:58:44:03","_index_":3},{"name":"Camera 4","type":"Video","volume":"ATEM","projectPath":"Test 3","file":"Video ISO Files/Test CAM 4.mp4","startTimecode":"20:58:44:03","_index_":4}]}"
```

We use the `masterTimecode` as the time reference for the frames. `videoMode` is used to determine the frame rate of the ISO files. Sources with a file attribute are then used to compute the tracks and media references for each file.

### Switches

Each line represents a switch, giving out the timecode, and the source we're switching to

```json
{"masterTimecode":"21:01:19:14","mixEffectBlocks":[{"source":2,"_index_":0}]}
```

## Licensing

This plugin is licensed under the
[Apache License, Version 2.0](https://www.apache.org/licenses/LICENSE-2.0.txt)


## Tests

There is a a basic .drp file in sample_data/ that is parsed during the tests. It can be tried using:
```bash
# In the root folder of the repo
pip install -e .

# Test an adapter for instance
otioconvert -i some_timeline.drp -o some_timeline.ext
```

## Github Actions (as from example repository)

A set of simple automation scripts are available in the `.github/workflows` folder.
* `ci.yaml` - runs unit tests
* `create_draft_release` - when a tag is pushed, it creates a draft for a release
* `deploy_package.yaml` - simple packing an publishing of a plugin package. 
  Make sure you have a valid token for your PyPi user added to your repos 
  [secrets](https://docs.github.com/es/actions/reference/encrypted-secrets).

