from enum import IntEnum


class SnapshotMCUSource(IntEnum):
    MCU_SOURCE_MDSP = 0
    MCU_SOURCE_SDSP = 1


class SnapshotExportDevice(IntEnum):
    EXPORT_DEVICE_UART = 0
    EXPORT_DEVICE_USB = 1


class SnapshotStartResult(IntEnum):
    SNAPSHOT_START_START = 0xAAAA
    SNAPSHOT_START_SUCCESS = 0xA5A5
    SNAPSHOT_START_FAILED = 0x5A5A
    SNAPSHOT_START_STOP = 0xBBBB


class SnapshotRegisterAddress(IntEnum):
    SNAPSHOT_REGISTERADDRESS_MCUSOURCE = 0x4011
    SNAPSHOT_REGISTERADDRESS_EXPORTDEVICE = 0x4012
    SNAPSHOT_REGISTERADDRESS_START = 0x4013
    SNAPSHOT_REGISTERADDRESS_TOTALNUMBER = 0x4070
    SNAPSHOT_REGISTERADDRESS_SNAPSHOTINDEX = 0x4071
    SNAPSHOT_REGISTERADDRESS_PACKDATASTATUS = 0x4072
    SNAPSHOT_REGISTERADDRESS_DATASIZE = 0x4073
    SNAPSHOT_REGISTERADDRESS_CHANNELNUMBER = 0x4074
    SNAPSHOT_REGISTERADDRESS_CHANNELDATASIZE = 0x4075
    SNAPSHOT_REGISTERADDRESS_PACKINDEX = 0x407F
    SNAPSHOT_REGISTERADDRESS_PACKDATA = 0x4080


class CommandType(IntEnum):
    ACK = 0x80  # 接收应答
    TOTAL_PACKETS = 0x81  # 上报总包数
    DATA_PACKET = 0x82  # 具体分包数据
    ERROR = 0x83  # 报错应答
