# Python client library for SAP AI Business Services - Business Entity Recognition REST API

Business Entity Recognition is a set of micro-services, that provides a REST API for detecting and highlighting any type of named entity in unstructured text.
This repository contains the source code of a Python client library to facilitate the use of Business Entity Recognition. The client library provides convenient methods to access the service that issue calls to the SAP AI Business Services - Business Entity Recognition REST API. In order to be able to use the library you need to have access to SAP Business Technology Platform.

Please check out the [usage examples](https://github.com/SAP/business-entity-recognition-client-library/tree/main/examples), they are very useful to get started with the service.

## Requirements
This library requires properly setup Python 3 environment.

## Download and Installation
This Python library should be consumed in the standard way by running

pip install sap-business-entity-recognition-client-library

or adding the library as a dependency of your code in requirements.txt file.

## Prerequisites
* [Get an SAP Business Technology Plattform trial account](https://developers.sap.com/tutorials/hcp-create-trial-account.html)
* [Create a Business Entity Recognition service instance](https://developers.sap.com/tutorials/cp-aibus-ber-service-instance.html)

## Known Issues
Please see the issues section.

## How to obtain support
In case you would like to contribute to this project, ask any questions or get support, please open an issue containing the description of your question or planned contribution in GitHub and we will get in touch.

## License
Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache License, v 2.0 except as noted otherwise in the LICENSE file.


