"use strict";
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const topic_base_1 = require("./topic-base");
topic_base_1.TopicBase.prototype.metric = function (metricName, props) {
    return new cloudwatch.Metric({
        namespace: 'AWS/SNS',
        metricName,
        dimensionsMap: { TopicName: this.topicName },
        ...props
    }).attachTo(this);
};
topic_base_1.TopicBase.prototype.metricPublishSize = function (props) {
    return this.metric('PublishSize', { statistic: 'Average', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfMessagesPublished = function (props) {
    return this.metric('NumberOfMessagesPublished', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsDelivered = function (props) {
    return this.metric('NumberOfNotificationsDelivered', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsFailed = function (props) {
    return this.metric('NumberOfNotificationsFailed', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsFilteredOut = function (props) {
    return this.metric('NumberOfNotificationsFilteredOut', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsFilteredOutNoMessageAttributes = function (props) {
    return this.metric('NumberOfNotificationsFilteredOut-NoMessageAttributes', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsFilteredOutInvalidAttributes = function (props) {
    return this.metric('NumberOfNotificationsFilteredOut-InvalidAttributes', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricSMSMonthToDateSpentUSD = function (props) {
    return this.metric('SMSMonthToDateSpentUSD', { statistic: 'Maximum', ...props });
};
topic_base_1.TopicBase.prototype.metricSMSSuccessRate = function (props) {
    return this.metric('SMSSuccessRate', { statistic: 'Sum', ...props });
};
//# sourceMappingURL=data:application/json;base64,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