# Presalytics Python Library

This package provides interfaces with the Presalytics.io APIs and middleware for user to interactive with presaltyics.io.  

For full API documentation and use, please go to [Documentation](https://presalytics.io/docs).  Quickstart templates and examples for this python client can be found at the [Python Client Subpage](https://presalytics.io/docs/guides/python-client/overview). 

For more information, visit https://presalytics.io.

# Overview

The Presalytics Python Library streamlines analytic operations across analysts, executives, consultants, 
and developers.  These tools enable for a simplified workflow for analysts to rapidly generate 
client-ready presentation materials and web content that update in real-time and easily scale across your user-base.  

Our objective when building this platform is make the analyst experience as simple as possible.  
Set up time for new user should take less than half an hour, and all features are self-service and self-explanatory.  

Of course, if you have any questions or need help to get going, you can [contact us](/contact-us) or 
quickly get the help you need on our [slack channel](https://presalytics.slack.com) 
([Join Here!](https://join.slack.com/t/presalytics/shared_invite/enQtODExMjc3MDE1Nzc5LWU0ZDlhZTgwZTM3MzQ4Yzc4Nzk4Zjc0NmQ3YjgzNTEwODdlYjM0ZjFkZWI4Y2ZhNzBmOTZhMzA2MzE3YjFiZTg)).

To get going quickly, you can browse our [Getting Started](https://presalytics.io/docs/getting-started/) page and review 
some [examples](https://presalytics.io/docs/examples).

For more advanced users and developers, you can learn more about the API by reviewing 
the [service structure](https://presalytics.io/docs/how-it-works) to build a better understanding 
of the API and its [security](https://presalytics.io/docs/develpers/security) features.

# Requirements

Python 3.5+.  This client uses packages that are not yet compatible with python2.  If python2 compatiliity is needed for legacy applications, we'd love hear about your use case. The api client sub packages are python 2.7+ compatible.

# Installation

The Presalytics Python Library is avialabe in python package index, and can be installed via pip:

~~~~python
pip install presalytics
~~~~

You can also keep up with the latest feature updates by install presalytics with the commandwith the command(potentially unstable):

~~~~bash
pip install git+https://github.com/presalytics/python-client
~~~~

# Contributing

Presalytics.io is on [Github](https://github.com/presalytics).  Bug reports and pull requests are strongly encouraged at
the package [repository](https://github.com/presalytics/python-client). If you encounter any problems or have any suggestions for 
the API endpoints that this libary interacts with at https://api.presalytics.io, please open an issue in the 
[API repository](https://github.com/presalytics/Presalytics-API).

# License

The Presalytics Python Library can be used in any of your applications and is covered by the MIT License.  This library
exchanges infromation with other web APIs that may be proprietary and carry their own licensing restriction.  More more
information on licensing, please contact [inquires@presalytics.io](mailto:inquires@presalytics.io).
