# Aksharamukha Python Package

Aksharamukha aims to provide transliteration a.k.a script conversion between various scripts within the Indic cultural sphere.  These include historic scripts, contemporary Brahmi-derived/inspired scripts, scripts invented for minority Indian languages, scripts that have co-existed with Indic scripts (like Avestan) or linguistically related scripts like Old Persian. It also specifically provides lossless transliteration between the main Indian scripts (along with Sinhala).

Apart from the simple mapping of characters, Askharamukha also attempts to implement various script/language-specific orthographic conventions (where known) such as vowel lengths, gemination and nasalization. It also provides several customization options to fine-tune and get the desired orthography.

Aksharamukha as of now supports 120 scripts and 21 romanization methods. The scripts supported are:

*Ahom, Arabic, Ariyaka, Assamese, Avestan, Balinese, Batak Karo, Batak Mandailing, Batak Pakpak, Batak Simalungun, Batak Toba, Bengali (Bangla), Bhaiksuki, Brahmi, Buginese (Lontara), Buhid, Burmese (Myanmar), Chakma, Cham, Cyrillic (Russian), Devanagari, Dogra, Elymaic, Ethiopic (Abjad), Gondi (Gunjala), Gondi (Masaram), Grantha, Grantha (Pandya), Gujarati, Hanunoo, Hatran, Hebrew, Hebrew (Judeo-Arabic), Imperial Aramaic, Inscriptional Pahlavi, Inscriptional Parthian, Japanese (Hiragana), Japanese (Katakana), Javanese, Kaithi, Kannada, Kawi, Khamti Shan, Kharoshthi, Khmer (Cambodian), Khojki, Khom Thai, Khudawadi, Lao, Lao (Pali), Lepcha, Limbu, Mahajani, Makasar, Malayalam, Manichaean, Marchen, Meetei Mayek (Manipuri), Modi, Mon, Mongolian (Ali Gali), Mro, Multani, Nabataean, Nandinagari, Newa (Nepal Bhasa), Old North Arabian, Old Persian, Old Sogdian, Old South Arabian, Oriya (Odia), Pallava, Palmyrene, Persian, PhagsPa, Phoenician, Psalter Pahlavi, Punjabi (Gurmukhi), Ranjana (Lantsa), Rejang, Rohingya (Hanifi), Roman (IPA Indic), Samaritan, Santali (Ol Chiki), Saurashtra, Shahmukhi, Shan, Sharada, Siddham, Sinhala, Sogdian, Sora Sompeng, Soyombo, Sundanese, Syloti Nagari, Syriac (Eastern), Syriac (Estrangela), Syriac (Western), Tagalog, Tagbanwa, Tai Laing, Takri, Tamil, Tamil (Extended), Tamil Brahmi, Telugu, Thaana (Dhivehi), Thai, Tham (Lanna), Tham (Lao), Tham (Tai Khuen), Tham (Tai Lue), Tibetan, Tirhuta (Maithili), Ugaritic, Urdu, Vatteluttu, Wancho, Warang Citi, Zanabazar Square*

The Indic Romanization Formats supported are: *Harvard-Kyoto, ITRANS, Velthuis, IAST, IAST (Pāḷi), ISO, ISO (Pāḷi), Titus, SLP1, WX, Roman (Readable), Roman (Colloquial)* . The Semitic Romanization Formats supported are: *Semitic (Aksharamukha), Semitic Typeable (Aksharamukha), ISO 259 Hebrew, SBL Hebrew, ISO 233 Arabic, DMG Persian*

## Usage and Examples

Please use `pip aksharamukha` to install the Python package.

Please find the usage instructions and relevant documentation [here](http://aksharamukha.appspot.com/#/python).

## Online Version

The package as an online tool with a pretty web interface is available [here](http://aksharamukha.appspot.com/).

## Contact

If you have any questions please head to [Github](https://github.com/virtualvinodh/aksharamukha-python) or mail vinodh@virtualvinodh.com
