#!/usr/bin/env python3
"""Core package

This sub-package contains the principal modules, which are responsible for the
creation of COBRApy objects and the addition of Pathway objects into the
metabolic model. The modules include:


- creation: Creation of COBRApy objects.
- extension: Addition of reactions and metabolites into metabolic models.
- pathway: Creation of :func:`cobra.core.group.Group` child.
:func:`cobramod.core.pathway.Pathway`.
- graph: Algorithm to build the order for reactions
- retrieval: Function to retrieve data from local directory or databases.
"""
