"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasParameter = exports.findParameters = void 0;
const section_1 = require("./section");
function findParameters(template, logicalId, props = {}) {
    var _a;
    const section = (_a = template.Parameters) !== null && _a !== void 0 ? _a : {};
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (!result.match) {
        return {};
    }
    return result.matches;
}
exports.findParameters = findParameters;
function hasParameter(template, logicalId, props) {
    var _a;
    const section = (_a = template.Parameters) !== null && _a !== void 0 ? _a : {};
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return 'No parameters found in the template';
    }
    return [
        `Template has ${result.analyzedCount} parameters, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasParameter = hasParameter;
//# sourceMappingURL=data:application/json;base64,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