# Collaborative Literature Reviews (CoLRev)

<p align="center">
<img src="https://raw.githubusercontent.com/CoLRev-Ecosystem/colrev/main/docs/figures/logo_small.png" width="400">
</p>

<div align="center">

[![DOI](https://zenodo.org/badge/363073613.svg)](https://zenodo.org/badge/latestdoi/363073613)
[![GitHub release](https://img.shields.io/github/v/release/CoLRev-Ecosystem/colrev.svg)](https://github.com/CoLRev-Ecosystem/colrev/releases/)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/colrev)
[![License](https://img.shields.io/github/license/CoLRev-Ecosystem/colrev.svg)](https://github.com/CoLRev-Ecosystem/colrev/releases/)
[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)
[![Documentation Status](https://readthedocs.org/projects/colrev/badge/?version=latest)](https://colrev.readthedocs.io/en/latest/?badge=latest)
![GitHub Workflow Status](https://img.shields.io/github/actions/workflow/status/CoLRev-Ecosystem/colrev/tests.yml)
[![pre-commit.ci status](https://results.pre-commit.ci/badge/github/CoLRev-Ecosystem/colrev/main.svg)](https://results.pre-commit.ci/latest/github/CoLRev-Ecosystem/colrev/main)
![Coverage](https://raw.githubusercontent.com/CoLRev-Ecosystem/colrev/main/coverage.svg)
![GitHub last commit](https://img.shields.io/github/last-commit/CoLRev-Ecosystem/colrev)
[![Downloads](https://static.pepy.tech/badge/colrev/month)](https://pepy.tech/project/colrev)
[![OpenSSF Best Practices](https://bestpractices.coreinfrastructure.org/projects/7148/badge)](https://bestpractices.coreinfrastructure.org/projects/7148)
[![SWH](https://archive.softwareheritage.org/badge/origin/https://github.com/CoLRev-Ecosystem/colrev/)](https://archive.softwareheritage.org/browse/origin/?origin_url=https://github.com/CoLRev-Ecosystem/colrev/)
<!-- ![PyPI](https://img.shields.io/pypi/v/colrev) -->
<!-- [![](https://img.shields.io/badge/-documentation-green)](https://colrev.readthedocs.io/) -->

</div>

## Summary

CoLRev is an open-source environment for collaborative literature reviews. It takes care of the data, integrates with differerent synthesis tools, and facilitates Git-based collaboration.

To accomplish these goals, CoLRev advances the design of review technology at the intersection of methods, design, cognition, and community building.
The following features stand out:

- An open and extensible environment based on shared data and process standards
- Builds on git and its transparent collaboration model for the entire literature review process
- Offers a self-explanatory, fault-tolerant, and configurable user workflow
- Operates a model for data quality, record identification, content curation, and reuse
- Enables typological and methodological pluralism throughout the process

See the [statements of development status](https://colrev.readthedocs.io/en/latest/foundations/roadmap.html) and [documentation](https://colrev.readthedocs.io/en/latest/) for more details. A brief overview presented at ESMARConf2023 is available on [YouTube](https://www.youtube.com/watch?v=fuLpu8X1Mr0).

## Contributing, changes, and releases

Contributions, code and features are always welcome

- See [contributing guidelines](CONTRIBUTING.md), [help page](docs/build/user_resources/help.html), and [github repository](https://github.com/CoLRev-Ecosystem/colrev).
- Bug reports or feedback? Please use the [issue tracker](https://github.com/CoLRev-Ecosystem/colrev/issues) and let us know.
- To get your work included, fork the repository, implement your changes, and create a [pull request](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests).

For further information, see [tests](tests/readme.md), [changes](CHANGELOG.md), and [releases](https://github.com/CoLRev-Ecosystem/colrev/releases).

## License

This project is distributed under the [MIT License](LICENSE) the documentation is distributed under the [CC-0](https://creativecommons.org/publicdomain/zero/1.0/) license.
If you contribute to the project, you agree to share your contribution following these licenses.

## Citing CoLRev

Please [cite](docs/_static/colrev_citation.bib) the project as follows:

Wagner, G. and Prester, J. (2023) CoLRev - An open-source environment for Collaborative Literature Reviews. Available at https://github.com/CoLRev-Ecosystem/colrev.
