/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBase;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBinary;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBoolean;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDate;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDouble;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataLong;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataString;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;

public class CatalogTableStatisticsConverter {
    public static TableStats convertToTableStats(CatalogTableStatistics tableStatistics, CatalogColumnStatistics columnStatistics) {
        if (tableStatistics == null || tableStatistics.equals(CatalogTableStatistics.UNKNOWN)) {
            return TableStats.UNKNOWN;
        }
        long rowCount = tableStatistics.getRowCount();
        Map<String, ColumnStats> columnStatsMap = null;
        if (columnStatistics != null && !columnStatistics.equals(CatalogColumnStatistics.UNKNOWN)) {
            columnStatsMap = CatalogTableStatisticsConverter.convertToColumnStatsMap(columnStatistics.getColumnStatisticsData());
        }
        if (columnStatsMap == null) {
            columnStatsMap = new HashMap<String, ColumnStats>();
        }
        return new TableStats(rowCount, columnStatsMap);
    }

    private static Map<String, ColumnStats> convertToColumnStatsMap(Map<String, CatalogColumnStatisticsDataBase> columnStatisticsData) {
        HashMap<String, ColumnStats> columnStatsMap = new HashMap<String, ColumnStats>();
        for (Map.Entry<String, CatalogColumnStatisticsDataBase> entry : columnStatisticsData.entrySet()) {
            ColumnStats columnStats = CatalogTableStatisticsConverter.convertToColumnStats(entry.getValue());
            columnStatsMap.put(entry.getKey(), columnStats);
        }
        return columnStatsMap;
    }

    private static ColumnStats convertToColumnStats(CatalogColumnStatisticsDataBase columnStatisticsData) {
        Long ndv = null;
        Long nullCount = columnStatisticsData.getNullCount();
        Double avgLen = null;
        Integer maxLen = null;
        Number max = null;
        Number min = null;
        if (columnStatisticsData instanceof CatalogColumnStatisticsDataBoolean) {
            CatalogColumnStatisticsDataBoolean booleanData = (CatalogColumnStatisticsDataBoolean)columnStatisticsData;
            avgLen = 1.0;
            maxLen = 1;
            ndv = booleanData.getFalseCount() == 0L && booleanData.getTrueCount() > 0L || booleanData.getFalseCount() > 0L && booleanData.getTrueCount() == 0L ? Long.valueOf(1L) : Long.valueOf(2L);
        } else if (columnStatisticsData instanceof CatalogColumnStatisticsDataLong) {
            CatalogColumnStatisticsDataLong longData = (CatalogColumnStatisticsDataLong)columnStatisticsData;
            ndv = longData.getNdv();
            avgLen = 8.0;
            maxLen = 8;
            max = longData.getMax();
            min = longData.getMin();
        } else if (columnStatisticsData instanceof CatalogColumnStatisticsDataDouble) {
            CatalogColumnStatisticsDataDouble doubleData = (CatalogColumnStatisticsDataDouble)columnStatisticsData;
            ndv = doubleData.getNdv();
            avgLen = 8.0;
            maxLen = 8;
            max = doubleData.getMax();
            min = doubleData.getMin();
        } else if (columnStatisticsData instanceof CatalogColumnStatisticsDataString) {
            CatalogColumnStatisticsDataString strData = (CatalogColumnStatisticsDataString)columnStatisticsData;
            ndv = strData.getNdv();
            avgLen = strData.getAvgLength();
            maxLen = (int)strData.getMaxLength();
        } else if (columnStatisticsData instanceof CatalogColumnStatisticsDataBinary) {
            CatalogColumnStatisticsDataBinary binaryData = (CatalogColumnStatisticsDataBinary)columnStatisticsData;
            avgLen = binaryData.getAvgLength();
            maxLen = (int)binaryData.getMaxLength();
        } else if (columnStatisticsData instanceof CatalogColumnStatisticsDataDate) {
            CatalogColumnStatisticsDataDate dateData = (CatalogColumnStatisticsDataDate)columnStatisticsData;
            ndv = dateData.getNdv();
        } else {
            throw new TableException("Unsupported CatalogColumnStatisticsDataBase: " + columnStatisticsData.getClass().getCanonicalName());
        }
        return new ColumnStats(ndv, nullCount, avgLen, maxLen, max, min);
    }
}

