/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.dataview;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.runtime.dataview.NullAwareMapIterator;
import org.apache.flink.table.runtime.dataview.StateDataView;
import org.apache.flink.util.IterableIterator;

public abstract class StateMapView<N, MK, MV>
extends MapView<MK, MV>
implements StateDataView<N> {
    private static final long serialVersionUID = 1L;

    public static final class NamespacedStateMapViewWithKeysNullable<N, MK, MV>
    extends StateMapViewWithKeysNullable<N, MK, MV> {
        private static final long serialVersionUID = -6915428707804508152L;
        private final InternalMapState<?, N, MK, MV> internalMapState;
        private final InternalValueState<?, N, MV> internalNullState;
        private N namespace;

        public NamespacedStateMapViewWithKeysNullable(InternalMapState<?, N, MK, MV> internalMapState, InternalValueState<?, N, MV> internalNullState) {
            this.internalMapState = internalMapState;
            this.internalNullState = internalNullState;
        }

        @Override
        public void setCurrentNamespace(N namespace) {
            this.namespace = namespace;
        }

        @Override
        protected MapState<MK, MV> getMapState() {
            this.internalMapState.setCurrentNamespace(this.namespace);
            return this.internalMapState;
        }

        @Override
        protected ValueState<MV> getNullState() {
            this.internalNullState.setCurrentNamespace(this.namespace);
            return this.internalNullState;
        }
    }

    public static final class KeyedStateMapViewWithKeysNullable<N, MK, MV>
    extends StateMapViewWithKeysNullable<N, MK, MV> {
        private static final long serialVersionUID = -4222930534937318207L;
        private final MapState<MK, MV> mapState;
        private final ValueState<MV> nullState;

        public KeyedStateMapViewWithKeysNullable(MapState<MK, MV> mapState, ValueState<MV> nullState) {
            this.mapState = mapState;
            this.nullState = nullState;
        }

        @Override
        public void setCurrentNamespace(N namespace) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected MapState<MK, MV> getMapState() {
            return this.mapState;
        }

        @Override
        protected ValueState<MV> getNullState() {
            return this.nullState;
        }
    }

    public static final class NamespacedStateMapViewWithKeysNotNull<N, MK, MV>
    extends StateMapViewWithKeysNotNull<N, MK, MV> {
        private static final long serialVersionUID = -2793150592169689571L;
        private final InternalMapState<?, N, MK, MV> internalMapState;
        private N namespace;

        public NamespacedStateMapViewWithKeysNotNull(InternalMapState<?, N, MK, MV> internalMapState) {
            this.internalMapState = internalMapState;
        }

        @Override
        public void setCurrentNamespace(N namespace) {
            this.namespace = namespace;
        }

        @Override
        protected MapState<MK, MV> getMapState() {
            this.internalMapState.setCurrentNamespace(this.namespace);
            return this.internalMapState;
        }
    }

    public static final class KeyedStateMapViewWithKeysNotNull<N, MK, MV>
    extends StateMapViewWithKeysNotNull<N, MK, MV> {
        private static final long serialVersionUID = 6650061094951931356L;
        private final MapState<MK, MV> mapState;

        public KeyedStateMapViewWithKeysNotNull(MapState<MK, MV> mapState) {
            this.mapState = mapState;
        }

        @Override
        public void setCurrentNamespace(N namespace) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected MapState<MK, MV> getMapState() {
            return this.mapState;
        }
    }

    private static abstract class StateMapViewWithKeysNullable<N, MK, MV>
    extends StateMapView<N, MK, MV> {
        private static final long serialVersionUID = 2605280027745112384L;

        private StateMapViewWithKeysNullable() {
        }

        @Override
        public MV get(MK key) throws Exception {
            if (key == null) {
                return (MV)this.getNullState().value();
            }
            return (MV)this.getMapState().get(key);
        }

        @Override
        public void put(MK key, MV value) throws Exception {
            if (key == null) {
                this.getNullState().update(value);
            } else {
                this.getMapState().put(key, value);
            }
        }

        @Override
        public void putAll(Map<MK, MV> map) throws Exception {
            for (Map.Entry<MK, MV> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void remove(MK key) throws Exception {
            if (key == null) {
                this.getNullState().clear();
            } else {
                this.getMapState().remove(key);
            }
        }

        @Override
        public boolean contains(MK key) throws Exception {
            if (key == null) {
                return this.getNullState().value() != null;
            }
            return this.getMapState().contains(key);
        }

        @Override
        public Iterable<Map.Entry<MK, MV>> entries() throws Exception {
            Iterator iterator = this.iterator();
            return () -> iterator;
        }

        @Override
        public Iterable<MK> keys() throws Exception {
            return new KeysIterable(this.iterator());
        }

        @Override
        public Iterable<MV> values() throws Exception {
            return new ValuesIterable(this.iterator());
        }

        @Override
        public Iterator<Map.Entry<MK, MV>> iterator() throws Exception {
            return new NullAwareMapIterator(this.getMapState().iterator(), new NullMapEntryImpl());
        }

        @Override
        public void clear() {
            this.getMapState().clear();
            this.getNullState().clear();
        }

        protected abstract MapState<MK, MV> getMapState();

        protected abstract ValueState<MV> getNullState();

        private class ValuesIterable
        implements IterableIterator<MV> {
            private final Iterator<Map.Entry<MK, MV>> iterator;

            private ValuesIterable(Iterator<Map.Entry<MK, MV>> iterator) {
                this.iterator = iterator;
            }

            public Iterator<MV> iterator() {
                return this;
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public MV next() {
                return this.iterator.next().getValue();
            }
        }

        private class KeysIterable
        implements IterableIterator<MK> {
            private final Iterator<Map.Entry<MK, MV>> iterator;

            private KeysIterable(Iterator<Map.Entry<MK, MV>> iterator) {
                this.iterator = iterator;
            }

            public Iterator<MK> iterator() {
                return this;
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public MK next() {
                return this.iterator.next().getKey();
            }
        }

        private class NullMapEntryImpl
        implements NullAwareMapIterator.NullMapEntry<MK, MV> {
            private NullMapEntryImpl() {
            }

            @Override
            public MV getValue() {
                try {
                    return StateMapViewWithKeysNullable.this.getNullState().value();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public MV setValue(MV value) {
                try {
                    Object oldValue = StateMapViewWithKeysNullable.this.getNullState().value();
                    StateMapViewWithKeysNullable.this.getNullState().update(value);
                    return oldValue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                StateMapViewWithKeysNullable.this.getNullState().clear();
            }
        }
    }

    private static abstract class StateMapViewWithKeysNotNull<N, MK, MV>
    extends StateMapView<N, MK, MV> {
        private static final long serialVersionUID = 2605280027745112384L;
        private final Map<MK, MV> emptyState = Collections.emptyMap();

        private StateMapViewWithKeysNotNull() {
        }

        protected abstract MapState<MK, MV> getMapState();

        @Override
        public MV get(MK key) throws Exception {
            return (MV)this.getMapState().get(key);
        }

        @Override
        public void put(MK key, MV value) throws Exception {
            this.getMapState().put(key, value);
        }

        @Override
        public void putAll(Map<MK, MV> map) throws Exception {
            this.getMapState().putAll(map);
        }

        @Override
        public void remove(MK key) throws Exception {
            this.getMapState().remove(key);
        }

        @Override
        public boolean contains(MK key) throws Exception {
            return this.getMapState().contains(key);
        }

        @Override
        public Iterable<Map.Entry<MK, MV>> entries() throws Exception {
            Set<Map.Entry<MK, MV>> original = this.getMapState().entries();
            return original != null ? original : this.emptyState.entrySet();
        }

        @Override
        public Iterable<MK> keys() throws Exception {
            Set<MK> original = this.getMapState().keys();
            return original != null ? original : this.emptyState.keySet();
        }

        @Override
        public Iterable<MV> values() throws Exception {
            Collection<MV> original = this.getMapState().values();
            return original != null ? original : this.emptyState.values();
        }

        @Override
        public Iterator<Map.Entry<MK, MV>> iterator() throws Exception {
            Iterator<Map.Entry<MK, MV>> original = this.getMapState().iterator();
            return original != null ? original : this.emptyState.entrySet().iterator();
        }

        @Override
        public void clear() {
            this.getMapState().clear();
        }
    }
}

