/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.sources;

import java.sql.Timestamp;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedFieldReference;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.expressions.RexNodeConverter;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.sources.DefinedFieldMapping;
import org.apache.flink.table.sources.DefinedProctimeAttribute;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class TableSourceUtil$ {
    public static final TableSourceUtil$ MODULE$;

    static {
        new TableSourceUtil$();
    }

    public int[] computeIndexMapping(TableSource<?> tableSource, boolean isStreamTable, Option<int[]> selectedFields) {
        DataType[] dataTypeArray;
        String[] tableFieldNames;
        String[] stringArray;
        TableSchema tableSchema = tableSource.getTableSchema();
        if (selectedFields.isDefined()) {
            String[] names = tableSchema.getFieldNames();
            stringArray = (String[])Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).map((Function1)new Serializable(names){
                public static final long serialVersionUID = 0L;
                private final String[] names$1;

                public final String apply(int x$1) {
                    return this.names$1[x$1];
                }
                {
                    this.names$1 = names$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        } else {
            stringArray = tableFieldNames = tableSchema.getFieldNames();
        }
        if (selectedFields.isDefined()) {
            DataType[] types = tableSchema.getFieldDataTypes();
            dataTypeArray = (DataType[])Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).map((Function1)new Serializable(types){
                public static final long serialVersionUID = 0L;
                private final DataType[] types$1;

                public final DataType apply(int x$2) {
                    return this.types$1[x$2];
                }
                {
                    this.types$1 = types$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
        } else {
            dataTypeArray = tableSchema.getFieldDataTypes();
        }
        DataType[] tableFieldTypes = dataTypeArray;
        String[] rowtimeAttributes = this.getRowtimeAttributes(tableSource);
        Option<String> proctimeAttributes = this.getProctimeAttribute(tableSource);
        int[] mapping = (int[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])tableFieldTypes).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LogicalType apply(DataType x$3) {
                return x$3.getLogicalType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)))).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])tableFieldNames), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(tableSource, isStreamTable, rowtimeAttributes, proctimeAttributes){
            public static final long serialVersionUID = 0L;
            private final TableSource tableSource$1;
            private final boolean isStreamTable$1;
            private final String[] rowtimeAttributes$1;
            private final Option proctimeAttributes$1;

            /*
             * WARNING - void declaration
             */
            public final int apply(Tuple2<LogicalType, String> x0$1) {
                Tuple2<LogicalType, String> tuple2;
                block8: {
                    Tuple3<String, Object, TypeInformation<?>> tuple3;
                    block9: {
                        void var17_17;
                        void var19_19;
                        LogicalType logicalType;
                        String name;
                        block10: {
                            int n;
                            block6: {
                                Tuple3 tuple32;
                                block7: {
                                    block5: {
                                        String string;
                                        tuple2 = x0$1;
                                        if (tuple2 == null) break block5;
                                        String name2 = (String)tuple2._2();
                                        if (!(tuple2._1() instanceof TimestampType) || name2 == null || !this.proctimeAttributes$1.contains((Object)(string = name2))) break block5;
                                        n = this.isStreamTable$1 ? -2 : -4;
                                        break block6;
                                    }
                                    if (tuple2 == null) break block7;
                                    String name3 = (String)tuple2._2();
                                    if (!(tuple2._1() instanceof TimestampType) || name3 == null) break block7;
                                    String string = name3;
                                    if (!Predef$.MODULE$.refArrayOps((Object[])this.rowtimeAttributes$1).contains((Object)string)) break block7;
                                    n = this.isStreamTable$1 ? -1 : -3;
                                    break block6;
                                }
                                if (tuple2 == null) break block8;
                                LogicalType t = (LogicalType)tuple2._1();
                                name = (String)tuple2._2();
                                if (t == null) break block8;
                                logicalType = t;
                                if (this.proctimeAttributes$1.contains((Object)name)) {
                                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing time field '", "' has invalid type ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, logicalType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing time attributes must be of TimestampType."})).s((Seq)Nil$.MODULE$)).toString());
                                }
                                if (Predef$.MODULE$.refArrayOps((Object[])this.rowtimeAttributes$1).contains((Object)name)) {
                                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rowtime field '", "' has invalid type ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, logicalType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rowtime attributes must be of TimestampType."})).s((Seq)Nil$.MODULE$)).toString());
                                }
                                tuple3 = TableSourceUtil$.MODULE$.org$apache$flink$table$planner$sources$TableSourceUtil$$resolveInputField(name, this.tableSource$1);
                                if (tuple3 == null) break block9;
                                String physicalName = (String)tuple3._1();
                                int idx = BoxesRunTime.unboxToInt((Object)tuple3._2());
                                TypeInformation tpe = (TypeInformation)tuple3._3();
                                Tuple3 tuple33 = tuple32 = new Tuple3((Object)physicalName, (Object)BoxesRunTime.boxToInteger((int)idx), (Object)tpe);
                                String physicalName2 = (String)tuple33._1();
                                int idx2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
                                TypeInformation tpe2 = (TypeInformation)tuple33._3();
                                if (!PlannerTypeUtils.isAssignable(TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType(tpe2), logicalType)) break block10;
                                n = idx2;
                            }
                            return n;
                        }
                        throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type ", " of table field '", "' does not "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logicalType, name}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"match with type ", " of the field '", "' of the TableSource return type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var19_19, var17_17}))).toString());
                    }
                    throw new MatchError(tuple3);
                }
                throw new MatchError(tuple2);
            }
            {
                this.tableSource$1 = tableSource$1;
                this.isStreamTable$1 = isStreamTable$1;
                this.rowtimeAttributes$1 = rowtimeAttributes$1;
                this.proctimeAttributes$1 = proctimeAttributes$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        TypeInformation<?> inputType = TypeInfoDataTypeConverter.fromDataTypeToTypeInfo(tableSource.getProducedDataType());
        if (!(inputType instanceof CompositeType) && Predef$.MODULE$.intArrayOps(mapping).count((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$5) {
                return this.apply$mcZI$sp(x$5);
            }

            public boolean apply$mcZI$sp(int x$5) {
                return x$5 >= 0;
            }
        }) > 1) {
            throw new ValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"More than one table field matched to atomic input type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputType})));
        }
        return mapping;
    }

    public RelDataType getRelDataType(TableSource<?> tableSource, Option<int[]> selectedFields, boolean streaming, FlinkTypeFactory typeFactory) {
        Tuple2 tuple2;
        String[] fieldNames = tableSource.getTableSchema().getFieldNames();
        ObjectRef fieldTypes = ObjectRef.create((Object)((LogicalType[])Predef$.MODULE$.refArrayOps((Object[])tableSource.getTableSchema().getFieldDataTypes()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LogicalType apply(DataType x$1) {
                return LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(x$1);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)))));
        if (streaming) {
            String[] rowtimeAttributes = this.getRowtimeAttributes(tableSource);
            Option<String> proctimeAttributes = this.getProctimeAttribute(tableSource);
            Predef$.MODULE$.refArrayOps((Object[])rowtimeAttributes).foreach((Function1)new Serializable(fieldNames, fieldTypes){
                public static final long serialVersionUID = 0L;
                private final String[] fieldNames$1;
                private final ObjectRef fieldTypes$1;

                public final void apply(String rowtimeField) {
                    int idx = Predef$.MODULE$.refArrayOps((Object[])this.fieldNames$1).indexOf((Object)rowtimeField);
                    TimestampType rowtimeType = new TimestampType(true, TimestampKind.ROWTIME, 3);
                    this.fieldTypes$1.elem = (LogicalType[])Predef$.MODULE$.refArrayOps((Object[])((LogicalType[])this.fieldTypes$1.elem)).patch(idx, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimestampType[]{rowtimeType})), 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
                }
                {
                    this.fieldNames$1 = fieldNames$1;
                    this.fieldTypes$1 = fieldTypes$1;
                }
            });
            proctimeAttributes.foreach((Function1)new Serializable(fieldNames, fieldTypes){
                public static final long serialVersionUID = 0L;
                private final String[] fieldNames$1;
                private final ObjectRef fieldTypes$1;

                public final void apply(String proctimeField) {
                    int idx = Predef$.MODULE$.refArrayOps((Object[])this.fieldNames$1).indexOf((Object)proctimeField);
                    TimestampType proctimeType = new TimestampType(true, TimestampKind.PROCTIME, 3);
                    this.fieldTypes$1.elem = (LogicalType[])Predef$.MODULE$.refArrayOps((Object[])((LogicalType[])this.fieldTypes$1.elem)).patch(idx, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimestampType[]{proctimeType})), 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
                }
                {
                    this.fieldNames$1 = fieldNames$1;
                    this.fieldTypes$1 = fieldTypes$1;
                }
            });
        }
        Tuple2 tuple22 = tuple2 = selectedFields.isDefined() ? new Tuple2(Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).map((Function1)new Serializable(fieldNames){
            public static final long serialVersionUID = 0L;
            private final String[] fieldNames$1;

            public final String apply(int x$6) {
                return this.fieldNames$1[x$6];
            }
            {
                this.fieldNames$1 = fieldNames$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).map((Function1)new Serializable(fieldTypes){
            public static final long serialVersionUID = 0L;
            private final ObjectRef fieldTypes$1;

            public final LogicalType apply(int x$7) {
                return ((LogicalType[])this.fieldTypes$1.elem)[x$7];
            }
            {
                this.fieldTypes$1 = fieldTypes$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)))) : new Tuple2((Object)fieldNames, (Object)((LogicalType[])fieldTypes.elem));
        if (tuple2 != null) {
            Tuple2 tuple23;
            String[] selectedFieldNames = (String[])tuple2._1();
            LogicalType[] selectedFieldTypes = (LogicalType[])tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)selectedFieldNames, (Object)selectedFieldTypes);
            String[] selectedFieldNames2 = (String[])tuple24._1();
            LogicalType[] selectedFieldTypes2 = (LogicalType[])tuple24._2();
            return typeFactory.buildRelNodeRowType((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])selectedFieldNames2), (Seq<LogicalType>)Predef$.MODULE$.wrapRefArray((Object[])selectedFieldTypes2));
        }
        throw new MatchError((Object)tuple2);
    }

    public Option<RowtimeAttributeDescriptor> getRowtimeAttributeDescriptor(TableSource<?> tableSource, Option<int[]> selectedFields) {
        None$ none$;
        TableSource<?> tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedRowtimeAttributes) {
            Object object;
            DefinedRowtimeAttributes definedRowtimeAttributes = (DefinedRowtimeAttributes)((Object)tableSource2);
            List<RowtimeAttributeDescriptor> descriptors = definedRowtimeAttributes.getRowtimeAttributeDescriptors();
            if (descriptors.size() == 0) {
                object = None$.MODULE$;
            } else {
                if (descriptors.size() > 1) {
                    throw new ValidationException("Table with has more than a single rowtime attribute..");
                }
                if (selectedFields.isEmpty()) {
                    object = new Some((Object)descriptors.get(0));
                } else {
                    RowtimeAttributeDescriptor descriptor = descriptors.get(0);
                    int fieldIdx = Predef$.MODULE$.refArrayOps((Object[])tableSource.getTableSchema().getFieldNames()).indexOf((Object)descriptor.getAttributeName());
                    object = Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).contains((Object)BoxesRunTime.boxToInteger((int)fieldIdx)) ? new Some((Object)descriptor) : None$.MODULE$;
                }
            }
            none$ = object;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<RexNode> getRowtimeExtractionExpression(TableSource<?> tableSource, Option<int[]> selectedFields, RelOptCluster cluster, RelBuilder relBuilder) {
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)cluster.getTypeFactory();
        Option<RowtimeAttributeDescriptor> rowtimeDesc = this.getRowtimeAttributeDescriptor(tableSource, selectedFields);
        return rowtimeDesc.map((Function1)new Serializable(tableSource, cluster, relBuilder, typeFactory){
            public static final long serialVersionUID = 0L;
            private final TableSource tableSource$2;
            private final RelOptCluster cluster$1;
            private final RelBuilder relBuilder$1;
            private final FlinkTypeFactory typeFactory$1;

            public final RexNode apply(RowtimeAttributeDescriptor r) {
                ResolvedFieldReference[] resolvedFieldReferenceArray;
                TimestampExtractor tsExtractor = r.getTimestampExtractor();
                if (Predef$.MODULE$.refArrayOps((Object[])tsExtractor.getArgumentFields()).nonEmpty()) {
                    Tuple3<String, Object, TypeInformation<?>>[] resolvedFields = TableSourceUtil$.MODULE$.org$apache$flink$table$planner$sources$TableSourceUtil$$resolveInputFields(tsExtractor.getArgumentFields(), this.tableSource$2);
                    this.relBuilder$1.push(TableSourceUtil$.MODULE$.org$apache$flink$table$planner$sources$TableSourceUtil$$createSchemaRelNode$1(resolvedFields, this.cluster$1, this.typeFactory$1));
                    resolvedFieldReferenceArray = (ResolvedFieldReference[])Predef$.MODULE$.refArrayOps((Object[])resolvedFields).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ResolvedFieldReference apply(Tuple3<String, Object, TypeInformation<?>> f) {
                            return new ResolvedFieldReference((String)f._1(), (TypeInformation)f._3(), BoxesRunTime.unboxToInt((Object)f._2()));
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ResolvedFieldReference.class)));
                } else {
                    resolvedFieldReferenceArray = new ResolvedFieldReference[]{};
                }
                ResolvedFieldReference[] fieldAccesses = resolvedFieldReferenceArray;
                Expression expression2 = tsExtractor.getExpression(fieldAccesses);
                UnresolvedCallExpression castExpression = ApiExpressionUtils.unresolvedCall(BuiltInFunctionDefinitions.REINTERPRET_CAST, expression2, ApiExpressionUtils.typeLiteral(DataTypes.TIMESTAMP(3).bridgedTo(Timestamp.class)), ApiExpressionUtils.valueLiteral(BoxesRunTime.boxToBoolean((boolean)false)));
                RexNode rexExpression = castExpression.accept(new RexNodeConverter(this.relBuilder$1));
                this.relBuilder$1.clear();
                return rexExpression;
            }
            {
                this.tableSource$2 = tableSource$2;
                this.cluster$1 = cluster$1;
                this.relBuilder$1 = relBuilder$1;
                this.typeFactory$1 = typeFactory$1;
            }
        });
    }

    private String[] getRowtimeAttributes(TableSource<?> tableSource) {
        String[] stringArray;
        TableSource<?> tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedRowtimeAttributes) {
            DefinedRowtimeAttributes definedRowtimeAttributes = (DefinedRowtimeAttributes)((Object)tableSource2);
            stringArray = (String[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(definedRowtimeAttributes.getRowtimeAttributeDescriptors()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(RowtimeAttributeDescriptor x$11) {
                    return x$11.getAttributeName();
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        } else {
            stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        }
        return stringArray;
    }

    private Option<String> getProctimeAttribute(TableSource<?> tableSource) {
        DefinedProctimeAttribute definedProctimeAttribute;
        TableSource<?> tableSource2 = tableSource;
        Object object = tableSource2 instanceof DefinedProctimeAttribute && (definedProctimeAttribute = (DefinedProctimeAttribute)((Object)tableSource2)).getProctimeAttribute() != null ? new Some((Object)definedProctimeAttribute.getProctimeAttribute()) : None$.MODULE$;
        return object;
    }

    public Tuple3<String, Object, TypeInformation<?>> org$apache$flink$table$planner$sources$TableSourceUtil$$resolveInputField(String fieldName, TableSource<?> tableSource) {
        Tuple3 tuple3;
        DefinedFieldMapping definedFieldMapping;
        TypeInformation<?> returnType = TypeInfoDataTypeConverter.fromDataTypeToTypeInfo(tableSource.getProducedDataType());
        TableSource<?> tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedFieldMapping && (definedFieldMapping = (DefinedFieldMapping)((Object)tableSource2)).getFieldMapping() != null) {
            String resolvedFieldName = definedFieldMapping.getFieldMapping().get(fieldName);
            if (resolvedFieldName == null) {
                throw new ValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Field '", "' could not be resolved by the field mapping."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldName})));
            }
            tuple3 = this.lookupField$1(resolvedFieldName, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table field '", "' was resolved to TableSource return type field "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "', but field '", "' was not found in the return "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resolvedFieldName, resolvedFieldName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"type ", " of the TableSource. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{returnType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please verify the field mapping of the TableSource."})).s((Seq)Nil$.MODULE$)).toString(), returnType);
        } else {
            tuple3 = this.lookupField$1(fieldName, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table field '", "' was not found in the return type ", " of the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldName, returnType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TableSource."})).s((Seq)Nil$.MODULE$)).toString(), returnType);
        }
        return tuple3;
    }

    public Tuple3<String, Object, TypeInformation<?>>[] org$apache$flink$table$planner$sources$TableSourceUtil$$resolveInputFields(String[] fieldNames, TableSource<?> tableSource) {
        return (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])fieldNames).map((Function1)new Serializable(tableSource){
            public static final long serialVersionUID = 0L;
            private final TableSource tableSource$3;

            public final Tuple3<String, Object, TypeInformation<?>> apply(String x$12) {
                return TableSourceUtil$.MODULE$.org$apache$flink$table$planner$sources$TableSourceUtil$$resolveInputField(x$12, this.tableSource$3);
            }
            {
                this.tableSource$3 = tableSource$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
    }

    public final RelNode org$apache$flink$table$planner$sources$TableSourceUtil$$createSchemaRelNode$1(Tuple3[] fields2, RelOptCluster cluster$1, FlinkTypeFactory typeFactory$1) {
        int maxIdx = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])fields2).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple3<String, Object, TypeInformation<?>> x$9) {
                return BoxesRunTime.unboxToInt((Object)x$9._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).max((Ordering)Ordering.Int$.MODULE$));
        Map idxMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])fields2).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<String, LogicalType>> apply(Tuple3<String, Object, TypeInformation<?>> f) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f._2()), (Object)new Tuple2(f._1(), (Object)TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType((TypeInformation)f._3())));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))));
        Tuple2 tuple2 = ((GenericTraversableTemplate)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxIdx).map((Function1)new Serializable(idxMap){
            public static final long serialVersionUID = 0L;
            private final Map idxMap$1;

            public final Tuple2<String, LogicalType> apply(int i) {
                return (Tuple2)this.idxMap$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)i), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, TinyIntType> apply() {
                        return new Tuple2((Object)"", (Object)new TinyIntType());
                    }
                });
            }
            {
                this.idxMap$1 = idxMap$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            IndexedSeq physicalFields = (IndexedSeq)tuple2._1();
            IndexedSeq physicalTypes = (IndexedSeq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)physicalFields, (Object)physicalTypes);
            IndexedSeq physicalFields2 = (IndexedSeq)tuple23._1();
            IndexedSeq physicalTypes2 = (IndexedSeq)tuple23._2();
            RelDataType physicalSchema = typeFactory$1.buildRelNodeRowType((Seq<String>)physicalFields2, (Seq<LogicalType>)physicalTypes2);
            return LogicalValues.create(cluster$1, physicalSchema, ImmutableList.<ImmutableList<RexLiteral>>of());
        }
        throw new MatchError((Object)tuple2);
    }

    private final Tuple3 lookupField$1(String fieldName, String failMsg, TypeInformation returnType$1) {
        TypeInformation typeInformation;
        block6: {
            Tuple3 tuple3;
            block5: {
                block4: {
                    typeInformation = returnType$1;
                    if (!(typeInformation instanceof CompositeType)) break block4;
                    CompositeType compositeType = (CompositeType)typeInformation;
                    int idx = compositeType.getFieldIndex(fieldName);
                    if (idx < 0) {
                        throw new ValidationException(failMsg);
                    }
                    tuple3 = new Tuple3((Object)fieldName, (Object)BoxesRunTime.boxToInteger((int)idx), (Object)compositeType.getTypeAt(idx));
                    break block5;
                }
                if (typeInformation == null) break block6;
                TypeInformation typeInformation2 = typeInformation;
                tuple3 = new Tuple3((Object)fieldName, (Object)BoxesRunTime.boxToInteger((int)0), (Object)typeInformation2);
            }
            return tuple3;
        }
        throw new MatchError((Object)typeInformation);
    }

    private TableSourceUtil$() {
        MODULE$ = this;
    }
}

