/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.List;
import java.util.TimeZone;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.util.Util;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil$;
import org.apache.flink.table.planner.plan.utils.InputRefVisitor;
import org.apache.flink.table.planner.plan.utils.PartitionPruner$;
import org.apache.flink.table.planner.plan.utils.RefFieldAccessorVisitor;
import org.apache.flink.table.planner.plan.utils.RexNodeToExpressionConverter;
import org.apache.flink.table.planner.utils.Logging;
import org.apache.flink.table.planner.utils.Logging$class;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RexNodeExtractor$
implements Logging {
    public static final RexNodeExtractor$ MODULE$;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    static {
        new RexNodeExtractor$();
    }

    private Logger LOG$lzycompute() {
        RexNodeExtractor$ rexNodeExtractor$ = this;
        synchronized (rexNodeExtractor$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    public int[] extractRefInputFields(List<RexNode> exprs) {
        InputRefVisitor visitor = new InputRefVisitor();
        JavaConversions$.MODULE$.asScalaBuffer(exprs).foreach((Function1)new Serializable(visitor){
            public static final long serialVersionUID = 0L;
            private final InputRefVisitor visitor$1;

            public final void apply(RexNode x$1) {
                x$1.accept(this.visitor$1);
            }
            {
                this.visitor$1 = visitor$1;
            }
        });
        return visitor.getFields();
    }

    public String[][] extractRefNestedInputFields(List<RexNode> exprs, int[] usedFields) {
        RefFieldAccessorVisitor visitor = new RefFieldAccessorVisitor(usedFields);
        JavaConversions$.MODULE$.asScalaBuffer(exprs).foreach((Function1)new Serializable(visitor){
            public static final long serialVersionUID = 0L;
            private final RefFieldAccessorVisitor visitor$2;

            public final void apply(RexNode x$2) {
                x$2.accept(this.visitor$2);
            }
            {
                this.visitor$2 = visitor$2;
            }
        });
        return visitor.getProjectedFields();
    }

    public Tuple2<Expression[], RexNode[]> extractConjunctiveConditions(RexNode expr, int maxCnfNodeCount, List<String> inputFieldNames, RexBuilder rexBuilder, FunctionCatalog functionCatalog, TimeZone timeZone) {
        RexNode cnf = FlinkRexUtil$.MODULE$.toCnf(rexBuilder, maxCnfNodeCount, expr);
        List<RexNode> conjunctions = RelOptUtil.conjunctions(cnf);
        ArrayBuffer convertedExpressions = new ArrayBuffer();
        ArrayBuffer unconvertedRexNodes = new ArrayBuffer();
        String[] inputNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(inputFieldNames).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        RexNodeToExpressionConverter converter = new RexNodeToExpressionConverter(inputNames, functionCatalog, timeZone);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(conjunctions).asScala()).foreach((Function1)new Serializable(convertedExpressions, unconvertedRexNodes, converter){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer convertedExpressions$1;
            private final ArrayBuffer unconvertedRexNodes$1;
            private final RexNodeToExpressionConverter converter$1;

            public final ArrayBuffer<? super Expression> apply(RexNode rex) {
                Option<Expression> option;
                block4: {
                    ArrayBuffer arrayBuffer;
                    block3: {
                        block2: {
                            option = rex.accept(this.converter$1);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Expression expression2 = (Expression)some.x();
                            arrayBuffer = this.convertedExpressions$1.$plus$eq((Object)expression2);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        arrayBuffer = this.unconvertedRexNodes$1.$plus$eq((Object)rex);
                    }
                    return arrayBuffer;
                }
                throw new MatchError(option);
            }
            {
                this.convertedExpressions$1 = convertedExpressions$1;
                this.unconvertedRexNodes$1 = unconvertedRexNodes$1;
                this.converter$1 = converter$1;
            }
        });
        return new Tuple2(convertedExpressions.toArray(ClassTag$.MODULE$.apply(Expression.class)), unconvertedRexNodes.toArray(ClassTag$.MODULE$.apply(RexNode.class)));
    }

    public Tuple2<RexNode, RexNode> extractPartitionPredicates(RexNode expr, int maxCnfNodeCount, String[] inputFieldNames, RexBuilder rexBuilder, String[] partitionFieldNames) {
        RexNode cnf = FlinkRexUtil$.MODULE$.toCnf(rexBuilder, maxCnfNodeCount, expr);
        List<RexNode> conjunctions = RelOptUtil.conjunctions(cnf);
        Tuple2 tuple2 = JavaConversions$.MODULE$.asScalaBuffer(conjunctions).partition((Function1)new Serializable(inputFieldNames, partitionFieldNames){
            public static final long serialVersionUID = 0L;
            private final String[] inputFieldNames$1;
            private final String[] partitionFieldNames$1;

            public final boolean apply(RexNode x$3) {
                return RexNodeExtractor$.MODULE$.org$apache$flink$table$planner$plan$utils$RexNodeExtractor$$isSupportedPartitionPredicate(x$3, this.partitionFieldNames$1, this.inputFieldNames$1);
            }
            {
                this.inputFieldNames$1 = inputFieldNames$1;
                this.partitionFieldNames$1 = partitionFieldNames$1;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            Buffer partitionPredicates = (Buffer)tuple2._1();
            Buffer nonPartitionPredicates = (Buffer)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitionPredicates, (Object)nonPartitionPredicates);
            Buffer partitionPredicates2 = (Buffer)tuple23._1();
            Buffer nonPartitionPredicates2 = (Buffer)tuple23._2();
            RexNode partitionPredicate = RexUtil.composeConjunction(rexBuilder, JavaConversions$.MODULE$.bufferAsJavaList(partitionPredicates2));
            RexNode nonPartitionPredicate = RexUtil.composeConjunction(rexBuilder, JavaConversions$.MODULE$.bufferAsJavaList(nonPartitionPredicates2));
            return new Tuple2((Object)partitionPredicate, (Object)nonPartitionPredicate);
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean org$apache$flink$table$planner$plan$utils$RexNodeExtractor$$isSupportedPartitionPredicate(RexNode predicate, String[] partitionFieldNames, String[] inputFieldNames) {
        boolean bl;
        RexVisitorImpl<Object> visitor = new RexVisitorImpl<Object>(partitionFieldNames, inputFieldNames){
            private final String[] partitionFieldNames$2;
            private final String[] inputFieldNames$2;

            public boolean visitInputRef(RexInputRef inputRef) {
                String fieldName = this.inputFieldNames$2[inputRef.getIndex()];
                LogicalTypeRoot typeRoot = FlinkTypeFactory$.MODULE$.toLogicalType(inputRef.getType()).getTypeRoot();
                if (Predef$.MODULE$.refArrayOps((Object[])this.partitionFieldNames$2).contains((Object)fieldName) && Predef$.MODULE$.refArrayOps((Object[])PartitionPruner$.MODULE$.supportedPartitionFieldTypes()).contains((Object)((Object)typeRoot))) {
                    return BoxesRunTime.unboxToBoolean(super.visitInputRef(inputRef));
                }
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitLocalRef(RexLocalRef localRef) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitOver(RexOver over2) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitCorrelVariable(RexCorrelVariable correlVariable) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitDynamicParam(RexDynamicParam dynamicParam) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitRangeRef(RexRangeRef rangeRef) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitFieldAccess(RexFieldAccess fieldAccess) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitSubQuery(RexSubQuery subQuery) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitTableInputRef(RexTableInputRef ref) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitPatternFieldRef(RexPatternFieldRef fieldRef) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }
            {
                this.partitionFieldNames$2 = partitionFieldNames$2;
                this.inputFieldNames$2 = inputFieldNames$2;
                super(true);
            }
        };
        try {
            predicate.accept(visitor);
            bl = true;
        }
        catch (Util.FoundOne foundOne) {
            bl = false;
        }
        return bl;
    }

    private RexNodeExtractor$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

