/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.plan.utils.SortUtil$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class OverAggregateUtil$ {
    public static final OverAggregateUtil$ MODULE$;

    static {
        new OverAggregateUtil$();
    }

    public int calcOriginInputRows(Window logicWindow) {
        return logicWindow.getRowType().getFieldCount() - ((SeqLike)JavaConversions$.MODULE$.asScalaBuffer(logicWindow.groups).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Buffer<Window.RexWinAggCall> apply(Window.Group x$1) {
                return JavaConversions$.MODULE$.asScalaBuffer(x$1.aggCalls);
            }
        }, Buffer$.MODULE$.canBuildFrom())).size();
    }

    public long getLongBoundary(Window logicWindow, RexWindowBound windowBound) {
        return Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)this.getBoundary(logicWindow, windowBound)));
    }

    public Object getBoundary(Window logicWindow, RexWindowBound windowBound) {
        Number number;
        if (windowBound.isCurrentRow()) {
            number = BoxesRunTime.boxToLong((long)0L);
        } else {
            RexInputRef ref = (RexInputRef)windowBound.getOffset();
            int boundIndex = ref.getIndex() - this.calcOriginInputRows(logicWindow);
            int flag = windowBound.isPreceding() ? -1 : 1;
            RexLiteral literal = (RexLiteral)logicWindow.constants.get(boundIndex);
            SqlTypeName sqlTypeName = literal.getType().getSqlTypeName();
            Number number2 = ((Object)((Object)SqlTypeName.DECIMAL)).equals((Object)sqlTypeName) ? ((BigDecimal)literal.getValue3()).multiply(new BigDecimal(flag)) : BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(literal.getValueAs(Long.class)) * (long)flag));
            number = number2;
        }
        return number;
    }

    public RelCollation createCollation(Window.Group group) {
        int[] groupSet = group.keys.toArray();
        List<RelFieldCollation> collations = group.orderKeys.getFieldCollations();
        Tuple3<int[], boolean[], boolean[]> tuple3 = SortUtil$.MODULE$.getKeysAndOrders((Seq<RelFieldCollation>)JavaConversions$.MODULE$.asScalaBuffer(collations));
        if (tuple3 != null) {
            RelCollation relCollation;
            int[] orderKeyIndexes;
            int[] nArray;
            int[] orderKeyIndexes2 = nArray = (orderKeyIndexes = (int[])tuple3._1());
            if (Predef$.MODULE$.intArrayOps(groupSet).nonEmpty() || Predef$.MODULE$.intArrayOps(orderKeyIndexes2).nonEmpty()) {
                Buffer collectionIndexes = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(collations).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(RelFieldCollation x$2) {
                        return x$2.getFieldIndex();
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                int[] intersectIds = (int[])Predef$.MODULE$.intArrayOps(orderKeyIndexes2).intersect((GenSeq)Predef$.MODULE$.wrapIntArray(groupSet));
                Tuple3[] groupCollation = (Tuple3[])Predef$.MODULE$.intArrayOps(groupSet).map((Function1)new Serializable(collations, collectionIndexes, intersectIds){
                    public static final long serialVersionUID = 0L;
                    private final List collations$1;
                    private final Buffer collectionIndexes$1;
                    private final int[] intersectIds$1;

                    public final Tuple3<Object, RelFieldCollation.Direction, RelFieldCollation.NullDirection> apply(int idx) {
                        Tuple3 tuple3;
                        if (Predef$.MODULE$.intArrayOps(this.intersectIds$1).contains((Object)BoxesRunTime.boxToInteger((int)idx))) {
                            int index = this.collectionIndexes$1.indexOf((Object)BoxesRunTime.boxToInteger((int)idx));
                            RelFieldCollation collation = (RelFieldCollation)this.collations$1.get(index);
                            tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)collation.getFieldIndex()), (Object)((Object)collation.getDirection()), (Object)((Object)collation.nullDirection));
                        } else {
                            tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)idx), (Object)((Object)RelFieldCollation.Direction.ASCENDING), (Object)((Object)RelFieldCollation.NullDirection.FIRST));
                        }
                        return tuple3;
                    }
                    {
                        this.collations$1 = collations$1;
                        this.collectionIndexes$1 = collectionIndexes$1;
                        this.intersectIds$1 = intersectIds$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
                Buffer orderCollation = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(collations).filter((Function1)new Serializable(intersectIds){
                    public static final long serialVersionUID = 0L;
                    private final int[] intersectIds$1;

                    public final boolean apply(RelFieldCollation c) {
                        return !Predef$.MODULE$.intArrayOps(this.intersectIds$1).contains((Object)BoxesRunTime.boxToInteger((int)c.getFieldIndex()));
                    }
                    {
                        this.intersectIds$1 = intersectIds$1;
                    }
                })).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Object, RelFieldCollation.Direction, RelFieldCollation.NullDirection> apply(RelFieldCollation c) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)c.getFieldIndex()), (Object)((Object)c.getDirection()), (Object)((Object)c.nullDirection));
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                ArrayList<RelFieldCollation> fields2 = new ArrayList<RelFieldCollation>();
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])groupCollation).$plus$plus((GenTraversableOnce)orderCollation, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)))).foreach((Function1)new Serializable(fields2){
                    public static final long serialVersionUID = 0L;
                    private final ArrayList fields$1;

                    public final boolean apply(Tuple3<Object, RelFieldCollation.Direction, RelFieldCollation.NullDirection> field) {
                        return this.fields$1.add(FlinkRelOptUtil$.MODULE$.ofRelFieldCollation(BoxesRunTime.unboxToInt((Object)field._1()), (RelFieldCollation.Direction)((Object)field._2()), (RelFieldCollation.NullDirection)((Object)field._3())));
                    }
                    {
                        this.fields$1 = fields$1;
                    }
                });
                relCollation = RelCollations.of(fields2);
            } else {
                relCollation = RelCollations.EMPTY;
            }
            return relCollation;
        }
        throw new MatchError(tuple3);
    }

    public boolean needCollationTrait(Window overWindow, Window.Group group) {
        boolean bl;
        if (!group.lowerBound.isPreceding() && !group.upperBound.isFollowing() && group.isRows) {
            long offsetLower = BoxesRunTime.unboxToLong((Object)this.getBoundary(overWindow, group.lowerBound));
            long offsetUpper = BoxesRunTime.unboxToLong((Object)this.getBoundary(overWindow, group.upperBound));
            bl = offsetLower != 0L || offsetUpper != 0L || !group.orderKeys.getFieldCollations().isEmpty();
        } else {
            bl = true;
        }
        return bl;
    }

    private OverAggregateUtil$() {
        MODULE$ = this;
    }
}

