/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecSortMergeJoin;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchExecJoinRuleBase;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchExecJoinRuleBase$;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchExecJoinRuleBase$class;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchExecSortMergeJoinRule$;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001+\tQ\")\u0019;dQ\u0016CXmY*peRlUM]4f\u0015>LgNU;mK*\u00111\u0001B\u0001\u0006E\u0006$8\r\u001b\u0006\u0003\u000b\u0019\t\u0001\u0002\u001d5zg&\u001c\u0017\r\u001c\u0006\u0003\u000f!\tQA];mKNT!!\u0003\u0006\u0002\tAd\u0017M\u001c\u0006\u0003\u00171\tq\u0001\u001d7b]:,'O\u0003\u0002\u000e\u001d\u0005)A/\u00192mK*\u0011q\u0002E\u0001\u0006M2Lgn\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00011R\u0004\u0005\u0002\u001875\t\u0001D\u0003\u0002\n3)\u0011!\u0004E\u0001\bG\u0006d7-\u001b;f\u0013\ta\u0002D\u0001\u0006SK2|\u0005\u000f\u001e*vY\u0016\u0004\"AH\u0010\u000e\u0003\tI!\u0001\t\u0002\u0003+\t\u000bGo\u00195Fq\u0016\u001c'j\\5o%VdWMQ1tK\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\u0012\u0001\n\t\u0003=\u0001AQA\n\u0001\u0005B\u001d\nq!\\1uG\",7\u000f\u0006\u0002)]A\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t9!i\\8mK\u0006t\u0007\"B\u0018&\u0001\u0004\u0001\u0014\u0001B2bY2\u0004\"aF\u0019\n\u0005IB\"A\u0004*fY>\u0003HOU;mK\u000e\u000bG\u000e\u001c\u0005\u0006i\u0001!\t%N\u0001\b_:l\u0015\r^2i)\t1\u0014\b\u0005\u0002*o%\u0011\u0001H\u000b\u0002\u0005+:LG\u000fC\u00030g\u0001\u0007\u0001gB\u0003<\u0005!\u0005A(\u0001\u000eCCR\u001c\u0007.\u0012=fGN{'\u000f^'fe\u001e,'j\\5o%VdW\r\u0005\u0002\u001f{\u0019)\u0011A\u0001E\u0001}M\u0011Qh\u0010\t\u0003S\u0001K!!\u0011\u0016\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0011S\b\"\u0001D)\u0005a\u0004bB#>\u0005\u0004%\tAR\u0001\t\u0013:\u001bF+\u0011(D\u000bV\ta\u0003\u0003\u0004I{\u0001\u0006IAF\u0001\n\u0013:\u001bF+\u0011(D\u000b\u0002BqAS\u001fC\u0002\u0013\u00051*A\u0014U\u0003\ncUiX(Q)&k\u0015JW#S?Nk%j\u0018*F\u001b>3ViX*P%R{VIT!C\u0019\u0016#U#\u0001'\u0011\u00075\u0003&+D\u0001O\u0015\tye\"A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0003#:\u0013AbQ8oM&<w\n\u001d;j_:\u0004\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\t1\fgn\u001a\u0006\u0002/\u0006!!.\u0019<b\u0013\tiC\u000b\u0003\u0004[{\u0001\u0006I\u0001T\u0001))\u0006\u0013E*R0P!RKU*\u0013.F%~\u001bVJS0S\u000b6{e+R0T\u001fJ#v,\u0012(B\u00052+E\t\t\u0015\u00033r\u0003\"!\u00181\u000e\u0003yS!a\u0018\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002b=\naQ\t\u001f9fe&lWM\u001c;bY\u0002")
public class BatchExecSortMergeJoinRule
extends RelOptRule
implements BatchExecJoinRuleBase {
    public static ConfigOption<Boolean> TABLE_OPTIMIZER_SMJ_REMOVE_SORT_ENABLED() {
        return BatchExecSortMergeJoinRule$.MODULE$.TABLE_OPTIMIZER_SMJ_REMOVE_SORT_ENABLED();
    }

    public static RelOptRule INSTANCE() {
        return BatchExecSortMergeJoinRule$.MODULE$.INSTANCE();
    }

    @Override
    public RelNode addLocalDistinctAgg(RelNode node, Seq<Object> distinctKeys, RelBuilder relBuilder) {
        return BatchExecJoinRuleBase$class.addLocalDistinctAgg(this, node, distinctKeys, relBuilder);
    }

    @Override
    public boolean chooseSemiBuildDistinct(RelNode buildRel, Seq<Object> distinctKeys) {
        return BatchExecJoinRuleBase$class.chooseSemiBuildDistinct(this, buildRel, distinctKeys);
    }

    @Override
    public Double binaryRowRelNodeSize(RelNode relNode) {
        return BatchExecJoinRuleBase$class.binaryRowRelNodeSize(this, relNode);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        JoinInfo joinInfo = join.analyzeCondition();
        TableConfig tableConfig = ((FlinkContext)call.getPlanner().getContext()).getTableConfig();
        boolean isSortMergeJoinEnabled = !TableConfigUtils.isOperatorDisabled(tableConfig, OperatorType.SortMergeJoin);
        return !joinInfo.pairs().isEmpty() && isSortMergeJoinEnabled;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        JoinInfo joinInfo = join.analyzeCondition();
        RelNode left = join.getLeft();
        RelNode right = join.getRight();
        TableConfig tableConfig = ((FlinkContext)call.getPlanner().getContext()).getTableConfig();
        Tuple2[] candidates = tableConfig.getConfiguration().getBoolean(BatchExecSortMergeJoinRule$.MODULE$.TABLE_OPTIMIZER_SMJ_REMOVE_SORT_ENABLED()) ? (Tuple2[])((Object[])new Tuple2[]{new Tuple2.mcZZ.sp(false, false), new Tuple2.mcZZ.sp(true, false), new Tuple2.mcZZ.sp(false, true), new Tuple2.mcZZ.sp(true, true)}) : (Tuple2[])((Object[])new Tuple2[]{new Tuple2.mcZZ.sp(false, false)});
        Predef$.MODULE$.refArrayOps((Object[])candidates).foreach((Function1)new Serializable(this, call, join, joinInfo, left, right){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BatchExecSortMergeJoinRule $outer;
            private final RelOptRuleCall call$1;
            private final Join join$1;
            private final JoinInfo joinInfo$1;
            private final RelNode left$1;
            private final RelNode right$1;

            public final void apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    boolean requireLeftSorted = tuple2._1$mcZ$sp();
                    boolean requireRightSorted = tuple2._2$mcZ$sp();
                    this.$outer.org$apache$flink$table$planner$plan$rules$physical$batch$BatchExecSortMergeJoinRule$$transformToEquiv$1(this.joinInfo$1.leftKeys, this.joinInfo$1.rightKeys, requireLeftSorted, requireRightSorted, this.call$1, this.join$1, this.left$1, this.right$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.call$1 = call$1;
                this.join$1 = join$1;
                this.joinInfo$1 = joinInfo$1;
                this.left$1 = left$1;
                this.right$1 = right$1;
            }
        });
        boolean isShuffleByPartialKeyEnabled = tableConfig.getConfiguration().getBoolean(BatchExecJoinRuleBase$.MODULE$.TABLE_OPTIMIZER_SHUFFLE_BY_PARTIAL_KEY_ENABLED());
        if (isShuffleByPartialKeyEnabled && JavaConversions$.MODULE$.asScalaBuffer(joinInfo.pairs()).length() > 1) {
            JavaConversions$.MODULE$.asScalaBuffer(joinInfo.pairs()).foreach((Function1)new Serializable(this, call, join, left, right){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BatchExecSortMergeJoinRule $outer;
                private final RelOptRuleCall call$1;
                private final Join join$1;
                private final RelNode left$1;
                private final RelNode right$1;

                public final void apply(IntPair pair) {
                    this.$outer.org$apache$flink$table$planner$plan$rules$physical$batch$BatchExecSortMergeJoinRule$$transformToEquiv$1(ImmutableIntList.of(pair.source), ImmutableIntList.of(pair.target), false, false, this.call$1, this.join$1, this.left$1, this.right$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.call$1 = call$1;
                    this.join$1 = join$1;
                    this.left$1 = left$1;
                    this.right$1 = right$1;
                }
            });
        }
    }

    private final RelTraitSet getTraitSetByShuffleKeys$1(ImmutableIntList shuffleKeys, boolean requireStrict, boolean requireCollation, RelOptRuleCall call$1) {
        RelTraitSet traitSet = call$1.getPlanner().emptyTraitSet().replace(FlinkConventions$.MODULE$.BATCH_PHYSICAL()).replace(FlinkRelDistribution$.MODULE$.hash(shuffleKeys, requireStrict));
        if (requireCollation) {
            Buffer fieldCollations = (Buffer)JavaConversions$.MODULE$.asScalaBuffer((List)shuffleKeys).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RelFieldCollation apply(Integer x$1) {
                    return FlinkRelOptUtil$.MODULE$.ofRelFieldCollation(Predef$.MODULE$.Integer2int(x$1));
                }
            }, Buffer$.MODULE$.canBuildFrom());
            RelCollation relCollation = RelCollations.of(JavaConversions$.MODULE$.bufferAsJavaList(fieldCollations));
            traitSet = traitSet.replace(relCollation);
        }
        return traitSet;
    }

    public final void org$apache$flink$table$planner$plan$rules$physical$batch$BatchExecSortMergeJoinRule$$transformToEquiv$1(ImmutableIntList leftRequiredShuffleKeys, ImmutableIntList rightRequiredShuffleKeys, boolean requireLeftSorted, boolean requireRightSorted, RelOptRuleCall call$1, Join join$1, RelNode left$1, RelNode right$1) {
        RelTraitSet leftRequiredTrait = this.getTraitSetByShuffleKeys$1(leftRequiredShuffleKeys, true, requireLeftSorted, call$1);
        RelTraitSet rightRequiredTrait = this.getTraitSetByShuffleKeys$1(rightRequiredShuffleKeys, true, requireRightSorted, call$1);
        RelNode newLeft = RelOptRule.convert(left$1, leftRequiredTrait);
        RelNode newRight = RelOptRule.convert(right$1, rightRequiredTrait);
        RelTraitSet providedTraitSet = call$1.getPlanner().emptyTraitSet().replace(FlinkConventions$.MODULE$.BATCH_PHYSICAL());
        BatchExecSortMergeJoin newJoin = new BatchExecSortMergeJoin(join$1.getCluster(), providedTraitSet, newLeft, newRight, join$1.getCondition(), join$1.getJoinType(), requireLeftSorted, requireRightSorted);
        call$1.transformTo(newJoin);
    }

    public BatchExecSortMergeJoinRule() {
        super(RelOptRule.operand(FlinkLogicalJoin.class, RelOptRule.operand(RelNode.class, RelOptRule.any()), new RelOptRuleOperand[0]), "BatchExecSortMergeJoinRule");
        BatchExecJoinRuleBase$class.$init$(this);
    }
}

