/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.types.DataType;

public class ListAggFunction
extends DeclarativeAggregateFunction {
    private int operandCount;
    private UnresolvedReferenceExpression acc = ApiExpressionUtils.unresolvedRef("concatAcc");
    private UnresolvedReferenceExpression accDelimiter = ApiExpressionUtils.unresolvedRef("accDelimiter");
    private Expression delimiter;
    private Expression operand;

    public ListAggFunction(int operandCount) {
        this.operandCount = operandCount;
        if (operandCount == 1) {
            this.delimiter = ExpressionBuilder.literal(",", DataTypes.STRING());
            this.operand = this.operand(0);
        } else {
            this.delimiter = this.operand(1);
            this.operand = this.operand(0);
        }
    }

    @Override
    public int operandCount() {
        return this.operandCount;
    }

    @Override
    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        return new UnresolvedReferenceExpression[]{this.accDelimiter, this.acc};
    }

    @Override
    public DataType[] getAggBufferTypes() {
        return new DataType[]{DataTypes.STRING(), DataTypes.STRING()};
    }

    @Override
    public DataType getResultType() {
        return DataTypes.STRING();
    }

    @Override
    public Expression[] initialValuesExpressions() {
        return new Expression[]{ExpressionBuilder.literal(",", DataTypes.STRING()), ExpressionBuilder.nullOf(DataTypes.STRING())};
    }

    @Override
    public Expression[] accumulateExpressions() {
        return new Expression[]{this.delimiter, ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.operand), this.acc, ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.acc), this.operand, ExpressionBuilder.concat(ExpressionBuilder.concat(this.acc, this.delimiter), this.operand)))};
    }

    @Override
    public Expression[] retractExpressions() {
        throw new TableException("This function does not support retraction.");
    }

    @Override
    public Expression[] mergeExpressions() {
        return new Expression[]{this.mergeOperand(this.accDelimiter), ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.mergeOperand(this.acc)), this.acc, ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.acc), this.mergeOperand(this.acc), ExpressionBuilder.concat(ExpressionBuilder.concat(this.acc, this.mergeOperand(this.accDelimiter)), this.mergeOperand(this.acc))))};
    }

    @Override
    public Expression getValueExpression() {
        return this.acc;
    }
}

