/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.planner.catalog.DatabaseCalciteSchema;
import org.apache.flink.table.planner.catalog.FlinkSchema;

@Internal
public class CatalogCalciteSchema
extends FlinkSchema {
    private final String catalogName;
    private final Catalog catalog;
    private final boolean isStreamingMode;

    public CatalogCalciteSchema(String catalogName, Catalog catalog, boolean isStreamingMode) {
        this.catalogName = catalogName;
        this.catalog = catalog;
        this.isStreamingMode = isStreamingMode;
    }

    @Override
    public Schema getSubSchema(String schemaName) {
        if (this.catalog.databaseExists(schemaName)) {
            return new DatabaseCalciteSchema(schemaName, this.catalogName, this.catalog, this.isStreamingMode);
        }
        return null;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return new HashSet<String>(this.catalog.listDatabases());
    }

    @Override
    public Table getTable(String name) {
        return null;
    }

    @Override
    public Set<String> getTableNames() {
        return new HashSet<String>();
    }

    @Override
    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return Schemas.subSchemaExpression(parentSchema, name, this.getClass());
    }

    @Override
    public boolean isMutable() {
        return true;
    }
}

