/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class TableSchema {
    private static final String ATOMIC_TYPE_FIELD_NAME = "f0";
    private final String[] fieldNames;
    private final DataType[] fieldDataTypes;
    private final Map<String, Integer> fieldNameToIndex;

    private TableSchema(String[] fieldNames, DataType[] fieldDataTypes) {
        this.fieldNames = (String[])Preconditions.checkNotNull((Object)fieldNames);
        this.fieldDataTypes = (DataType[])Preconditions.checkNotNull((Object)fieldDataTypes);
        if (fieldNames.length != fieldDataTypes.length) {
            throw new TableException("Number of field names and field data types must be equal.\nNumber of names is " + fieldNames.length + ", number of data types is " + fieldDataTypes.length + ".\nList of field names: " + Arrays.toString(fieldNames) + "\nList of field data types: " + Arrays.toString(fieldDataTypes));
        }
        this.fieldNameToIndex = new HashMap<String, Integer>();
        HashSet<String> duplicateNames = new HashSet<String>();
        HashSet<String> uniqueNames = new HashSet<String>();
        for (int i = 0; i < fieldNames.length; ++i) {
            Preconditions.checkNotNull((Object)fieldDataTypes[i]);
            String fieldName = (String)Preconditions.checkNotNull((Object)fieldNames[i]);
            this.fieldNameToIndex.put(fieldName, i);
            if (uniqueNames.contains(fieldName)) {
                duplicateNames.add(fieldName);
                continue;
            }
            uniqueNames.add(fieldName);
        }
        if (!duplicateNames.isEmpty()) {
            throw new TableException("Field names must be unique.\nList of duplicate fields: " + ((Object)duplicateNames).toString() + "\nList of all fields: " + Arrays.toString(fieldNames));
        }
    }

    @Deprecated
    public TableSchema(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        this(fieldNames, TypeConversions.fromLegacyInfoToDataType(fieldTypes));
    }

    public TableSchema copy() {
        return new TableSchema((String[])this.fieldNames.clone(), (DataType[])this.fieldDataTypes.clone());
    }

    public DataType[] getFieldDataTypes() {
        return this.fieldDataTypes;
    }

    @Deprecated
    public TypeInformation<?>[] getFieldTypes() {
        return TypeConversions.fromDataTypeToLegacyInfo(this.fieldDataTypes);
    }

    public Optional<DataType> getFieldDataType(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.fieldDataTypes.length) {
            return Optional.empty();
        }
        return Optional.of(this.fieldDataTypes[fieldIndex]);
    }

    @Deprecated
    public Optional<TypeInformation<?>> getFieldType(int fieldIndex) {
        return this.getFieldDataType(fieldIndex).map(TypeConversions::fromDataTypeToLegacyInfo);
    }

    public Optional<DataType> getFieldDataType(String fieldName) {
        if (this.fieldNameToIndex.containsKey(fieldName)) {
            return Optional.of(this.fieldDataTypes[this.fieldNameToIndex.get(fieldName)]);
        }
        return Optional.empty();
    }

    @Deprecated
    public Optional<TypeInformation<?>> getFieldType(String fieldName) {
        return this.getFieldDataType(fieldName).map(TypeConversions::fromDataTypeToLegacyInfo);
    }

    public int getFieldCount() {
        return this.fieldNames.length;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public Optional<String> getFieldName(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.fieldNames.length) {
            return Optional.empty();
        }
        return Optional.of(this.fieldNames[fieldIndex]);
    }

    public DataType toRowDataType() {
        DataTypes.Field[] fields2 = (DataTypes.Field[])IntStream.range(0, this.fieldDataTypes.length).mapToObj(i -> DataTypes.FIELD(this.fieldNames[i], this.fieldDataTypes[i])).toArray(DataTypes.Field[]::new);
        return DataTypes.ROW(fields2);
    }

    @Deprecated
    public TypeInformation<Row> toRowType() {
        return TypeConversions.fromDataTypeToLegacyInfo(this.toRowDataType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("root\n");
        for (int i = 0; i < this.fieldNames.length; ++i) {
            sb.append(" |-- ").append(this.fieldNames[i]).append(": ").append(this.fieldDataTypes[i]).append('\n');
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableSchema schema = (TableSchema)o;
        return Arrays.equals(this.fieldNames, schema.fieldNames) && Arrays.equals(this.fieldDataTypes, schema.fieldDataTypes);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.fieldNames);
        result = 31 * result + Arrays.hashCode(this.fieldDataTypes);
        return result;
    }

    @Deprecated
    public static TableSchema fromTypeInfo(TypeInformation<?> typeInfo) {
        if (typeInfo instanceof CompositeType) {
            CompositeType compositeType = (CompositeType)typeInfo;
            String[] fieldNames = compositeType.getFieldNames();
            TypeInformation[] fieldTypes = new TypeInformation[fieldNames.length];
            for (int i = 0; i < fieldTypes.length; ++i) {
                fieldTypes[i] = compositeType.getTypeAt(i);
            }
            return new TableSchema(fieldNames, fieldTypes);
        }
        return new TableSchema(new String[]{ATOMIC_TYPE_FIELD_NAME}, new TypeInformation[]{typeInfo});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> fieldNames = new ArrayList<String>();
        private List<DataType> fieldDataTypes = new ArrayList<DataType>();

        public Builder field(String name, DataType dataType2) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)dataType2);
            this.fieldNames.add(name);
            this.fieldDataTypes.add(dataType2);
            return this;
        }

        public Builder fields(String[] names, DataType[] dataTypes) {
            Preconditions.checkNotNull((Object)names);
            Preconditions.checkNotNull((Object)dataTypes);
            this.fieldNames.addAll(Arrays.asList(names));
            this.fieldDataTypes.addAll(Arrays.asList(dataTypes));
            return this;
        }

        @Deprecated
        public Builder field(String name, TypeInformation<?> typeInfo) {
            return this.field(name, TypeConversions.fromLegacyInfoToDataType(typeInfo));
        }

        public TableSchema build() {
            return new TableSchema(this.fieldNames.toArray(new String[0]), this.fieldDataTypes.toArray(new DataType[0]));
        }
    }
}

