/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.type;

import java.util.List;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.flink.sql.parser.type.ExtendedSqlType;

public class SqlRowType
extends SqlIdentifier
implements ExtendedSqlType {
    private final List<SqlIdentifier> fieldNames;
    private final List<SqlDataTypeSpec> fieldTypes;
    private final List<SqlCharStringLiteral> comments;

    public SqlRowType(SqlParserPos pos, List<SqlIdentifier> fieldNames, List<SqlDataTypeSpec> fieldTypes, List<SqlCharStringLiteral> comments) {
        super(SqlTypeName.ROW.getName(), pos);
        this.fieldNames = fieldNames;
        this.fieldTypes = fieldTypes;
        this.comments = comments;
    }

    public List<SqlIdentifier> getFieldNames() {
        return this.fieldNames;
    }

    public List<SqlDataTypeSpec> getFieldTypes() {
        return this.fieldTypes;
    }

    public List<SqlCharStringLiteral> getComments() {
        return this.comments;
    }

    public int getArity() {
        return this.fieldNames.size();
    }

    public SqlIdentifier getFieldName(int i) {
        return this.fieldNames.get(i);
    }

    public SqlDataTypeSpec getFieldType(int i) {
        return this.fieldTypes.get(i);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.print("ROW");
        if (this.getFieldNames().size() == 0) {
            writer.print("<>");
        } else {
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "<", ">");
            int i = 0;
            for (Pair<SqlIdentifier, SqlDataTypeSpec> p : Pair.zip(this.fieldNames, this.fieldTypes)) {
                writer.sep(",", false);
                ((SqlIdentifier)p.left).unparse(writer, 0, 0);
                ExtendedSqlType.unparseType((SqlDataTypeSpec)p.right, writer, leftPrec, rightPrec);
                if (this.comments.get(i) != null) {
                    this.comments.get(i).unparse(writer, leftPrec, rightPrec);
                }
                ++i;
            }
            writer.endList(frame);
        }
    }
}

