/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser;

import java.nio.charset.Charset;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Util;
import org.apache.flink.sql.parser.type.ExtendedSqlType;
import org.apache.flink.sql.parser.type.SqlArrayType;
import org.apache.flink.sql.parser.type.SqlBytesType;
import org.apache.flink.sql.parser.type.SqlMapType;
import org.apache.flink.sql.parser.type.SqlMultisetType;
import org.apache.flink.sql.parser.type.SqlRowType;
import org.apache.flink.sql.parser.type.SqlStringType;
import org.apache.flink.sql.parser.type.SqlTimeType;
import org.apache.flink.sql.parser.type.SqlTimestampType;

public class FlinkSqlDataTypeSpec
extends SqlDataTypeSpec {
    private Boolean elementNullable;

    public FlinkSqlDataTypeSpec(SqlIdentifier collectionsTypeName, SqlIdentifier typeName, int precision, int scale, String charSetName, Boolean nullable, Boolean elementNullable, SqlParserPos pos) {
        super(collectionsTypeName, typeName, precision, scale, charSetName, null, nullable, pos);
        this.elementNullable = elementNullable;
    }

    public FlinkSqlDataTypeSpec(SqlIdentifier collectionsTypeName, SqlIdentifier typeName, int precision, int scale, String charSetName, TimeZone timeZone, Boolean nullable, Boolean elementNullable, SqlParserPos pos) {
        super(collectionsTypeName, typeName, precision, scale, charSetName, timeZone, nullable, pos);
        this.elementNullable = elementNullable;
    }

    public FlinkSqlDataTypeSpec(SqlIdentifier typeName, int precision, int scale, String charSetName, TimeZone timeZone, Boolean nullable, Boolean elementNullable, SqlParserPos pos) {
        super(null, typeName, precision, scale, charSetName, timeZone, nullable, pos);
        this.elementNullable = elementNullable;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return this.getCollectionsTypeName() != null ? new FlinkSqlDataTypeSpec(this.getCollectionsTypeName(), this.getTypeName(), this.getPrecision(), this.getScale(), this.getCharSetName(), this.getNullable(), this.elementNullable, pos) : new FlinkSqlDataTypeSpec(this.getTypeName(), this.getPrecision(), this.getScale(), this.getCharSetName(), this.getTimeZone(), this.getNullable(), this.elementNullable, pos);
    }

    @Override
    public SqlDataTypeSpec withNullable(Boolean nullable) {
        if (Objects.equals(nullable, this.getNullable())) {
            return this;
        }
        return new FlinkSqlDataTypeSpec(this.getCollectionsTypeName(), this.getTypeName(), this.getPrecision(), this.getScale(), this.getCharSetName(), this.getTimeZone(), nullable, this.elementNullable, this.getParserPosition());
    }

    @Override
    public RelDataType deriveType(RelDataTypeFactory typeFactory) {
        return this.deriveType(typeFactory, true);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlIdentifier typeName = this.getTypeName();
        String name = typeName.getSimple();
        if (typeName instanceof ExtendedSqlType) {
            typeName.unparse(writer, leftPrec, rightPrec);
        } else if (SqlTypeName.get(name) != null) {
            SqlTypeName sqlTypeName = SqlTypeName.get(name);
            writer.keyword(name);
            if (sqlTypeName.allowsPrec() && this.getPrecision() >= 0) {
                SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
                writer.print(this.getPrecision());
                if (sqlTypeName.allowsScale() && this.getScale() >= 0) {
                    writer.sep(",", true);
                    writer.print(this.getScale());
                }
                writer.endList(frame);
            }
            if (this.getCharSetName() != null) {
                writer.keyword("CHARACTER SET");
                writer.identifier(this.getCharSetName(), false);
            }
            if (this.getCollectionsTypeName() != null) {
                if (this.elementNullable != null && !this.elementNullable.booleanValue()) {
                    writer.keyword("NOT NULL");
                }
                writer.keyword(this.getCollectionsTypeName().getSimple());
            }
        } else if (name.startsWith("_")) {
            writer.keyword(name.substring(1));
        } else {
            this.getTypeName().unparse(writer, leftPrec, rightPrec);
        }
        if (this.getNullable() != null && !this.getNullable().booleanValue()) {
            writer.keyword("NOT NULL");
        }
    }

    @Override
    public RelDataType deriveType(RelDataTypeFactory typeFactory, boolean nullable) {
        SqlIdentifier collectionsTypeName;
        SqlIdentifier typeName = this.getTypeName();
        if (!typeName.isSimple()) {
            return null;
        }
        String name = typeName.getSimple();
        SqlTypeName sqlTypeName = SqlTypeName.get(name);
        RelDataType type = this.getExtendedType(typeFactory, typeName);
        if (type == null) {
            if (sqlTypeName == null) {
                return null;
            }
            int precision = this.getPrecision();
            int scale = this.getScale();
            if (precision >= 0 && scale >= 0) {
                assert (sqlTypeName.allowsPrecScale(true, true));
                type = typeFactory.createSqlType(sqlTypeName, precision, scale);
            } else if (precision >= 0) {
                assert (sqlTypeName.allowsPrecNoScale());
                type = typeFactory.createSqlType(sqlTypeName, precision);
            } else {
                assert (sqlTypeName.allowsNoPrecNoScale());
                type = typeFactory.createSqlType(sqlTypeName);
            }
        }
        if (SqlTypeUtil.inCharFamily(type)) {
            Charset charset;
            SqlCollation collation = SqlCollation.COERCIBLE;
            String charSetName = this.getCharSetName();
            if (null == charSetName) {
                charset = typeFactory.getDefaultCharset();
            } else {
                String javaCharSetName = Objects.requireNonNull(SqlUtil.translateCharacterSetName(charSetName), charSetName);
                charset = Charset.forName(javaCharSetName);
            }
            type = typeFactory.createTypeWithCharsetAndCollation(type, charset, collation);
        }
        if (null != (collectionsTypeName = this.getCollectionsTypeName())) {
            boolean elementNullable = true;
            if (this.elementNullable != null) {
                elementNullable = this.elementNullable;
            }
            type = typeFactory.createTypeWithNullability(type, elementNullable);
            String collectionName = collectionsTypeName.getSimple();
            SqlTypeName collectionsSqlTypeName = Objects.requireNonNull(SqlTypeName.get(collectionName), collectionName);
            switch (collectionsSqlTypeName) {
                case MULTISET: {
                    type = typeFactory.createMultisetType(type, -1L);
                    break;
                }
                case ARRAY: {
                    type = typeFactory.createArrayType(type, -1L);
                    break;
                }
                default: {
                    throw Util.unexpected(collectionsSqlTypeName);
                }
            }
        }
        if (this.getNullable() != null) {
            nullable = this.getNullable();
        }
        type = typeFactory.createTypeWithNullability(type, nullable);
        return type;
    }

    private RelDataType getExtendedType(RelDataTypeFactory typeFactory, SqlIdentifier typeName) {
        if (!(typeName instanceof ExtendedSqlType)) {
            return null;
        }
        if (typeName instanceof SqlBytesType) {
            return typeFactory.createSqlType(SqlTypeName.VARBINARY, Integer.MAX_VALUE);
        }
        if (typeName instanceof SqlStringType) {
            return typeFactory.createSqlType(SqlTypeName.VARCHAR, Integer.MAX_VALUE);
        }
        if (typeName instanceof SqlArrayType) {
            SqlArrayType arrayType = (SqlArrayType)typeName;
            return typeFactory.createArrayType(arrayType.getElementType().deriveType(typeFactory), -1L);
        }
        if (typeName instanceof SqlMultisetType) {
            SqlMultisetType multiSetType = (SqlMultisetType)typeName;
            return typeFactory.createMultisetType(multiSetType.getElementType().deriveType(typeFactory), -1L);
        }
        if (typeName instanceof SqlMapType) {
            SqlMapType mapType = (SqlMapType)typeName;
            return typeFactory.createMapType(mapType.getKeyType().deriveType(typeFactory), mapType.getValType().deriveType(typeFactory));
        }
        if (typeName instanceof SqlRowType) {
            SqlRowType rowType = (SqlRowType)typeName;
            return typeFactory.createStructType(rowType.getFieldTypes().stream().map(ft -> ft.deriveType(typeFactory)).collect(Collectors.toList()), rowType.getFieldNames().stream().map(SqlIdentifier::getSimple).collect(Collectors.toList()));
        }
        if (typeName instanceof SqlTimeType) {
            SqlTimeType zonedTimeType = (SqlTimeType)typeName;
            if (zonedTimeType.getPrecision() >= 0) {
                return typeFactory.createSqlType(zonedTimeType.getSqlTypeName(), zonedTimeType.getPrecision());
            }
            return typeFactory.createSqlType(zonedTimeType.getSqlTypeName());
        }
        if (typeName instanceof SqlTimestampType) {
            SqlTimestampType zonedTimestampType = (SqlTimestampType)typeName;
            if (zonedTimestampType.getPrecision() >= 0) {
                return typeFactory.createSqlType(zonedTimestampType.getSqlTypeName(), zonedTimestampType.getPrecision());
            }
            return typeFactory.createSqlType(zonedTimestampType.getSqlTypeName());
        }
        return null;
    }
}

