/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.security.kerberos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.alink.kafka011.org.apache.kafka.common.security.kerberos.KerberosName;
import shaded.alink.kafka011.org.apache.kafka.common.security.kerberos.KerberosRule;
import shaded.alink.kafka011.org.apache.kafka.common.security.kerberos.NoMatchingRule;

public class KerberosShortNamer {
    private static final Pattern RULE_PARSER = Pattern.compile("((DEFAULT)|(RULE:\\[(\\d*):([^\\]]*)](\\(([^)]*)\\))?(s/([^/]*)/([^/]*)/(g)?)?))");
    private final List<KerberosRule> principalToLocalRules;

    public KerberosShortNamer(List<KerberosRule> principalToLocalRules) {
        this.principalToLocalRules = principalToLocalRules;
    }

    public static KerberosShortNamer fromUnparsedRules(String defaultRealm, List<String> principalToLocalRules) {
        List<String> rules = principalToLocalRules == null ? Collections.singletonList("DEFAULT") : principalToLocalRules;
        return new KerberosShortNamer(KerberosShortNamer.parseRules(defaultRealm, rules));
    }

    private static List<KerberosRule> parseRules(String defaultRealm, List<String> rules) {
        ArrayList<KerberosRule> result = new ArrayList<KerberosRule>();
        for (String rule : rules) {
            Matcher matcher = RULE_PARSER.matcher(rule);
            if (!matcher.lookingAt()) {
                throw new IllegalArgumentException("Invalid rule: " + rule);
            }
            if (rule.length() != matcher.end()) {
                throw new IllegalArgumentException("Invalid rule: `" + rule + "`, unmatched substring: `" + rule.substring(matcher.end()) + "`");
            }
            if (matcher.group(2) != null) {
                result.add(new KerberosRule(defaultRealm));
                continue;
            }
            result.add(new KerberosRule(defaultRealm, Integer.parseInt(matcher.group(4)), matcher.group(5), matcher.group(7), matcher.group(9), matcher.group(10), "g".equals(matcher.group(11))));
        }
        return result;
    }

    public String shortName(KerberosName kerberosName) throws IOException {
        String[] params;
        if (kerberosName.hostName() == null) {
            if (kerberosName.realm() == null) {
                return kerberosName.serviceName();
            }
            params = new String[]{kerberosName.realm(), kerberosName.serviceName()};
        } else {
            params = new String[]{kerberosName.realm(), kerberosName.serviceName(), kerberosName.hostName()};
        }
        for (KerberosRule r : this.principalToLocalRules) {
            String result = r.apply(params);
            if (result == null) continue;
            return result;
        }
        throw new NoMatchingRule("No rules apply to " + kerberosName + ", rules " + this.principalToLocalRules);
    }

    public String toString() {
        return "KerberosShortNamer(principalToLocalRules = " + this.principalToLocalRules + ")";
    }
}

