/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka011.org.apache.kafka.common.requests.SaslHandshakeResponse;

public class SaslHandshakeRequest
extends AbstractRequest {
    public static final String MECHANISM_KEY_NAME = "mechanism";
    private final String mechanism;

    public SaslHandshakeRequest(String mechanism) {
        super(ApiKeys.SASL_HANDSHAKE.latestVersion());
        this.mechanism = mechanism;
    }

    public SaslHandshakeRequest(Struct struct, short version) {
        super(version);
        this.mechanism = struct.getString(MECHANISM_KEY_NAME);
    }

    public String mechanism() {
        return this.mechanism;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                List<String> enabledMechanisms = Collections.emptyList();
                return new SaslHandshakeResponse(Errors.forException(e), enabledMechanisms);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.SASL_HANDSHAKE.latestVersion()));
    }

    public static SaslHandshakeRequest parse(ByteBuffer buffer, short version) {
        return new SaslHandshakeRequest(ApiKeys.SASL_HANDSHAKE.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.SASL_HANDSHAKE.requestSchema(this.version()));
        struct.set(MECHANISM_KEY_NAME, (Object)this.mechanism);
        return struct;
    }

    public static class Builder
    extends AbstractRequest.Builder<SaslHandshakeRequest> {
        private final String mechanism;

        public Builder(String mechanism) {
            super(ApiKeys.SASL_HANDSHAKE);
            this.mechanism = mechanism;
        }

        @Override
        public SaslHandshakeRequest build(short version) {
            return new SaslHandshakeRequest(this.mechanism);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=SaslHandshakeRequest").append(", mechanism=").append(this.mechanism).append(")");
            return bld.toString();
        }
    }
}

