/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import shaded.alink.kafka011.org.apache.kafka.common.acl.AccessControlEntryFilter;
import shaded.alink.kafka011.org.apache.kafka.common.acl.AclBindingFilter;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka011.org.apache.kafka.common.requests.ApiError;
import shaded.alink.kafka011.org.apache.kafka.common.requests.DescribeAclsResponse;
import shaded.alink.kafka011.org.apache.kafka.common.requests.RequestUtils;
import shaded.alink.kafka011.org.apache.kafka.common.resource.ResourceFilter;

public class DescribeAclsRequest
extends AbstractRequest {
    private final AclBindingFilter filter;

    DescribeAclsRequest(AclBindingFilter filter, short version) {
        super(version);
        this.filter = filter;
    }

    public DescribeAclsRequest(Struct struct, short version) {
        super(version);
        ResourceFilter resourceFilter = RequestUtils.resourceFilterFromStructFields(struct);
        AccessControlEntryFilter entryFilter = RequestUtils.aceFilterFromStructFields(struct);
        this.filter = new AclBindingFilter(resourceFilter, entryFilter);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.DESCRIBE_ACLS.requestSchema(this.version()));
        RequestUtils.resourceFilterSetStructFields(this.filter.resourceFilter(), struct);
        RequestUtils.aceFilterSetStructFields(this.filter.entryFilter(), struct);
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable throwable) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new DescribeAclsResponse(throttleTimeMs, ApiError.fromThrowable(throwable), Collections.emptySet());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.DESCRIBE_ACLS.latestVersion()));
    }

    public static DescribeAclsRequest parse(ByteBuffer buffer, short version) {
        return new DescribeAclsRequest(ApiKeys.DESCRIBE_ACLS.parseRequest(version, buffer), version);
    }

    public AclBindingFilter filter() {
        return this.filter;
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeAclsRequest> {
        private final AclBindingFilter filter;

        public Builder(AclBindingFilter filter) {
            super(ApiKeys.DESCRIBE_ACLS);
            this.filter = filter;
        }

        @Override
        public DescribeAclsRequest build(short version) {
            return new DescribeAclsRequest(this.filter, version);
        }

        public String toString() {
            return "(type=DescribeAclsRequest, filter=" + this.filter + ")";
        }
    }
}

