/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals;

import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.watermark.Watermark;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartitionState;

@Internal
public final class KafkaTopicPartitionStateWithPeriodicWatermarks<T, KPH>
extends KafkaTopicPartitionState<KPH> {
    private final AssignerWithPeriodicWatermarks<T> timestampsAndWatermarks;
    private long partitionWatermark;

    public KafkaTopicPartitionStateWithPeriodicWatermarks(KafkaTopicPartition partition, KPH kafkaPartitionHandle, AssignerWithPeriodicWatermarks<T> timestampsAndWatermarks) {
        super(partition, kafkaPartitionHandle);
        this.timestampsAndWatermarks = timestampsAndWatermarks;
        this.partitionWatermark = Long.MIN_VALUE;
    }

    public long getTimestampForRecord(T record, long kafkaEventTimestamp) {
        return this.timestampsAndWatermarks.extractTimestamp(record, kafkaEventTimestamp);
    }

    public long getCurrentWatermarkTimestamp() {
        Watermark wm = this.timestampsAndWatermarks.getCurrentWatermark();
        if (wm != null) {
            this.partitionWatermark = Math.max(this.partitionWatermark, wm.getTimestamp());
        }
        return this.partitionWatermark;
    }

    @Override
    public String toString() {
        return "KafkaTopicPartitionStateWithPeriodicWatermarks: partition=" + this.getKafkaTopicPartition() + ", offset=" + this.getOffset() + ", watermark=" + this.partitionWatermark;
    }
}

