/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.server.policy;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import shaded.alink.kafka010.org.apache.kafka.common.Configurable;
import shaded.alink.kafka010.org.apache.kafka.common.errors.PolicyViolationException;

public interface CreateTopicPolicy
extends Configurable,
AutoCloseable {
    public void validate(RequestMetadata var1) throws PolicyViolationException;

    public static class RequestMetadata {
        private final String topic;
        private final Integer numPartitions;
        private final Short replicationFactor;
        private final Map<Integer, List<Integer>> replicasAssignments;
        private final Map<String, String> configs;

        public RequestMetadata(String topic, Integer numPartitions, Short replicationFactor, Map<Integer, List<Integer>> replicasAssignments, Map<String, String> configs) {
            this.topic = topic;
            this.numPartitions = numPartitions;
            this.replicationFactor = replicationFactor;
            this.replicasAssignments = replicasAssignments == null ? null : Collections.unmodifiableMap(replicasAssignments);
            this.configs = Collections.unmodifiableMap(configs);
        }

        public String topic() {
            return this.topic;
        }

        public Integer numPartitions() {
            return this.numPartitions;
        }

        public Short replicationFactor() {
            return this.replicationFactor;
        }

        public Map<Integer, List<Integer>> replicasAssignments() {
            return this.replicasAssignments;
        }

        public Map<String, String> configs() {
            return this.configs;
        }

        public String toString() {
            return "RequestMetadata(topic=" + this.topic + ", numPartitions=" + this.numPartitions + ", replicationFactor=" + this.replicationFactor + ", replicasAssignments=" + this.replicasAssignments + ", configs=" + this.configs + ")";
        }
    }
}

