/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import shaded.alink.kafka010.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka010.org.apache.kafka.common.network.ByteBufferSend;
import shaded.alink.kafka010.org.apache.kafka.common.network.MultiSend;
import shaded.alink.kafka010.org.apache.kafka.common.network.Send;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.ProtoUtils;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.types.Type;
import shaded.alink.kafka010.org.apache.kafka.common.record.Records;
import shaded.alink.kafka010.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.FetchRequest;
import shaded.alink.kafka010.org.apache.kafka.common.requests.RecordsSend;
import shaded.alink.kafka010.org.apache.kafka.common.requests.RequestHeader;
import shaded.alink.kafka010.org.apache.kafka.common.requests.ResponseHeader;

public class FetchResponse
extends AbstractResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.FETCH.id);
    private static final String RESPONSES_KEY_NAME = "responses";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partition_responses";
    private static final String THROTTLE_TIME_KEY_NAME = "throttle_time_ms";
    private static final String PARTITION_HEADER_KEY_NAME = "partition_header";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final int DEFAULT_THROTTLE_TIME = 0;
    private static final String HIGH_WATERMARK_KEY_NAME = "high_watermark";
    private static final String RECORD_SET_KEY_NAME = "record_set";
    public static final long INVALID_HIGHWATERMARK = -1L;
    private final LinkedHashMap<TopicPartition, PartitionData> responseData;
    private final int throttleTime;

    public FetchResponse(LinkedHashMap<TopicPartition, PartitionData> responseData, int throttleTime) {
        this(3, responseData, throttleTime);
    }

    public FetchResponse(int version, LinkedHashMap<TopicPartition, PartitionData> responseData, int throttleTime) {
        super(FetchResponse.writeStruct(new Struct(ProtoUtils.responseSchema(ApiKeys.FETCH.id, version)), version, responseData, throttleTime));
        this.responseData = responseData;
        this.throttleTime = throttleTime;
    }

    public FetchResponse(Struct struct) {
        super(struct);
        LinkedHashMap<TopicPartition, PartitionData> responseData = new LinkedHashMap<TopicPartition, PartitionData>();
        for (Object topicResponseObj : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                Struct partitionResponseHeader = partitionResponse.getStruct(PARTITION_HEADER_KEY_NAME);
                int partition = partitionResponseHeader.getInt(PARTITION_KEY_NAME);
                short errorCode = partitionResponseHeader.getShort(ERROR_CODE_KEY_NAME);
                long highWatermark = partitionResponseHeader.getLong(HIGH_WATERMARK_KEY_NAME);
                Records records = partitionResponse.getRecords(RECORD_SET_KEY_NAME);
                PartitionData partitionData = new PartitionData(errorCode, highWatermark, records);
                responseData.put(new TopicPartition(topic, partition), partitionData);
            }
        }
        this.responseData = responseData;
        this.throttleTime = struct.hasField(THROTTLE_TIME_KEY_NAME) ? struct.getInt(THROTTLE_TIME_KEY_NAME) : 0;
    }

    @Override
    public Send toSend(String dest, RequestHeader requestHeader) {
        ResponseHeader responseHeader = new ResponseHeader(requestHeader.correlationId());
        ByteBuffer buffer = ByteBuffer.allocate(responseHeader.sizeOf() + 4);
        buffer.putInt(responseHeader.sizeOf() + this.struct.sizeOf());
        responseHeader.writeTo(buffer);
        buffer.rewind();
        ArrayList<Send> sends = new ArrayList<Send>();
        sends.add(new ByteBufferSend(dest, buffer));
        this.addResponseData(dest, sends);
        return new MultiSend(dest, sends);
    }

    public LinkedHashMap<TopicPartition, PartitionData> responseData() {
        return this.responseData;
    }

    public int getThrottleTime() {
        return this.throttleTime;
    }

    public static FetchResponse parse(ByteBuffer buffer) {
        return new FetchResponse(CURRENT_SCHEMA.read(buffer));
    }

    public static FetchResponse parse(ByteBuffer buffer, int version) {
        return new FetchResponse(ProtoUtils.responseSchema(ApiKeys.FETCH.id, version).read(buffer));
    }

    private void addResponseData(String dest, List<Send> sends) {
        Object[] allTopicData = this.struct.getArray(RESPONSES_KEY_NAME);
        if (this.struct.hasField(THROTTLE_TIME_KEY_NAME)) {
            int throttleTime = this.struct.getInt(THROTTLE_TIME_KEY_NAME);
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putInt(throttleTime);
            buffer.putInt(allTopicData.length);
            buffer.rewind();
            sends.add(new ByteBufferSend(dest, buffer));
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(allTopicData.length);
            buffer.rewind();
            sends.add(new ByteBufferSend(dest, buffer));
        }
        for (Object topicData : allTopicData) {
            this.addTopicData(dest, sends, (Struct)topicData);
        }
    }

    private void addTopicData(String dest, List<Send> sends, Struct topicData) {
        String topic = topicData.getString(TOPIC_KEY_NAME);
        Object[] allPartitionData = topicData.getArray(PARTITIONS_KEY_NAME);
        ByteBuffer buffer = ByteBuffer.allocate(Type.STRING.sizeOf(topic) + 4);
        Type.STRING.write(buffer, topic);
        buffer.putInt(allPartitionData.length);
        buffer.rewind();
        sends.add(new ByteBufferSend(dest, buffer));
        for (Object partitionData : allPartitionData) {
            this.addPartitionData(dest, sends, (Struct)partitionData);
        }
    }

    private void addPartitionData(String dest, List<Send> sends, Struct partitionData) {
        Struct header = partitionData.getStruct(PARTITION_HEADER_KEY_NAME);
        Records records = partitionData.getRecords(RECORD_SET_KEY_NAME);
        ByteBuffer buffer = ByteBuffer.allocate(header.sizeOf() + 4);
        header.writeTo(buffer);
        buffer.putInt(records.sizeInBytes());
        buffer.rewind();
        sends.add(new ByteBufferSend(dest, buffer));
        sends.add(new RecordsSend(dest, records));
    }

    private static Struct writeStruct(Struct struct, int version, LinkedHashMap<TopicPartition, PartitionData> responseData, int throttleTime) {
        List<FetchRequest.TopicAndPartitionData<PartitionData>> topicsData = FetchRequest.TopicAndPartitionData.batchByTopic(responseData);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (FetchRequest.TopicAndPartitionData<PartitionData> topicEntry : topicsData) {
            Struct topicData = struct.instance(RESPONSES_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)topicEntry.topic);
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry partitionEntry : topicEntry.partitions.entrySet()) {
                PartitionData fetchPartitionData = (PartitionData)partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                Struct partitionDataHeader = partitionData.instance(PARTITION_HEADER_KEY_NAME);
                partitionDataHeader.set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey());
                partitionDataHeader.set(ERROR_CODE_KEY_NAME, (Object)fetchPartitionData.errorCode);
                partitionDataHeader.set(HIGH_WATERMARK_KEY_NAME, (Object)fetchPartitionData.highWatermark);
                partitionData.set(PARTITION_HEADER_KEY_NAME, (Object)partitionDataHeader);
                partitionData.set(RECORD_SET_KEY_NAME, (Object)fetchPartitionData.records);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        struct.set(RESPONSES_KEY_NAME, (Object)topicArray.toArray());
        if (version >= 1) {
            struct.set(THROTTLE_TIME_KEY_NAME, (Object)throttleTime);
        }
        return struct;
    }

    public static int sizeOf(int version, LinkedHashMap<TopicPartition, PartitionData> responseData) {
        Struct struct = new Struct(ProtoUtils.responseSchema(ApiKeys.FETCH.id, version));
        FetchResponse.writeStruct(struct, version, responseData, 0);
        return 4 + struct.sizeOf();
    }

    public static final class PartitionData {
        public final short errorCode;
        public final long highWatermark;
        public final Records records;

        public PartitionData(short errorCode, long highWatermark, Records records) {
            this.errorCode = errorCode;
            this.highWatermark = highWatermark;
            this.records = records;
        }

        public String toString() {
            return "(errorCode=" + this.errorCode + ", highWaterMark=" + this.highWatermark + ", records=" + this.records + ")";
        }
    }
}

