/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.clients;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.alink.kafka010.org.apache.kafka.common.config.ConfigException;
import shaded.alink.kafka010.org.apache.kafka.common.network.ChannelBuilder;
import shaded.alink.kafka010.org.apache.kafka.common.network.ChannelBuilders;
import shaded.alink.kafka010.org.apache.kafka.common.network.LoginType;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.SecurityProtocol;
import shaded.alink.kafka010.org.apache.kafka.common.utils.Utils;

public class ClientUtils {
    private static final Logger log = LoggerFactory.getLogger(ClientUtils.class);

    public static List<InetSocketAddress> parseAndValidateAddresses(List<String> urls) {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (String url : urls) {
            if (url == null || url.isEmpty()) continue;
            try {
                String host = Utils.getHost(url);
                Integer port = Utils.getPort(url);
                if (host == null || port == null) {
                    throw new ConfigException("Invalid url in bootstrap.servers: " + url);
                }
                InetSocketAddress address = new InetSocketAddress(host, (int)port);
                if (address.isUnresolved()) {
                    log.warn("Removing server {} from {} as DNS resolution failed for {}", url, "bootstrap.servers", host);
                    continue;
                }
                addresses.add(address);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigException("Invalid port in bootstrap.servers: " + url);
            }
        }
        if (addresses.isEmpty()) {
            throw new ConfigException("No resolvable bootstrap urls given in bootstrap.servers");
        }
        return addresses;
    }

    public static void closeQuietly(Closeable c, String name, AtomicReference<Throwable> firstException) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable t) {
                firstException.compareAndSet(null, t);
                log.error("Failed to close " + name, t);
            }
        }
    }

    public static ChannelBuilder createChannelBuilder(Map<String, ?> configs) {
        SecurityProtocol securityProtocol = SecurityProtocol.forName((String)configs.get("security.protocol"));
        if (!SecurityProtocol.nonTestingValues().contains((Object)securityProtocol)) {
            throw new ConfigException("Invalid SecurityProtocol " + (Object)((Object)securityProtocol));
        }
        String clientSaslMechanism = (String)configs.get("sasl.mechanism");
        return ChannelBuilders.clientChannelBuilder(securityProtocol, LoginType.CLIENT, configs, clientSaslMechanism, true);
    }
}

