/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shaded.alink.kafka.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka.org.apache.kafka.common.errors.UnsupportedVersionException;
import shaded.alink.kafka.org.apache.kafka.common.network.ListenerName;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.CommonFields;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractControlRequest;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka.org.apache.kafka.common.requests.BasePartitionState;
import shaded.alink.kafka.org.apache.kafka.common.requests.UpdateMetadataResponse;
import shaded.alink.kafka.org.apache.kafka.common.security.auth.SecurityProtocol;
import shaded.alink.kafka.org.apache.kafka.common.utils.CollectionUtils;
import shaded.alink.kafka.org.apache.kafka.common.utils.Utils;

public class UpdateMetadataRequest
extends AbstractControlRequest {
    private static final Field.ComplexArray TOPIC_STATES = new Field.ComplexArray("topic_states", "Topic states");
    private static final Field.ComplexArray PARTITION_STATES = new Field.ComplexArray("partition_states", "Partition states");
    private static final Field.ComplexArray LIVE_BROKERS = new Field.ComplexArray("live_brokers", "Live broekrs");
    private static final Field.Int32 LEADER = new Field.Int32("leader", "The broker id for the leader.");
    private static final Field.Int32 LEADER_EPOCH = new Field.Int32("leader_epoch", "The leader epoch.");
    private static final Field.Array ISR = new Field.Array("isr", Type.INT32, "The in sync replica ids.");
    private static final Field.Int32 ZK_VERSION = new Field.Int32("zk_version", "The ZK version.");
    private static final Field.Array REPLICAS = new Field.Array("replicas", Type.INT32, "The replica ids.");
    private static final Field.Array OFFLINE_REPLICAS = new Field.Array("offline_replicas", Type.INT32, "The offline replica ids");
    private static final Field.Int32 BROKER_ID = new Field.Int32("id", "The broker id");
    private static final Field.ComplexArray ENDPOINTS = new Field.ComplexArray("end_points", "The endpoints");
    private static final Field.NullableStr RACK = new Field.NullableStr("rack", "The rack");
    private static final Field.Str HOST = new Field.Str("host", "The hostname of the broker.");
    private static final Field.Int32 PORT = new Field.Int32("port", "The port on which the broker accepts requests.");
    private static final Field.Str LISTENER_NAME = new Field.Str("listener_name", "The listener name.");
    private static final Field.Int16 SECURITY_PROTOCOL_TYPE = new Field.Int16("security_protocol_type", "The security protocol type.");
    private static final Field PARTITION_STATES_V0 = PARTITION_STATES.withFields(CommonFields.TOPIC_NAME, CommonFields.PARTITION_ID, CONTROLLER_EPOCH, LEADER, LEADER_EPOCH, ISR, ZK_VERSION, REPLICAS);
    private static final Field PARTITION_STATES_V4 = PARTITION_STATES.withFields(CommonFields.TOPIC_NAME, CommonFields.PARTITION_ID, CONTROLLER_EPOCH, LEADER, LEADER_EPOCH, ISR, ZK_VERSION, REPLICAS, OFFLINE_REPLICAS);
    private static final Field PARTITION_STATES_V5 = PARTITION_STATES.withFields(CommonFields.PARTITION_ID, CONTROLLER_EPOCH, LEADER, LEADER_EPOCH, ISR, ZK_VERSION, REPLICAS, OFFLINE_REPLICAS);
    private static final Field TOPIC_STATES_V5 = TOPIC_STATES.withFields(CommonFields.TOPIC_NAME, PARTITION_STATES_V5);
    private static final Field ENDPOINTS_V1 = ENDPOINTS.withFields(PORT, HOST, SECURITY_PROTOCOL_TYPE);
    private static final Field ENDPOINTS_V3 = ENDPOINTS.withFields(PORT, HOST, LISTENER_NAME, SECURITY_PROTOCOL_TYPE);
    private static final Field LIVE_BROKERS_V0 = LIVE_BROKERS.withFields(BROKER_ID, HOST, PORT);
    private static final Field LIVE_BROKERS_V1 = LIVE_BROKERS.withFields(BROKER_ID, ENDPOINTS_V1);
    private static final Field LIVE_BROKERS_V2 = LIVE_BROKERS.withFields(BROKER_ID, ENDPOINTS_V1, RACK);
    private static final Field LIVE_BROKERS_V3 = LIVE_BROKERS.withFields(BROKER_ID, ENDPOINTS_V3, RACK);
    private static final Schema UPDATE_METADATA_REQUEST_V0 = new Schema(CONTROLLER_ID, CONTROLLER_EPOCH, PARTITION_STATES_V0, LIVE_BROKERS_V0);
    private static final Schema UPDATE_METADATA_REQUEST_V1 = new Schema(CONTROLLER_ID, CONTROLLER_EPOCH, PARTITION_STATES_V0, LIVE_BROKERS_V1);
    private static final Schema UPDATE_METADATA_REQUEST_V2 = new Schema(CONTROLLER_ID, CONTROLLER_EPOCH, PARTITION_STATES_V0, LIVE_BROKERS_V2);
    private static final Schema UPDATE_METADATA_REQUEST_V3 = new Schema(CONTROLLER_ID, CONTROLLER_EPOCH, PARTITION_STATES_V0, LIVE_BROKERS_V3);
    private static final Schema UPDATE_METADATA_REQUEST_V4 = new Schema(CONTROLLER_ID, CONTROLLER_EPOCH, PARTITION_STATES_V4, LIVE_BROKERS_V3);
    private static final Schema UPDATE_METADATA_REQUEST_V5 = new Schema(CONTROLLER_ID, CONTROLLER_EPOCH, BROKER_EPOCH, TOPIC_STATES_V5, LIVE_BROKERS_V3);
    private final Map<TopicPartition, PartitionState> partitionStates;
    private final Set<Broker> liveBrokers;

    public static Schema[] schemaVersions() {
        return new Schema[]{UPDATE_METADATA_REQUEST_V0, UPDATE_METADATA_REQUEST_V1, UPDATE_METADATA_REQUEST_V2, UPDATE_METADATA_REQUEST_V3, UPDATE_METADATA_REQUEST_V4, UPDATE_METADATA_REQUEST_V5};
    }

    private UpdateMetadataRequest(short version, int controllerId, int controllerEpoch, long brokerEpoch, Map<TopicPartition, PartitionState> partitionStates, Set<Broker> liveBrokers) {
        super(ApiKeys.UPDATE_METADATA, version, controllerId, controllerEpoch, brokerEpoch);
        this.partitionStates = partitionStates;
        this.liveBrokers = liveBrokers;
    }

    public UpdateMetadataRequest(Struct struct, short versionId) {
        super(ApiKeys.UPDATE_METADATA, struct, versionId);
        String topic;
        HashMap<TopicPartition, PartitionState> partitionStates = new HashMap<TopicPartition, PartitionState>();
        if (struct.hasField(TOPIC_STATES)) {
            for (Object topicStatesDataObj : struct.get(TOPIC_STATES)) {
                Struct topicStatesData = (Struct)topicStatesDataObj;
                topic = topicStatesData.get(CommonFields.TOPIC_NAME);
                for (Object partitionStateDataObj : topicStatesData.get(PARTITION_STATES)) {
                    Struct partitionStateData = (Struct)partitionStateDataObj;
                    int partition = partitionStateData.get(CommonFields.PARTITION_ID);
                    PartitionState partitionState = new PartitionState(partitionStateData);
                    partitionStates.put(new TopicPartition(topic, partition), partitionState);
                }
            }
        } else {
            for (Object partitionStateDataObj : struct.get(PARTITION_STATES)) {
                Struct partitionStateData = (Struct)partitionStateDataObj;
                topic = partitionStateData.get(CommonFields.TOPIC_NAME);
                int partition = partitionStateData.get(CommonFields.PARTITION_ID);
                PartitionState partitionState = new PartitionState(partitionStateData);
                partitionStates.put(new TopicPartition(topic, partition), partitionState);
            }
        }
        HashSet<Broker> liveBrokers = new HashSet<Broker>();
        for (Object brokerDataObj : struct.get(LIVE_BROKERS)) {
            Struct brokerData = (Struct)brokerDataObj;
            int brokerId = brokerData.get(BROKER_ID);
            if (brokerData.hasField(HOST)) {
                String host = brokerData.get(HOST);
                int port = brokerData.get(PORT);
                ArrayList<EndPoint> endPoints = new ArrayList<EndPoint>(1);
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                endPoints.add(new EndPoint(host, port, securityProtocol, ListenerName.forSecurityProtocol(securityProtocol)));
                liveBrokers.add(new Broker(brokerId, endPoints, null));
                continue;
            }
            ArrayList<EndPoint> endPoints = new ArrayList<EndPoint>();
            for (Object endPointDataObj : brokerData.get(ENDPOINTS)) {
                Struct endPointData = (Struct)endPointDataObj;
                int port = endPointData.get(PORT);
                String host = endPointData.get(HOST);
                short protocolTypeId = endPointData.get(SECURITY_PROTOCOL_TYPE);
                SecurityProtocol securityProtocol = SecurityProtocol.forId(protocolTypeId);
                String listenerName = endPointData.hasField(LISTENER_NAME) ? endPointData.get(LISTENER_NAME) : securityProtocol.name;
                endPoints.add(new EndPoint(host, port, securityProtocol, new ListenerName(listenerName)));
            }
            String rack = null;
            if (brokerData.hasField(RACK)) {
                rack = brokerData.get(RACK);
            }
            liveBrokers.add(new Broker(brokerId, endPoints, rack));
        }
        this.partitionStates = partitionStates;
        this.liveBrokers = liveBrokers;
    }

    @Override
    protected Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.UPDATE_METADATA.requestSchema(version));
        struct.set(CONTROLLER_ID, this.controllerId);
        struct.set(CONTROLLER_EPOCH, this.controllerEpoch);
        struct.setIfExists(BROKER_EPOCH, (Object)this.brokerEpoch);
        if (struct.hasField(TOPIC_STATES)) {
            Map<String, Map<Integer, PartitionState>> topicStates = CollectionUtils.groupPartitionDataByTopic(this.partitionStates);
            ArrayList<Struct> topicStatesData = new ArrayList<Struct>(topicStates.size());
            for (Map.Entry<String, Map<Integer, PartitionState>> entry : topicStates.entrySet()) {
                Struct topicStateData = struct.instance(TOPIC_STATES);
                topicStateData.set(CommonFields.TOPIC_NAME, entry.getKey());
                Map<Integer, PartitionState> partitionMap = entry.getValue();
                ArrayList<Struct> partitionStatesData = new ArrayList<Struct>(partitionMap.size());
                for (Map.Entry<Integer, PartitionState> partitionEntry : partitionMap.entrySet()) {
                    Struct partitionStateData = topicStateData.instance(PARTITION_STATES);
                    partitionStateData.set(CommonFields.PARTITION_ID, partitionEntry.getKey());
                    partitionEntry.getValue().setStruct(partitionStateData);
                    partitionStatesData.add(partitionStateData);
                }
                topicStateData.set(PARTITION_STATES, partitionStatesData.toArray());
                topicStatesData.add(topicStateData);
            }
            struct.set(TOPIC_STATES, topicStatesData.toArray());
        } else {
            ArrayList<Struct> partitionStatesData = new ArrayList<Struct>(this.partitionStates.size());
            for (Map.Entry<TopicPartition, PartitionState> entry : this.partitionStates.entrySet()) {
                Struct partitionStateData = struct.instance(PARTITION_STATES);
                TopicPartition topicPartition = entry.getKey();
                partitionStateData.set(CommonFields.TOPIC_NAME, topicPartition.topic());
                partitionStateData.set(CommonFields.PARTITION_ID, topicPartition.partition());
                entry.getValue().setStruct(partitionStateData);
                partitionStatesData.add(partitionStateData);
            }
            struct.set(PARTITION_STATES, partitionStatesData.toArray());
        }
        ArrayList<Struct> brokersData = new ArrayList<Struct>(this.liveBrokers.size());
        for (Broker broker : this.liveBrokers) {
            Struct brokerData = struct.instance(LIVE_BROKERS);
            brokerData.set(BROKER_ID, broker.id);
            if (version == 0) {
                EndPoint endPoint = broker.endPoints.get(0);
                brokerData.set(HOST, endPoint.host);
                brokerData.set(PORT, endPoint.port);
            } else {
                ArrayList<Struct> endPointsData = new ArrayList<Struct>(broker.endPoints.size());
                for (EndPoint endPoint : broker.endPoints) {
                    Struct endPointData = brokerData.instance(ENDPOINTS);
                    endPointData.set(PORT, endPoint.port);
                    endPointData.set(HOST, endPoint.host);
                    endPointData.set(SECURITY_PROTOCOL_TYPE, endPoint.securityProtocol.id);
                    if (version >= 3) {
                        endPointData.set(LISTENER_NAME, endPoint.listenerName.value());
                    }
                    endPointsData.add(endPointData);
                }
                brokerData.set(ENDPOINTS, endPointsData.toArray());
                if (version >= 2) {
                    brokerData.set(RACK, broker.rack);
                }
            }
            brokersData.add(brokerData);
        }
        struct.set(LIVE_BROKERS, brokersData.toArray());
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        if (versionId <= 5) {
            return new UpdateMetadataResponse(Errors.forException(e));
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.UPDATE_METADATA.latestVersion()));
    }

    public Map<TopicPartition, PartitionState> partitionStates() {
        return this.partitionStates;
    }

    public Set<Broker> liveBrokers() {
        return this.liveBrokers;
    }

    public static UpdateMetadataRequest parse(ByteBuffer buffer, short version) {
        return new UpdateMetadataRequest(ApiKeys.UPDATE_METADATA.parseRequest(version, buffer), version);
    }

    public static final class EndPoint {
        public final String host;
        public final int port;
        public final SecurityProtocol securityProtocol;
        public final ListenerName listenerName;

        public EndPoint(String host, int port, SecurityProtocol securityProtocol, ListenerName listenerName) {
            this.host = host;
            this.port = port;
            this.securityProtocol = securityProtocol;
            this.listenerName = listenerName;
        }

        public String toString() {
            return "(host=" + this.host + ", port=" + this.port + ", listenerName=" + this.listenerName + ", securityProtocol=" + (Object)((Object)this.securityProtocol) + ")";
        }
    }

    public static final class Broker {
        public final int id;
        public final List<EndPoint> endPoints;
        public final String rack;

        public Broker(int id, List<EndPoint> endPoints, String rack) {
            this.id = id;
            this.endPoints = endPoints;
            this.rack = rack;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(id=").append(this.id);
            bld.append(", endPoints=").append(Utils.join(this.endPoints, ","));
            bld.append(", rack=").append(this.rack);
            bld.append(")");
            return bld.toString();
        }
    }

    public static final class PartitionState {
        public final BasePartitionState basePartitionState;
        public final List<Integer> offlineReplicas;

        public PartitionState(int controllerEpoch, int leader, int leaderEpoch, List<Integer> isr, int zkVersion, List<Integer> replicas, List<Integer> offlineReplicas) {
            this.basePartitionState = new BasePartitionState(controllerEpoch, leader, leaderEpoch, isr, zkVersion, replicas);
            this.offlineReplicas = offlineReplicas;
        }

        private PartitionState(Struct struct) {
            int controllerEpoch = struct.get(AbstractControlRequest.CONTROLLER_EPOCH);
            int leader = struct.get(LEADER);
            int leaderEpoch = struct.get(LEADER_EPOCH);
            Object[] isrArray = struct.get(ISR);
            ArrayList<Integer> isr = new ArrayList<Integer>(isrArray.length);
            for (Object object : isrArray) {
                isr.add((Integer)object);
            }
            int zkVersion = struct.get(ZK_VERSION);
            Object[] replicasArray = struct.get(REPLICAS);
            ArrayList<Integer> replicas = new ArrayList<Integer>(replicasArray.length);
            for (Object r : replicasArray) {
                replicas.add((Integer)r);
            }
            this.basePartitionState = new BasePartitionState(controllerEpoch, leader, leaderEpoch, isr, zkVersion, replicas);
            this.offlineReplicas = new ArrayList<Integer>();
            if (struct.hasField(OFFLINE_REPLICAS)) {
                Object[] objectArray;
                for (Object r : objectArray = struct.get(OFFLINE_REPLICAS)) {
                    this.offlineReplicas.add((Integer)r);
                }
            }
        }

        public String toString() {
            return "PartitionState(controllerEpoch=" + this.basePartitionState.controllerEpoch + ", leader=" + this.basePartitionState.leader + ", leaderEpoch=" + this.basePartitionState.leaderEpoch + ", isr=" + Arrays.toString(this.basePartitionState.isr.toArray()) + ", zkVersion=" + this.basePartitionState.zkVersion + ", replicas=" + Arrays.toString(this.basePartitionState.replicas.toArray()) + ", offlineReplicas=" + Arrays.toString(this.offlineReplicas.toArray()) + ")";
        }

        private void setStruct(Struct struct) {
            struct.set(AbstractControlRequest.CONTROLLER_EPOCH, this.basePartitionState.controllerEpoch);
            struct.set(LEADER, this.basePartitionState.leader);
            struct.set(LEADER_EPOCH, this.basePartitionState.leaderEpoch);
            struct.set(ISR, this.basePartitionState.isr.toArray());
            struct.set(ZK_VERSION, this.basePartitionState.zkVersion);
            struct.set(REPLICAS, this.basePartitionState.replicas.toArray());
            struct.setIfExists(OFFLINE_REPLICAS, this.offlineReplicas.toArray());
        }
    }

    public static class Builder
    extends AbstractControlRequest.Builder<UpdateMetadataRequest> {
        private final Map<TopicPartition, PartitionState> partitionStates;
        private final Set<Broker> liveBrokers;

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, Map<TopicPartition, PartitionState> partitionStates, Set<Broker> liveBrokers) {
            super(ApiKeys.UPDATE_METADATA, version, controllerId, controllerEpoch, brokerEpoch);
            this.partitionStates = partitionStates;
            this.liveBrokers = liveBrokers;
        }

        @Override
        public UpdateMetadataRequest build(short version) {
            if (version == 0) {
                for (Broker broker : this.liveBrokers) {
                    if (broker.endPoints.size() == 1 && broker.endPoints.get((int)0).securityProtocol == SecurityProtocol.PLAINTEXT) continue;
                    throw new UnsupportedVersionException("UpdateMetadataRequest v0 only handles PLAINTEXT endpoints");
                }
            }
            return new UpdateMetadataRequest(version, this.controllerId, this.controllerEpoch, this.brokerEpoch, this.partitionStates, this.liveBrokers);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type: UpdateMetadataRequest=").append(", controllerId=").append(this.controllerId).append(", controllerEpoch=").append(this.controllerEpoch).append(", brokerEpoch=").append(this.brokerEpoch).append(", partitionStates=").append(this.partitionStates).append(", liveBrokers=").append(Utils.join(this.liveBrokers, ", ")).append(")");
            return bld.toString();
        }
    }
}

