/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.record;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import shaded.alink.kafka.org.apache.kafka.common.record.CompressionType;

public class CompressionRatioEstimator {
    public static final float COMPRESSION_RATIO_IMPROVING_STEP = 0.005f;
    public static final float COMPRESSION_RATIO_DETERIORATE_STEP = 0.05f;
    private static final ConcurrentMap<String, float[]> COMPRESSION_RATIO = new ConcurrentHashMap<String, float[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float updateEstimation(String topic, CompressionType type, float observedRatio) {
        float[] compressionRatioForTopic = CompressionRatioEstimator.getAndCreateEstimationIfAbsent(topic);
        float currentEstimation = compressionRatioForTopic[type.id];
        float[] fArray = compressionRatioForTopic;
        synchronized (compressionRatioForTopic) {
            if (observedRatio > currentEstimation) {
                compressionRatioForTopic[type.id] = Math.max(currentEstimation + 0.05f, observedRatio);
            } else if (observedRatio < currentEstimation) {
                compressionRatioForTopic[type.id] = currentEstimation - 0.005f;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return compressionRatioForTopic[type.id];
        }
    }

    public static float estimation(String topic, CompressionType type) {
        float[] compressionRatioForTopic = CompressionRatioEstimator.getAndCreateEstimationIfAbsent(topic);
        return compressionRatioForTopic[type.id];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetEstimation(String topic) {
        float[] compressionRatioForTopic;
        float[] fArray = compressionRatioForTopic = CompressionRatioEstimator.getAndCreateEstimationIfAbsent(topic);
        synchronized (compressionRatioForTopic) {
            for (CompressionType type : CompressionType.values()) {
                compressionRatioForTopic[type.id] = type.rate;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void removeEstimation(String topic) {
        COMPRESSION_RATIO.remove(topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEstimation(String topic, CompressionType type, float ratio) {
        float[] compressionRatioForTopic;
        float[] fArray = compressionRatioForTopic = CompressionRatioEstimator.getAndCreateEstimationIfAbsent(topic);
        synchronized (compressionRatioForTopic) {
            compressionRatioForTopic[type.id] = ratio;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static float[] getAndCreateEstimationIfAbsent(String topic) {
        float[] existingCompressionRatio;
        float[] compressionRatioForTopic = (float[])COMPRESSION_RATIO.get(topic);
        if (compressionRatioForTopic == null && (existingCompressionRatio = COMPRESSION_RATIO.putIfAbsent(topic, compressionRatioForTopic = CompressionRatioEstimator.initialCompressionRatio())) != null) {
            return existingCompressionRatio;
        }
        return compressionRatioForTopic;
    }

    private static float[] initialCompressionRatio() {
        float[] compressionRatio = new float[CompressionType.values().length];
        for (CompressionType type : CompressionType.values()) {
            compressionRatio[type.id] = type.rate;
        }
        return compressionRatio;
    }
}

