/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connectors.hive.HiveTableOutputFormat;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientFactory;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientWrapper;
import org.apache.flink.table.sinks.OutputFormatTableSink;
import org.apache.flink.table.sinks.OverwritableTableSink;
import org.apache.flink.table.sinks.PartitionableTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.types.Row;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.mapred.JobConf;
import org.apache.thrift.TException;

public class HiveTableSink
extends OutputFormatTableSink<Row>
implements PartitionableTableSink,
OverwritableTableSink {
    private final JobConf jobConf;
    private final CatalogTable catalogTable;
    private final ObjectPath tablePath;
    private final RowTypeInfo rowTypeInfo;
    private final String hiveVersion;
    private Map<String, String> staticPartitionSpec = Collections.emptyMap();
    private boolean overwrite = false;

    public HiveTableSink(JobConf jobConf, ObjectPath tablePath, CatalogTable table) {
        this.jobConf = jobConf;
        this.tablePath = tablePath;
        this.catalogTable = table;
        this.hiveVersion = (String)Preconditions.checkNotNull((Object)jobConf.get("hive-version"), (String)"Hive version is not defined");
        TableSchema tableSchema = table.getSchema();
        this.rowTypeInfo = new RowTypeInfo(tableSchema.getFieldTypes(), tableSchema.getFieldNames());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OutputFormat<Row> getOutputFormat() {
        List<String> partitionColumns = this.getPartitionFieldNames();
        boolean isPartitioned = partitionColumns != null && !partitionColumns.isEmpty();
        boolean isDynamicPartition = isPartitioned && partitionColumns.size() > this.staticPartitionSpec.size();
        String dbName = this.tablePath.getDatabaseName();
        String tableName = this.tablePath.getObjectName();
        try (HiveMetastoreClientWrapper client = HiveMetastoreClientFactory.create(new HiveConf((Configuration)this.jobConf, HiveConf.class), this.hiveVersion);){
            HiveTablePartition hiveTablePartition;
            Table table = client.getTable(dbName, tableName);
            StorageDescriptor sd = table.getSd();
            String sdLocation = sd.getLocation();
            if (isPartitioned) {
                this.validatePartitionSpec();
                if (isDynamicPartition) {
                    ArrayList<String> path = new ArrayList<String>(2);
                    path.add(sd.getLocation());
                    if (!this.staticPartitionSpec.isEmpty()) {
                        path.add(Warehouse.makePartName(this.staticPartitionSpec, (boolean)false));
                    }
                    sdLocation = String.join((CharSequence)"/", path);
                } else {
                    List<Partition> partitions = client.listPartitions(dbName, tableName, new ArrayList<String>(this.staticPartitionSpec.values()), (short)1);
                    sdLocation = !partitions.isEmpty() ? partitions.get(0).getSd().getLocation() : sd.getLocation() + "/" + Warehouse.makePartName(this.staticPartitionSpec, (boolean)true);
                }
                sd.setLocation(this.toStagingDir(sdLocation, (Configuration)this.jobConf));
                hiveTablePartition = new HiveTablePartition(sd, new LinkedHashMap<String, Object>(this.staticPartitionSpec));
            } else {
                sd.setLocation(this.toStagingDir(sdLocation, (Configuration)this.jobConf));
                hiveTablePartition = new HiveTablePartition(sd, null);
            }
            HiveTableOutputFormat hiveTableOutputFormat = new HiveTableOutputFormat(this.jobConf, this.tablePath, this.catalogTable, hiveTablePartition, MetaStoreUtils.getTableMetadata((Table)table), this.overwrite);
            return hiveTableOutputFormat;
        }
        catch (TException e) {
            throw new CatalogException("Failed to query Hive metaStore", (Throwable)e);
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Failed to create staging dir", (Throwable)e);
        }
    }

    public TableSink<Row> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        return new HiveTableSink(this.jobConf, this.tablePath, this.catalogTable);
    }

    public String[] getFieldNames() {
        return this.rowTypeInfo.getFieldNames();
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.rowTypeInfo.getFieldTypes();
    }

    public TypeInformation<Row> getOutputType() {
        return this.rowTypeInfo;
    }

    private String toStagingDir(String finalDir, Configuration conf) throws IOException {
        Path path;
        FileSystem fs;
        String res = finalDir;
        if (!finalDir.endsWith("/")) {
            res = res + "/";
        }
        Preconditions.checkState(((fs = (path = new Path(res = res + ".staging_" + System.currentTimeMillis())).getFileSystem(conf)).exists(path) || fs.mkdirs(path) ? 1 : 0) != 0, (Object)("Failed to create staging dir " + path));
        fs.deleteOnExit(path);
        return res;
    }

    public List<String> getPartitionFieldNames() {
        return this.catalogTable.getPartitionKeys();
    }

    public void setStaticPartition(Map<String, String> partitionSpec) {
        this.staticPartitionSpec = new LinkedHashMap<String, String>();
        for (String partitionCol : this.getPartitionFieldNames()) {
            if (!partitionSpec.containsKey(partitionCol)) continue;
            this.staticPartitionSpec.put(partitionCol, partitionSpec.get(partitionCol));
        }
    }

    private void validatePartitionSpec() {
        List<String> partitionCols = this.getPartitionFieldNames();
        List unknownPartCols = this.staticPartitionSpec.keySet().stream().filter(k -> !partitionCols.contains(k)).collect(Collectors.toList());
        Preconditions.checkArgument((boolean)unknownPartCols.isEmpty(), (Object)("Static partition spec contains unknown partition column: " + unknownPartCols.toString()));
        int numStaticPart = this.staticPartitionSpec.size();
        if (numStaticPart < partitionCols.size()) {
            for (String partitionCol : partitionCols) {
                if (!this.staticPartitionSpec.containsKey(partitionCol)) {
                    Preconditions.checkArgument((numStaticPart == 0 ? 1 : 0) != 0, (Object)"Dynamic partition cannot appear before static partition");
                    return;
                }
                --numStaticPart;
            }
        }
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

