/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.common.io;

import com.alibaba.alink.common.MLEnvironmentFactory;
import com.alibaba.alink.common.io.BaseDB;
import com.alibaba.alink.common.io.annotations.DBAnnotation;
import com.alibaba.alink.common.io.table.BaseDbTable;
import com.alibaba.alink.common.utils.DataSetConversionUtil;
import com.alibaba.alink.common.utils.DataStreamConversionUtil;
import com.alibaba.alink.common.utils.TableUtil;
import com.alibaba.alink.operator.batch.BatchOperator;
import com.alibaba.alink.operator.stream.StreamOperator;
import com.alibaba.alink.params.io.HiveDBParams;
import com.alibaba.alink.params.io.HiveSinkParams;
import com.alibaba.alink.params.io.HiveSourceParams;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.connectors.hive.HiveTableFactory;
import org.apache.flink.connectors.hive.HiveTableSink;
import org.apache.flink.connectors.hive.HiveTableSource;
import org.apache.flink.core.fs.Path;
import org.apache.flink.ml.api.misc.param.Params;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.TypeGetterSetters;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.parquet.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DBAnnotation(name="hive")
public class HiveDB
extends BaseDB
implements Serializable {
    private HiveCatalog catalog;
    private String dbName;
    private String hiveVersion;
    private String hiveConfDir;
    private static final Logger LOG = LoggerFactory.getLogger(HiveDB.class);

    public HiveDB(String hiveConfDir, String hiveVersion, String dbName) {
        this(new Params().set(HiveDBParams.HIVE_CONF_DIR, (Object)hiveConfDir).set(HiveDBParams.HIVE_VERSION, (Object)hiveVersion).set(HiveDBParams.DB_NAME, (Object)dbName));
    }

    public HiveDB(Params params) {
        super(params);
        this.checkHiveVersion();
        this.dbName = (String)params.get(HiveDBParams.DB_NAME);
        this.hiveConfDir = (String)params.get(HiveDBParams.HIVE_CONF_DIR);
        this.hiveVersion = (String)params.get(HiveDBParams.HIVE_VERSION);
    }

    private void checkHiveVersion() {
        String hiveVersion = (String)this.params.get(HiveDBParams.HIVE_VERSION);
    }

    public String getHiveVersion() {
        return this.hiveVersion;
    }

    public String getHiveConfDir() {
        return this.hiveConfDir;
    }

    private HiveCatalog getCatalog() throws Exception {
        if (this.catalog == null) {
            String hiveConfDir = (String)this.params.get(HiveDBParams.HIVE_CONF_DIR);
            Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)hiveConfDir) ? 1 : 0) != 0);
            String hiveVersion = (String)this.params.get(HiveDBParams.HIVE_VERSION);
            String catalogName = FileUtils.getRandomFilename((String)"");
            if (!hiveConfDir.startsWith("/")) {
                String tempDir = System.getProperty("java.io.tmpdir");
                File localConfDir = new File(tempDir, FileUtils.getRandomFilename((String)""));
                FileUtils.copy((Path)new Path(hiveConfDir + "/hive-site.xml"), (Path)new Path(localConfDir.getAbsolutePath() + "/hive-site.xml"), (boolean)false);
                hiveConfDir = localConfDir.getAbsolutePath();
                this.catalog = new HiveCatalog(catalogName, this.dbName, hiveConfDir, hiveVersion);
                this.catalog.open();
                LOG.info("open hive catalog success.");
            } else {
                this.catalog = new HiveCatalog(catalogName, this.dbName, hiveConfDir, hiveVersion);
                this.catalog.open();
            }
        }
        return this.catalog;
    }

    public String getName() {
        return this.dbName;
    }

    public List<String> listTableNames() throws Exception {
        return this.getCatalog().listTables(this.dbName);
    }

    public void execute(String sql) throws Exception {
        throw new UnsupportedOperationException("not supported.");
    }

    private static Map<String, String> getStaticPartitionSpec(String partitionSpec) {
        HashMap<String, String> spec = new HashMap<String, String>();
        if (!StringUtils.isNullOrWhitespaceOnly((String)partitionSpec)) {
            String[] partitions = partitionSpec.split("/");
            for (int i = 0; i < partitions.length; ++i) {
                String p = partitions[i];
                int pos = p.indexOf(61);
                Preconditions.checkArgument((pos > 0 ? 1 : 0) != 0);
                String col = p.substring(0, pos);
                String val = p.substring(pos + 1);
                spec.put(col, val);
            }
        }
        return spec;
    }

    private static String[] getPartitionColumnsFromSpec(String partitionSpec) {
        String[] partitions = partitionSpec.split("/");
        for (int i = 0; i < partitions.length; ++i) {
            String p = partitions[i];
            int pos = p.indexOf(61);
            Preconditions.checkArgument((pos > 0 ? 1 : 0) != 0);
            String col = p.substring(0, pos);
            partitions[i] = col + " STRING";
        }
        return partitions;
    }

    public void createTable(String tableName, TableSchema schema, Params parameter) throws Exception {
        Object[] partitionCols = new String[]{};
        String partitionSpec = (String)parameter.get(HiveSinkParams.PARTITION);
        if (!StringUtils.isNullOrWhitespaceOnly((String)partitionSpec)) {
            partitionCols = partitionSpec.split("/");
            for (int i = 0; i < partitionCols.length; ++i) {
                String p = partitionCols[i];
                int pos = p.indexOf(61);
                Preconditions.checkArgument((pos > 0 ? 1 : 0) != 0);
                partitionCols[i] = p.substring(0, pos);
            }
        }
        if (partitionCols.length > 0) {
            for (String string : partitionCols) {
                if (TableUtil.findColIndex((TableSchema)schema, (String)string) < 0) continue;
                throw new IllegalArgumentException("The table contains partition column: " + string);
            }
            String[] fieldNames = (String[])ArrayUtils.addAll((Object[])schema.getFieldNames(), (Object[])partitionCols);
            Object[] fieldTypes = new TypeInformation[partitionCols.length];
            Arrays.fill(fieldTypes, Types.STRING);
            fieldTypes = (TypeInformation[])ArrayUtils.addAll((Object[])schema.getFieldTypes(), (Object[])fieldTypes);
            schema = new TableSchema(fieldNames, (TypeInformation[])fieldTypes);
        }
        ObjectPath objectPath = ObjectPath.fromString((String)(this.dbName + "." + tableName));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("is_generic", "false");
        CatalogTableImpl catalogTable = new CatalogTableImpl(schema, Arrays.asList(partitionCols), properties, tableName);
        this.getCatalog().createTable(objectPath, (CatalogBaseTable)catalogTable, false);
        System.out.println("Hive table " + tableName + " created.");
        LOG.info("Hive table {} created", (Object)tableName);
    }

    public void dropTable(String tableName) throws Exception {
        throw new IllegalArgumentException("not supported.");
    }

    public boolean hasTable(String table) throws Exception {
        List<String> tableNames = this.listTableNames();
        for (String name : tableNames) {
            if (!table.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasColumn(String table, String column) throws Exception {
        return TableUtil.findColIndex((TableSchema)this.getTableSchema(table), (String)column) >= 0;
    }

    public String[] getColNames(String tableName) throws Exception {
        return this.getTableSchema(tableName).getFieldNames();
    }

    private TableSchema getTableSchemaWithPartitionColumns(String tableName) throws Exception {
        ObjectPath op = ObjectPath.fromString((String)String.format("%s.%s", this.dbName, tableName));
        CatalogBaseTable tbl = this.getCatalog().getTable(op);
        TableSchema schema = tbl.getSchema();
        return schema;
    }

    public TableSchema getTableSchema(String tableName) throws Exception {
        TableSchema schema = this.getTableSchemaWithPartitionColumns(tableName);
        List<String> staticPartCols = this.getPartitionCols(tableName);
        int numPartCols = staticPartCols.size();
        if (numPartCols > 0) {
            HashSet<String> partColsSet = new HashSet<String>();
            partColsSet.addAll(staticPartCols);
            int n = 0;
            String[] fieldNames = new String[schema.getFieldNames().length - numPartCols];
            TypeInformation[] fieldTypes = new TypeInformation[fieldNames.length];
            TypeInformation[] allFieldTypes = schema.getFieldTypes();
            for (int i = 0; i < allFieldTypes.length; ++i) {
                String fieldName = schema.getFieldNames()[i];
                if (partColsSet.contains(fieldName)) continue;
                fieldNames[n] = fieldName;
                fieldTypes[n] = allFieldTypes[i];
                ++n;
            }
            return new TableSchema(fieldNames, fieldTypes);
        }
        return schema;
    }

    public void close() throws Exception {
        if (this.catalog != null) {
            this.catalog.close();
            this.catalog = null;
        }
    }

    public BaseDbTable getDbTable(String tableName) throws Exception {
        throw new UnsupportedOperationException("not supported.");
    }

    private static List<Map<String, String>> getSelectedPartitions(String[] partitionSpecs) {
        ArrayList<Map<String, String>> selected = new ArrayList<Map<String, String>>();
        for (String s : partitionSpecs) {
            Map<String, String> spec = HiveDB.getStaticPartitionSpec(s);
            selected.add(spec);
        }
        return selected;
    }

    private boolean isTableExists(String tableName) {
        try {
            return this.hasTable(tableName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private CatalogTable getCatalogTable(String tableName) {
        try {
            return (CatalogTable)this.getCatalog().getTable(ObjectPath.fromString((String)(this.dbName + "." + tableName)));
        }
        catch (Exception e) {
            LOG.warn("Failed to do getCatalog() for table:{}", (Object)tableName, (Object)e);
            throw new RuntimeException("Fail to get getCatalog() table: " + tableName, e);
        }
    }

    public List<String> getPartitionCols(String tableName) {
        return this.getCatalogTable(tableName).getPartitionKeys();
    }

    private boolean isPartitionTable(String tableName) {
        return this.getPartitionCols(tableName).size() > 0;
    }

    private void checkSchemaMatch(TableSchema outputSchema, String tableName) {
        TableSchema tableSchema;
        try {
            tableSchema = this.getTableSchema(tableName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String[] outputFields = outputSchema.getFieldNames();
        String[] tableFields = tableSchema.getFieldNames();
        if (outputFields.length != tableFields.length) {
            throw new RuntimeException(String.format("mismatched schema size between outputting operator and the overwritten table \"%s\".Outputting operator schema is %s", tableName, outputSchema.toString()));
        }
        for (int i = 0; i < outputFields.length; ++i) {
            if (outputFields[i].compareToIgnoreCase(tableFields[i]) == 0) continue;
            throw new RuntimeException(String.format("mismatched schema between outputting operator and the overwritten table \"%s\".Outputting operator schema is %s", tableName, outputSchema.toString()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkTableExistenceBeforeSink(String tableName, Table in, Params parameter) {
        boolean hasTable = this.isTableExists(tableName);
        boolean overwriteSink = (Boolean)parameter.get(HiveSinkParams.OVERWRITE_SINK);
        String partitionSpec = (String)parameter.get(HiveSinkParams.PARTITION);
        if (hasTable) {
            boolean isPartTable = this.isPartitionTable(tableName);
            if (!overwriteSink) throw new RuntimeException(String.format("Table %s exists, you may setOverwriteSink(true) to overwrite this table.", tableName));
            this.checkSchemaMatch(in.getSchema(), tableName);
            return;
        }
        try {
            this.createTable(tableName, in.getSchema(), parameter);
            return;
        }
        catch (Exception e) {
            LOG.warn("Failed to create table {}", (Object)tableName, (Object)e);
            throw new RuntimeException("Fail to create table " + tableName, e);
        }
    }

    private HiveTableSource getHiveTableSource(String tableName, Params parameter) throws Exception {
        ObjectPath objectPath = ObjectPath.fromString((String)(this.dbName + "." + tableName));
        CatalogTable catalogTable = this.getCatalogTable(tableName);
        HiveTableFactory factory = new HiveTableFactory(this.getCatalog().getHiveConf());
        HiveTableSource hiveTableSource = (HiveTableSource)factory.createTableSource(objectPath, catalogTable);
        String partitionSpecsStr = (String)parameter.get(HiveSourceParams.PARTITIONS);
        if (!StringUtils.isNullOrWhitespaceOnly((String)partitionSpecsStr)) {
            String[] partitionSpecs = partitionSpecsStr.split(",");
            hiveTableSource.getPartitions();
            List<Map<String, String>> selectedPartitions = HiveDB.getSelectedPartitions(partitionSpecs);
            hiveTableSource = (HiveTableSource)hiveTableSource.applyPartitionPruning(selectedPartitions);
        }
        return hiveTableSource;
    }

    public Table getBatchTable(String tableName, Params parameter, Long sessionId) throws Exception {
        RichInputFormat inputFormat = (RichInputFormat)this.getHiveTableSource(tableName, parameter).getInputFormat();
        DataSource ds = MLEnvironmentFactory.get((Long)sessionId).getExecutionEnvironment().createInput((InputFormat)inputFormat);
        Table tbl = DataSetConversionUtil.toTable((Long)sessionId, (DataSet)ds, (TableSchema)this.getTableSchemaWithPartitionColumns(tableName));
        if (this.getPartitionCols(tableName).size() > 0) {
            String[] fieldNames = this.getColNames(tableName);
            tbl = tbl.select(Strings.join((String[])fieldNames, (String)","));
        }
        return tbl;
    }

    public Table getStreamTable(String tableName, Params parameter, Long sessionId) throws Exception {
        StreamExecutionEnvironment env = MLEnvironmentFactory.get((Long)sessionId).getStreamExecutionEnvironment();
        HiveTableSource hiveTableSource = this.getHiveTableSource(tableName, parameter);
        DataStream dataStream = hiveTableSource.getDataStream(env);
        Table tbl = DataStreamConversionUtil.toTable((Long)sessionId, (DataStream)dataStream, (TableSchema)this.getTableSchemaWithPartitionColumns(tableName));
        if (this.getPartitionCols(tableName).size() > 0) {
            String[] fieldNames = this.getColNames(tableName);
            tbl = tbl.select(Strings.join((String[])fieldNames, (String)","));
        }
        return tbl;
    }

    public void sinkStream(String tableName, Table in, Params parameter, Long sessionId) {
        try {
            this.checkTableExistenceBeforeSink(tableName, in, parameter);
            HiveTableFactory factory = new HiveTableFactory(this.getCatalog().getHiveConf());
            ObjectPath objectPath = ObjectPath.fromString((String)(this.dbName + "." + tableName));
            CatalogTable catalogTable = this.getCatalogTable(tableName);
            HiveTableSink tableSink = (HiveTableSink)factory.createTableSink(objectPath, catalogTable);
            tableSink.setStaticPartition(HiveDB.getStaticPartitionSpec((String)parameter.get(HiveSinkParams.PARTITION)));
            tableSink.setOverwrite(true);
            tableSink.emitDataStream(StreamOperator.fromTable((Table)in).getDataStream());
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to sink stream table:", e);
        }
    }

    public void sinkBatch(String tableName, Table in, Params parameter, Long sessionId) {
        try {
            this.checkTableExistenceBeforeSink(tableName, in, parameter);
            HiveTableFactory factory = new HiveTableFactory(this.getCatalog().getHiveConf());
            ObjectPath objectPath = ObjectPath.fromString((String)(this.dbName + "." + tableName));
            CatalogTable catalogTable = this.getCatalogTable(tableName);
            HiveTableSink tableSink = (HiveTableSink)factory.createTableSink(objectPath, catalogTable);
            tableSink.setStaticPartition(HiveDB.getStaticPartitionSpec((String)parameter.get(HiveSinkParams.PARTITION)));
            tableSink.setOverwrite(true);
            OutputFormat<Row> outputFormat = tableSink.getOutputFormat();
            BatchOperator.fromTable((Table)in).getDataSet().output(outputFormat).name("hive_sink_" + tableName);
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to sink batch table:", e);
        }
    }

    public RichOutputFormat createFormat(String tableName, TableSchema schema) {
        throw new UnsupportedOperationException("not supported.");
    }

    private static class BaseRowToRow
    implements MapFunction<BaseRow, Row> {
        DataType[] dataTypes;

        BaseRowToRow(DataType[] dataTypes) {
            this.dataTypes = dataTypes;
        }

        public Row map(BaseRow baseRow) throws Exception {
            Row row = new Row(baseRow.getArity());
            for (int i = 0; i < baseRow.getArity(); ++i) {
                Object o = TypeGetterSetters.get((TypeGetterSetters)baseRow, (int)i, (LogicalType)this.dataTypes[i].getLogicalType());
                if (o != null && o instanceof BinaryString) {
                    o = ((BinaryString)o).toString();
                }
                row.setField(i, o);
            }
            return row;
        }
    }
}

