/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.executor.datasource;

import com.alibaba.alink.executor.datasource.DataSourceBase;
import com.alibaba.alink.executor.datasource.MysqlDataSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.ml.api.misc.param.Params;

public class DataSourceFactory {
    static Map<String, Class<? extends DataSourceBase>> TYPE_CLASS_HASH = new HashMap<String, Class<? extends DataSourceBase>>();

    public static DataSourceBase MakeDataSource(String type, String config) {
        if (TYPE_CLASS_HASH.containsKey(type = type.toLowerCase())) {
            try {
                return TYPE_CLASS_HASH.get(type).newInstance().init(config);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Invalid type of DataSource");
    }

    public static List<String> ListProjects(String type, String config, String prefix, Integer maxCount) {
        if (TYPE_CLASS_HASH.containsKey(type = type.toLowerCase())) {
            try {
                return TYPE_CLASS_HASH.get(type).newInstance().listProjects(config, prefix, maxCount);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Invalid type of DataSource");
    }

    public static boolean isStreamOp(String funcName) {
        for (String s : TYPE_CLASS_HASH.keySet()) {
            if (!funcName.startsWith(s)) continue;
            return funcName.endsWith("stream-source") || funcName.endsWith("stream-sink");
        }
        return false;
    }

    public static boolean isDbOp(String funcName) {
        String type = DataSourceFactory.getTypeFromFuncName(funcName);
        if (TYPE_CLASS_HASH.containsKey(type)) {
            return funcName.endsWith("-source") || funcName.endsWith("-sink");
        }
        return false;
    }

    public static String getTypeFromFuncName(String funcName) {
        int i;
        for (i = 0; i < funcName.length() && funcName.charAt(i) != '-'; ++i) {
        }
        return funcName.substring(0, i);
    }

    public static String getProjectFromParameter(String type, Params param) {
        if (!TYPE_CLASS_HASH.containsKey(type)) {
            throw new RuntimeException("Invalid type of DataSource.");
        }
        try {
            return TYPE_CLASS_HASH.get(type).newInstance().getProjectNameFromParameters(param);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getTableNameFromParameter(String type, Params param) {
        if (!TYPE_CLASS_HASH.containsKey(type)) {
            throw new RuntimeException("Invalid type of DataSource.");
        }
        try {
            return TYPE_CLASS_HASH.get(type).newInstance().getTableNameFromParameters(param);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        TYPE_CLASS_HASH.put("mysql", MysqlDataSource.class);
    }
}

