/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.ModifyOperationVisitor;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;

@Internal
public class CatalogSinkModifyOperation
implements ModifyOperation {
    private final Map<String, String> staticPartitions;
    private final List<String> tablePath;
    private final QueryOperation child;

    public CatalogSinkModifyOperation(List<String> tablePath, QueryOperation child) {
        this(tablePath, child, new HashMap<String, String>());
    }

    public CatalogSinkModifyOperation(List<String> tablePath, QueryOperation child, Map<String, String> staticPartitions) {
        this.tablePath = tablePath;
        this.child = child;
        this.staticPartitions = staticPartitions;
    }

    public List<String> getTablePath() {
        return this.tablePath;
    }

    public Map<String, String> getStaticPartitions() {
        return this.staticPartitions;
    }

    @Override
    public QueryOperation getChild() {
        return this.child;
    }

    @Override
    public <T> T accept(ModifyOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("tablePath", this.tablePath);
        params.put("staticPartitions", this.staticPartitions);
        return OperationUtils.formatWithChildren("CatalogSink", params, Collections.singletonList(this.child), Operation::asSummaryString);
    }
}

