/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.expressions.LeafExpression;
import org.apache.flink.table.expressions.Literal$;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ew!B\u0001\u0003\u0011\u0003i\u0011a\u0002'ji\u0016\u0014\u0018\r\u001c\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u000f!\tQA\u001a7j].T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u0001\u0001C\u0001\b\u0010\u001b\u0005\u0011a!\u0002\t\u0003\u0011\u0003\t\"a\u0002'ji\u0016\u0014\u0018\r\\\n\u0004\u001fIA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u00143%\u0011!\u0004\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u00069=!\t!H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035A\u0001bH\bC\u0002\u0013\u0005a\u0001I\u0001\u0004+R\u001bU#A\u0011\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013\u0001B;uS2T\u0011AJ\u0001\u0005U\u00064\u0018-\u0003\u0002)G\tAA+[7f5>tW\r\u0003\u0004+\u001f\u0001\u0006I!I\u0001\u0005+R\u001b\u0005\u0005\u0003\u0004-\u001f\u0011\u0005a!L\u0001\u0006CB\u0004H.\u001f\u000b\u0004]\u0005M\u0005C\u0001\b0\r\u0011\u0001\"\u0001\u0011\u0019\u0014\t=\nD\u0007\u0007\t\u0003\u001dIJ!a\r\u0002\u0003\u001d1+\u0017MZ#yaJ,7o]5p]B\u00111#N\u0005\u0003mQ\u0011q\u0001\u0015:pIV\u001cG\u000f\u0003\u00059_\tU\r\u0011\"\u0001:\u0003\u00151\u0018\r\\;f+\u0005Q\u0004CA\n<\u0013\taDCA\u0002B]fD\u0001BP\u0018\u0003\u0012\u0003\u0006IAO\u0001\u0007m\u0006dW/\u001a\u0011\t\u0011\u0001{#Q3A\u0005\u0002\u0005\u000b!B]3tk2$H+\u001f9f+\u0005\u0011\u0005GA\"P!\r!5*T\u0007\u0002\u000b*\u0011aiR\u0001\tif\u0004X-\u001b8g_*\u0011\u0001*S\u0001\u0007G>lWn\u001c8\u000b\u0005)3\u0011aA1qS&\u0011A*\u0012\u0002\u0010)f\u0004X-\u00138g_Jl\u0017\r^5p]B\u0011aj\u0014\u0007\u0001\t%\u0001\u0016+!A\u0001\u0002\u000b\u0005qKA\u0002`IEB\u0001BU\u0018\u0003\u0012\u0003\u0006IaU\u0001\fe\u0016\u001cX\u000f\u001c;UsB,\u0007\u0005\r\u0002U-B\u0019AiS+\u0011\u000593F!\u0003)R\u0003\u0003\u0005\tQ!\u0001X#\tA&\b\u0005\u0002\u00143&\u0011!\f\u0006\u0002\b\u001d>$\b.\u001b8h\u0011\u0015ar\u0006\"\u0001])\rqSL\u0018\u0005\u0006qm\u0003\rA\u000f\u0005\u0006\u0001n\u0003\ra\u0018\u0019\u0003A\n\u00042\u0001R&b!\tq%\rB\u0005Q=\u0006\u0005\t\u0011!B\u0001/\")Am\fC!K\u0006AAo\\*ue&tw\rF\u0001g!\t9'N\u0004\u0002\u0014Q&\u0011\u0011\u000eF\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002j)!1an\fC!\r=\f\u0011\u0002^8SKbtu\u000eZ3\u0015\u0005AD\bCA9w\u001b\u0005\u0011(BA:u\u0003\r\u0011X\r\u001f\u0006\u0003k\"\tqaY1mG&$X-\u0003\u0002xe\n9!+\u001a=O_\u0012,\u0007\"B=n\u0001\bQ\u0018A\u0003:fY\n+\u0018\u000e\u001c3feB\u00111P`\u0007\u0002y*\u0011Q\u0010^\u0001\u0006i>|Gn]\u0005\u0003\u007fr\u0014!BU3m\u0005VLG\u000eZ3s\u0011\u001d\t\u0019a\fC\u0005\u0003\u000b\tqB^1mk\u0016\f5oQ1mK:$\u0017M]\u000b\u0003\u0003\u000f\u00012AIA\u0005\u0013\r\tYa\t\u0002\t\u0007\u0006dWM\u001c3be\"I\u0011qB\u0018\u0002\u0002\u0013\u0005\u0011\u0011C\u0001\u0005G>\u0004\u0018\u0010F\u0003/\u0003'\t)\u0002\u0003\u00059\u0003\u001b\u0001\n\u00111\u0001;\u0011!\u0001\u0015Q\u0002I\u0001\u0002\u0004y\u0006\"CA\r_E\u0005I\u0011AA\u000e\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\b+\u0007i\nyb\u000b\u0002\u0002\"A!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012!C;oG\",7m[3e\u0015\r\tY\u0003F\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0018\u0003K\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t\u0019dLI\u0001\n\u0003\t)$\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005]\u0002\u0007BA\u001d\u0003{\u0001B\u0001R&\u0002<A\u0019a*!\u0010\u0005\u0015A\u000b\t$!A\u0001\u0002\u000b\u0005q\u000bC\u0005\u0002B=\n\t\u0011\"\u0011\u0002D\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0012\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013&\u0003\u0011a\u0017M\\4\n\u0007-\fI\u0005C\u0005\u0002R=\n\t\u0011\"\u0001\u0002T\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u000b\t\u0004'\u0005]\u0013bAA-)\t\u0019\u0011J\u001c;\t\u0013\u0005us&!A\u0005\u0002\u0005}\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004u\u0005\u0005\u0004BCA2\u00037\n\t\u00111\u0001\u0002V\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005\u001dt&!A\u0005B\u0005%\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005-\u0004#BA7\u0003gRTBAA8\u0015\r\t\t\bF\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA;\u0003_\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003sz\u0013\u0011!C\u0001\u0003w\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003{\n\u0019\tE\u0002\u0014\u0003\u007fJ1!!!\u0015\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u0019\u0002x\u0005\u0005\t\u0019\u0001\u001e\t\u0013\u0005\u001du&!A\u0005B\u0005%\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005U\u0003\"CAG_\u0005\u0005I\u0011IAH\u0003\u0019)\u0017/^1mgR!\u0011QPAI\u0011%\t\u0019'a#\u0002\u0002\u0003\u0007!\b\u0003\u0004\u0002\u0016.\u0002\rAO\u0001\u0002Y\"AAfDA\u0001\n\u0003\u000bI\nF\u0003/\u00037\u000bi\n\u0003\u00049\u0003/\u0003\rA\u000f\u0005\b\u0001\u0006]\u0005\u0019AAPa\u0011\t\t+!*\u0011\t\u0011[\u00151\u0015\t\u0004\u001d\u0006\u0015FA\u0003)\u0002\u001e\u0006\u0005\t\u0011!B\u0001/\"I\u0011\u0011V\b\u0002\u0002\u0013\u0005\u00151V\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti+!11\t\u0005=\u0016q\u0018\t\u0006'\u0005E\u0016QW\u0005\u0004\u0003g#\"AB(qi&|g\u000e\u0005\u0004\u0014\u0003oS\u00141X\u0005\u0004\u0003s#\"A\u0002+va2,'\u0007\u0005\u0003E\u0017\u0006u\u0006c\u0001(\u0002@\u0012Q\u0001+a*\u0002\u0002\u0003\u0005)\u0011A,\t\u0013\u0005\r\u0017qUA\u0001\u0002\u0004q\u0013a\u0001=%a!I\u0011qY\b\u0002\u0002\u0013%\u0011\u0011Z\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002LB!\u0011qIAg\u0013\u0011\ty-!\u0013\u0003\r=\u0013'.Z2u\u0001")
public class Literal
extends LeafExpression
implements Serializable {
    private final Object value;
    private final TypeInformation<?> resultType;

    public static Option<Tuple2<Object, TypeInformation<Object>>> unapply(Literal literal) {
        return Literal$.MODULE$.unapply(literal);
    }

    public static Literal apply(Object object, TypeInformation<?> typeInformation) {
        return Literal$.MODULE$.apply(object, typeInformation);
    }

    public Object value() {
        return this.value;
    }

    @Override
    public TypeInformation<?> resultType() {
        return this.resultType;
    }

    public String toString() {
        String string;
        TypeInformation<?> typeInformation = this.resultType();
        if (typeInformation instanceof BasicTypeInfo) {
            string = this.value().toString();
        } else {
            SqlTimeTypeInfo sqlTimeTypeInfo = SqlTimeTypeInfo.DATE;
            TypeInformation<?> typeInformation2 = typeInformation;
            if (!(sqlTimeTypeInfo != null ? !sqlTimeTypeInfo.equals(typeInformation2) : typeInformation2 != null)) {
                string = new StringBuilder().append((Object)this.value().toString()).append((Object)".toDate").toString();
            } else {
                SqlTimeTypeInfo sqlTimeTypeInfo2 = SqlTimeTypeInfo.TIME;
                TypeInformation<?> typeInformation3 = typeInformation;
                if (!(sqlTimeTypeInfo2 != null ? !sqlTimeTypeInfo2.equals(typeInformation3) : typeInformation3 != null)) {
                    string = new StringBuilder().append((Object)this.value().toString()).append((Object)".toTime").toString();
                } else {
                    SqlTimeTypeInfo sqlTimeTypeInfo3 = SqlTimeTypeInfo.TIMESTAMP;
                    TypeInformation<?> typeInformation4 = typeInformation;
                    if (!(sqlTimeTypeInfo3 != null ? !sqlTimeTypeInfo3.equals(typeInformation4) : typeInformation4 != null)) {
                        string = new StringBuilder().append((Object)this.value().toString()).append((Object)".toTimestamp").toString();
                    } else {
                        TimeIntervalTypeInfo<Long> timeIntervalTypeInfo = TimeIntervalTypeInfo.INTERVAL_MILLIS;
                        TypeInformation<?> typeInformation5 = typeInformation;
                        if (!(timeIntervalTypeInfo != null ? !((Object)timeIntervalTypeInfo).equals(typeInformation5) : typeInformation5 != null)) {
                            string = new StringBuilder().append((Object)this.value().toString()).append((Object)".millis").toString();
                        } else {
                            TimeIntervalTypeInfo<Integer> timeIntervalTypeInfo2 = TimeIntervalTypeInfo.INTERVAL_MONTHS;
                            TypeInformation<?> typeInformation6 = typeInformation;
                            string = !(timeIntervalTypeInfo2 != null ? !((Object)timeIntervalTypeInfo2).equals(typeInformation6) : typeInformation6 != null) ? new StringBuilder().append((Object)this.value().toString()).append((Object)".months").toString() : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Literal(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value(), this.resultType()}));
                        }
                    }
                }
            }
        }
        return string;
    }

    @Override
    public RexNode toRexNode(RelBuilder relBuilder) {
        RexNode rexNode;
        TypeInformation<?> typeInformation = this.resultType();
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
        TypeInformation<?> typeInformation2 = typeInformation;
        if (!(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null)) {
            BigDecimal bigDecValue = (BigDecimal)this.value();
            RelDataType decType = relBuilder.getTypeFactory().createSqlType(SqlTypeName.DECIMAL);
            rexNode = relBuilder.getRexBuilder().makeExactLiteral(bigDecValue, decType);
        } else {
            BasicTypeInfo basicTypeInfo2 = BasicTypeInfo.LONG_TYPE_INFO;
            TypeInformation<?> typeInformation3 = typeInformation;
            if (!(basicTypeInfo2 != null ? !basicTypeInfo2.equals(typeInformation3) : typeInformation3 != null)) {
                BigDecimal bigint = BigDecimal.valueOf(BoxesRunTime.unboxToLong((Object)this.value()));
                rexNode = relBuilder.getRexBuilder().makeBigintLiteral(bigint);
            } else {
                SqlTimeTypeInfo sqlTimeTypeInfo = SqlTimeTypeInfo.DATE;
                TypeInformation<?> typeInformation4 = typeInformation;
                if (!(sqlTimeTypeInfo != null ? !sqlTimeTypeInfo.equals(typeInformation4) : typeInformation4 != null)) {
                    DateString datestr = DateString.fromCalendarFields(this.valueAsCalendar());
                    rexNode = relBuilder.getRexBuilder().makeDateLiteral(datestr);
                } else {
                    SqlTimeTypeInfo sqlTimeTypeInfo2 = SqlTimeTypeInfo.TIME;
                    TypeInformation<?> typeInformation5 = typeInformation;
                    if (!(sqlTimeTypeInfo2 != null ? !sqlTimeTypeInfo2.equals(typeInformation5) : typeInformation5 != null)) {
                        TimeString timestr = TimeString.fromCalendarFields(this.valueAsCalendar());
                        rexNode = relBuilder.getRexBuilder().makeTimeLiteral(timestr, 0);
                    } else {
                        SqlTimeTypeInfo sqlTimeTypeInfo3 = SqlTimeTypeInfo.TIMESTAMP;
                        TypeInformation<?> typeInformation6 = typeInformation;
                        if (!(sqlTimeTypeInfo3 != null ? !sqlTimeTypeInfo3.equals(typeInformation6) : typeInformation6 != null)) {
                            TimestampString timestampstr = TimestampString.fromCalendarFields(this.valueAsCalendar());
                            rexNode = relBuilder.getRexBuilder().makeTimestampLiteral(timestampstr, 3);
                        } else {
                            TimeIntervalTypeInfo<Integer> timeIntervalTypeInfo = TimeIntervalTypeInfo.INTERVAL_MONTHS;
                            TypeInformation<?> typeInformation7 = typeInformation;
                            if (!(timeIntervalTypeInfo != null ? !((Object)timeIntervalTypeInfo).equals(typeInformation7) : typeInformation7 != null)) {
                                BigDecimal interval = BigDecimal.valueOf(BoxesRunTime.unboxToInt((Object)this.value()));
                                SqlIntervalQualifier intervalQualifier = new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO);
                                rexNode = relBuilder.getRexBuilder().makeIntervalLiteral(interval, intervalQualifier);
                            } else {
                                TimeIntervalTypeInfo<Long> timeIntervalTypeInfo2 = TimeIntervalTypeInfo.INTERVAL_MILLIS;
                                TypeInformation<?> typeInformation8 = typeInformation;
                                if (!(timeIntervalTypeInfo2 != null ? !((Object)timeIntervalTypeInfo2).equals(typeInformation8) : typeInformation8 != null)) {
                                    BigDecimal interval = BigDecimal.valueOf(BoxesRunTime.unboxToLong((Object)this.value()));
                                    SqlIntervalQualifier intervalQualifier = new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO);
                                    rexNode = relBuilder.getRexBuilder().makeIntervalLiteral(interval, intervalQualifier);
                                } else {
                                    rexNode = relBuilder.literal(this.value());
                                }
                            }
                        }
                    }
                }
            }
        }
        return rexNode;
    }

    /*
     * WARNING - void declaration
     */
    private Calendar valueAsCalendar() {
        void var2_2;
        Date date = (Date)this.value();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return var2_2;
    }

    public Literal copy(Object value, TypeInformation<?> resultType2) {
        return new Literal(value, resultType2);
    }

    public Object copy$default$1() {
        return this.value();
    }

    public TypeInformation<?> copy$default$2() {
        return this.resultType();
    }

    @Override
    public String productPrefix() {
        return "Literal";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = this.resultType();
                break;
            }
            case 0: {
                object = this.value();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Literal;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Literal)) return false;
        boolean bl = true;
        if (!bl) return false;
        Literal literal = (Literal)x$1;
        if (!BoxesRunTime.equals((Object)this.value(), (Object)literal.value())) return false;
        TypeInformation<?> typeInformation = this.resultType();
        TypeInformation<?> typeInformation2 = literal.resultType();
        if (typeInformation == null) {
            if (typeInformation2 != null) {
                return false;
            }
        } else if (!typeInformation.equals(typeInformation2)) return false;
        if (!literal.canEqual(this)) return false;
        return true;
    }

    public Literal(Object value, TypeInformation<?> resultType2) {
        this.value = value;
        this.resultType = resultType2;
    }
}

