/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.cep.nfa.State;
import org.apache.flink.cep.nfa.StateTransitionAction;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;

public class StateTransition<T>
implements Serializable {
    private static final long serialVersionUID = -4825345749997891838L;
    private final StateTransitionAction action;
    private final State<T> sourceState;
    private final State<T> targetState;
    private IterativeCondition<T> condition;

    public StateTransition(State<T> sourceState, StateTransitionAction action, State<T> targetState, IterativeCondition<T> condition) {
        this.action = action;
        this.targetState = targetState;
        this.sourceState = sourceState;
        this.condition = condition;
    }

    public StateTransitionAction getAction() {
        return this.action;
    }

    public State<T> getTargetState() {
        return this.targetState;
    }

    public State<T> getSourceState() {
        return this.sourceState;
    }

    public IterativeCondition<T> getCondition() {
        return this.condition;
    }

    public void setCondition(IterativeCondition<T> condition) {
        this.condition = condition;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StateTransition) {
            StateTransition other = (StateTransition)obj;
            return this.action == other.action && this.sourceState.getName().equals(other.sourceState.getName()) && this.targetState.getName().equals(other.targetState.getName());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.targetState.getName(), this.sourceState.getName()});
    }

    public String toString() {
        return "StateTransition(" + (Object)((Object)this.action) + ", " + "from " + this.sourceState.getName() + "to " + this.targetState.getName() + (this.condition != null ? ", with condition)" : ")");
    }
}

