"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.0.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.access_group import AccessGroup
from delphix.api.gateway.model.access_group_account_ids_request import AccessGroupAccountIdsRequest
from delphix.api.gateway.model.access_group_scope import AccessGroupScope
from delphix.api.gateway.model.access_group_scopes_request import AccessGroupScopesRequest
from delphix.api.gateway.model.access_group_update_parameters import AccessGroupUpdateParameters
from delphix.api.gateway.model.all_object_permissions_response import AllObjectPermissionsResponse
from delphix.api.gateway.model.always_allowed_permission_request import AlwaysAllowedPermissionRequest
from delphix.api.gateway.model.create_role import CreateRole
from delphix.api.gateway.model.delete_scope_object_tags import DeleteScopeObjectTags
from delphix.api.gateway.model.delete_scoped_object_item import DeleteScopedObjectItem
from delphix.api.gateway.model.delete_tag import DeleteTag
from delphix.api.gateway.model.list_access_groups_response import ListAccessGroupsResponse
from delphix.api.gateway.model.list_roles_response import ListRolesResponse
from delphix.api.gateway.model.object_permissions_response import ObjectPermissionsResponse
from delphix.api.gateway.model.permissions_request import PermissionsRequest
from delphix.api.gateway.model.role import Role
from delphix.api.gateway.model.role_update_parameters import RoleUpdateParameters
from delphix.api.gateway.model.scope_tags_request import ScopeTagsRequest
from delphix.api.gateway.model.scope_tags_response import ScopeTagsResponse
from delphix.api.gateway.model.scoped_object_items_response import ScopedObjectItemsResponse
from delphix.api.gateway.model.scoped_objects_request import ScopedObjectsRequest
from delphix.api.gateway.model.search_access_groups_response import SearchAccessGroupsResponse
from delphix.api.gateway.model.search_body import SearchBody
from delphix.api.gateway.model.search_roles_response import SearchRolesResponse
from delphix.api.gateway.model.tags_request import TagsRequest
from delphix.api.gateway.model.update_access_group_scope import UpdateAccessGroupScope


class AuthorizationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_access_group_account_ids(
            self,
            access_group_id,
            access_group_account_ids_request,
            **kwargs
        ):
            """Add account ids to an Access group  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_access_group_account_ids(access_group_id, access_group_account_ids_request, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                access_group_account_ids_request (AccessGroupAccountIdsRequest): Account ids to add to the Access group.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['access_group_account_ids_request'] = \
                access_group_account_ids_request
            return self.call_with_http_info(**kwargs)

        self.add_access_group_account_ids = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/account-ids',
                'operation_id': 'add_access_group_account_ids',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'access_group_account_ids_request',
                ],
                'required': [
                    'access_group_id',
                    'access_group_account_ids_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'access_group_account_ids_request':
                        (AccessGroupAccountIdsRequest,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'access_group_account_ids_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_access_group_account_ids
        )

        def __add_access_group_account_tags(
            self,
            access_group_id,
            tags_request,
            **kwargs
        ):
            """Add account tags to an Access group  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_access_group_account_tags(access_group_id, tags_request, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                tags_request (TagsRequest): Account Tags to add to the Access group.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['tags_request'] = \
                tags_request
            return self.call_with_http_info(**kwargs)

        self.add_access_group_account_tags = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/tags',
                'operation_id': 'add_access_group_account_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'tags_request',
                ],
                'required': [
                    'access_group_id',
                    'tags_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'tags_request':
                        (TagsRequest,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'tags_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_access_group_account_tags
        )

        def __add_access_group_scopes(
            self,
            access_group_id,
            access_group_scopes_request,
            **kwargs
        ):
            """Add scopes to an Access group  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_access_group_scopes(access_group_id, access_group_scopes_request, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                access_group_scopes_request (AccessGroupScopesRequest): Scopes to add to the Access group.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['access_group_scopes_request'] = \
                access_group_scopes_request
            return self.call_with_http_info(**kwargs)

        self.add_access_group_scopes = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/scopes',
                'operation_id': 'add_access_group_scopes',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'access_group_scopes_request',
                ],
                'required': [
                    'access_group_id',
                    'access_group_scopes_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'access_group_scopes_request':
                        (AccessGroupScopesRequest,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'access_group_scopes_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_access_group_scopes
        )

        def __add_always_allowed_permissions(
            self,
            access_group_id,
            scope_id,
            always_allowed_permission_request,
            **kwargs
        ):
            """Add always allowed permissions for given object type.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_always_allowed_permissions(access_group_id, scope_id, always_allowed_permission_request, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                scope_id (str): The ID of the Access group scope.
                always_allowed_permission_request (AlwaysAllowedPermissionRequest): Add always allowed permissions for given object type.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroupScope
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['scope_id'] = \
                scope_id
            kwargs['always_allowed_permission_request'] = \
                always_allowed_permission_request
            return self.call_with_http_info(**kwargs)

        self.add_always_allowed_permissions = _Endpoint(
            settings={
                'response_type': (AccessGroupScope,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/scopes/{scopeId}/always_allowed_permissions',
                'operation_id': 'add_always_allowed_permissions',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'scope_id',
                    'always_allowed_permission_request',
                ],
                'required': [
                    'access_group_id',
                    'scope_id',
                    'always_allowed_permission_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                    'scope_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                    ('scope_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'scope_id':
                        (str,),
                    'always_allowed_permission_request':
                        (AlwaysAllowedPermissionRequest,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                    'scope_id': 'scopeId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'scope_id': 'path',
                    'always_allowed_permission_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_always_allowed_permissions
        )

        def __add_objects_to_access_group_scope(
            self,
            access_group_id,
            scope_id,
            scoped_objects_request,
            **kwargs
        ):
            """Add objects to the access group scope.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_objects_to_access_group_scope(access_group_id, scope_id, scoped_objects_request, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                scope_id (str): The ID of the Access group scope.
                scoped_objects_request (ScopedObjectsRequest): Add objects to the access group scope.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ScopedObjectItemsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['scope_id'] = \
                scope_id
            kwargs['scoped_objects_request'] = \
                scoped_objects_request
            return self.call_with_http_info(**kwargs)

        self.add_objects_to_access_group_scope = _Endpoint(
            settings={
                'response_type': (ScopedObjectItemsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/scopes/{scopeId}/objects',
                'operation_id': 'add_objects_to_access_group_scope',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'scope_id',
                    'scoped_objects_request',
                ],
                'required': [
                    'access_group_id',
                    'scope_id',
                    'scoped_objects_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                    'scope_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                    ('scope_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'scope_id':
                        (str,),
                    'scoped_objects_request':
                        (ScopedObjectsRequest,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                    'scope_id': 'scopeId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'scope_id': 'path',
                    'scoped_objects_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_objects_to_access_group_scope
        )

        def __add_role_permissions(
            self,
            role_id,
            permissions_request,
            **kwargs
        ):
            """Add permissions to a role.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_role_permissions(role_id, permissions_request, async_req=True)
            >>> result = thread.get()

            Args:
                role_id (str): The ID of the role.
                permissions_request (PermissionsRequest): Permissions to add to the role.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Role
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['role_id'] = \
                role_id
            kwargs['permissions_request'] = \
                permissions_request
            return self.call_with_http_info(**kwargs)

        self.add_role_permissions = _Endpoint(
            settings={
                'response_type': (Role,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/roles/{roleId}/permissions',
                'operation_id': 'add_role_permissions',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'role_id',
                    'permissions_request',
                ],
                'required': [
                    'role_id',
                    'permissions_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'role_id',
                ]
            },
            root_map={
                'validations': {
                    ('role_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'role_id':
                        (str,),
                    'permissions_request':
                        (PermissionsRequest,),
                },
                'attribute_map': {
                    'role_id': 'roleId',
                },
                'location_map': {
                    'role_id': 'path',
                    'permissions_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_role_permissions
        )

        def __add_tags_to_scope(
            self,
            access_group_id,
            scope_id,
            scope_tags_request,
            **kwargs
        ):
            """Add object tags to the access group scope.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_tags_to_scope(access_group_id, scope_id, scope_tags_request, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                scope_id (str): The ID of the Access group scope.
                scope_tags_request (ScopeTagsRequest): Object tags for the access group scope.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ScopeTagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['scope_id'] = \
                scope_id
            kwargs['scope_tags_request'] = \
                scope_tags_request
            return self.call_with_http_info(**kwargs)

        self.add_tags_to_scope = _Endpoint(
            settings={
                'response_type': (ScopeTagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/scopes/{scopeId}/object-tags',
                'operation_id': 'add_tags_to_scope',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'scope_id',
                    'scope_tags_request',
                ],
                'required': [
                    'access_group_id',
                    'scope_id',
                    'scope_tags_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                    'scope_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                    ('scope_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'scope_id':
                        (str,),
                    'scope_tags_request':
                        (ScopeTagsRequest,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                    'scope_id': 'scopeId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'scope_id': 'path',
                    'scope_tags_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_tags_to_scope
        )

        def __create_access_group(
            self,
            access_group,
            **kwargs
        ):
            """Create a new access group.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_access_group(access_group, async_req=True)
            >>> result = thread.get()

            Args:
                access_group (AccessGroup):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group'] = \
                access_group
            return self.call_with_http_info(**kwargs)

        self.create_access_group = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups',
                'operation_id': 'create_access_group',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group',
                ],
                'required': [
                    'access_group',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group':
                        (AccessGroup,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'access_group': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_access_group
        )

        def __create_role(
            self,
            **kwargs
        ):
            """Create custom role  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_role(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                create_role (CreateRole): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Role
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.create_role = _Endpoint(
            settings={
                'response_type': (Role,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/roles',
                'operation_id': 'create_role',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_role',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_role':
                        (CreateRole,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_role': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_role
        )

        def __delete_access_group(
            self,
            access_group_id,
            **kwargs
        ):
            """Delete an Access group.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_access_group(access_group_id, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            return self.call_with_http_info(**kwargs)

        self.delete_access_group = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}',
                'operation_id': 'delete_access_group',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                ],
                'required': [
                    'access_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                },
                'location_map': {
                    'access_group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_access_group
        )

        def __delete_access_group_scope_object_tags(
            self,
            access_group_id,
            scope_id,
            **kwargs
        ):
            """Remove tags from the access group scope.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_access_group_scope_object_tags(access_group_id, scope_id, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                scope_id (str): The ID of the Access group scope.

            Keyword Args:
                delete_scope_object_tags (DeleteScopeObjectTags): The parameters to delete scope objects tags. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ScopeTagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['scope_id'] = \
                scope_id
            return self.call_with_http_info(**kwargs)

        self.delete_access_group_scope_object_tags = _Endpoint(
            settings={
                'response_type': (ScopeTagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/scopes/{scopeId}/object-tags/delete',
                'operation_id': 'delete_access_group_scope_object_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'scope_id',
                    'delete_scope_object_tags',
                ],
                'required': [
                    'access_group_id',
                    'scope_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                    'scope_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                    ('scope_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'scope_id':
                        (str,),
                    'delete_scope_object_tags':
                        (DeleteScopeObjectTags,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                    'scope_id': 'scopeId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'scope_id': 'path',
                    'delete_scope_object_tags': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_access_group_scope_object_tags
        )

        def __delete_access_group_scope_objects(
            self,
            access_group_id,
            scope_id,
            **kwargs
        ):
            """Remove objects from the access group scope.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_access_group_scope_objects(access_group_id, scope_id, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                scope_id (str): The ID of the Access group scope.

            Keyword Args:
                delete_scoped_object_item (DeleteScopedObjectItem): The parameters to delete scope objects. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ScopedObjectItemsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['scope_id'] = \
                scope_id
            return self.call_with_http_info(**kwargs)

        self.delete_access_group_scope_objects = _Endpoint(
            settings={
                'response_type': (ScopedObjectItemsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/scopes/{scopeId}/objects/delete',
                'operation_id': 'delete_access_group_scope_objects',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'scope_id',
                    'delete_scoped_object_item',
                ],
                'required': [
                    'access_group_id',
                    'scope_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                    'scope_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                    ('scope_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'scope_id':
                        (str,),
                    'delete_scoped_object_item':
                        (DeleteScopedObjectItem,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                    'scope_id': 'scopeId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'scope_id': 'path',
                    'delete_scoped_object_item': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_access_group_scope_objects
        )

        def __delete_role(
            self,
            role_id,
            **kwargs
        ):
            """Delete role by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_role(role_id, async_req=True)
            >>> result = thread.get()

            Args:
                role_id (str): The ID of the role.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['role_id'] = \
                role_id
            return self.call_with_http_info(**kwargs)

        self.delete_role = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/roles/{roleId}',
                'operation_id': 'delete_role',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'role_id',
                ],
                'required': [
                    'role_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'role_id',
                ]
            },
            root_map={
                'validations': {
                    ('role_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'role_id':
                        (str,),
                },
                'attribute_map': {
                    'role_id': 'roleId',
                },
                'location_map': {
                    'role_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_role
        )

        def __get_access_group_by_id(
            self,
            access_group_id,
            **kwargs
        ):
            """Returns an Access group by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_access_group_by_id(access_group_id, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            return self.call_with_http_info(**kwargs)

        self.get_access_group_by_id = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}',
                'operation_id': 'get_access_group_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                ],
                'required': [
                    'access_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                },
                'location_map': {
                    'access_group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_access_group_by_id
        )

        def __get_access_group_scope(
            self,
            access_group_id,
            scope_id,
            **kwargs
        ):
            """Get access group scope.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_access_group_scope(access_group_id, scope_id, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                scope_id (str): The ID of the Access group scope.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroupScope
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['scope_id'] = \
                scope_id
            return self.call_with_http_info(**kwargs)

        self.get_access_group_scope = _Endpoint(
            settings={
                'response_type': (AccessGroupScope,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/scopes/{scopeId}',
                'operation_id': 'get_access_group_scope',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'scope_id',
                ],
                'required': [
                    'access_group_id',
                    'scope_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                    'scope_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                    ('scope_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'scope_id':
                        (str,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                    'scope_id': 'scopeId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'scope_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_access_group_scope
        )

        def __get_access_groups(
            self,
            **kwargs
        ):
            """List all access groups.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_access_groups(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListAccessGroupsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_access_groups = _Endpoint(
            settings={
                'response_type': (ListAccessGroupsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups',
                'operation_id': 'get_access_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_access_groups
        )

        def __get_all_object_permissions(
            self,
            **kwargs
        ):
            """Returns all of the possible permissions for all of the objects.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_all_object_permissions(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AllObjectPermissionsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_all_object_permissions = _Endpoint(
            settings={
                'response_type': (AllObjectPermissionsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/auth/object-permissions',
                'operation_id': 'get_all_object_permissions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_all_object_permissions
        )

        def __get_object_permissions(
            self,
            object_type,
            object_id,
            **kwargs
        ):
            """Returns permissions for given object.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_object_permissions(object_type, object_id, async_req=True)
            >>> result = thread.get()

            Args:
                object_type (str): The type of the DCT object.
                object_id (str): The ID of the DCT Object.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjectPermissionsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['object_type'] = \
                object_type
            kwargs['object_id'] = \
                object_id
            return self.call_with_http_info(**kwargs)

        self.get_object_permissions = _Endpoint(
            settings={
                'response_type': (ObjectPermissionsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/auth/permissions/objects/{objectType}/{objectId}',
                'operation_id': 'get_object_permissions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'object_type',
                    'object_id',
                ],
                'required': [
                    'object_type',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'object_type',
                ],
                'validation': [
                    'object_id',
                ]
            },
            root_map={
                'validations': {
                    ('object_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('object_type',): {

                        "ACCESS_GROUP": "ACCESS_GROUP",
                        "ACCOUNT": "ACCOUNT",
                        "ROLE": "ROLE",
                        "API_USAGE_REPORT": "API_USAGE_REPORT",
                        "BOOKMARK": "BOOKMARK",
                        "CDB": "CDB",
                        "DATABASE_TEMPLATE": "DATABASE_TEMPLATE",
                        "DSOURCE": "DSOURCE",
                        "ENGINE": "ENGINE",
                        "ENVIRONMENT": "ENVIRONMENT",
                        "MASKING_JOB": "MASKING_JOB",
                        "MASKING_JOB_SET": "MASKING_JOB_SET",
                        "REPORT_SCHEDULE": "REPORT_SCHEDULE",
                        "SOURCE": "SOURCE",
                        "VAULT": "VAULT",
                        "VCDB": "VCDB",
                        "VDB": "VDB",
                        "VDB_GROUP": "VDB_GROUP",
                        "CONNECTOR": "CONNECTOR",
                        "CONNECTIVITY_CHECK": "CONNECTIVITY_CHECK",
                        "DSOURCE_USAGE_REPORT": "DSOURCE_USAGE_REPORT",
                        "DSOURCE_CONSUMPTION_REPORT": "DSOURCE_CONSUMPTION_REPORT",
                        "JOB": "JOB",
                        "PRODUCT_INFO": "PRODUCT_INFO",
                        "ROLE": "ROLE",
                        "SMTP_CONFIG": "SMTP_CONFIG",
                        "STORAGE_SUMMARY_REPORT": "STORAGE_SUMMARY_REPORT",
                        "VDB_INVENTORY_REPORT": "VDB_INVENTORY_REPORT",
                        "LDAP": "LDAP",
                        "SAML": "SAML",
                        "PASSWORD_POLICY": "PASSWORD_POLICY",
                        "GLOBAL_PROPERTIES": "GLOBAL_PROPERTIES",
                        "API_CLASSIFICATION": "API_CLASSIFICATION"
                    },
                },
                'openapi_types': {
                    'object_type':
                        (str,),
                    'object_id':
                        (str,),
                },
                'attribute_map': {
                    'object_type': 'objectType',
                    'object_id': 'objectId',
                },
                'location_map': {
                    'object_type': 'path',
                    'object_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_object_permissions
        )

        def __get_role_by_id(
            self,
            role_id,
            **kwargs
        ):
            """Returns role by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_role_by_id(role_id, async_req=True)
            >>> result = thread.get()

            Args:
                role_id (str): The ID of the role.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Role
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['role_id'] = \
                role_id
            return self.call_with_http_info(**kwargs)

        self.get_role_by_id = _Endpoint(
            settings={
                'response_type': (Role,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/roles/{roleId}',
                'operation_id': 'get_role_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'role_id',
                ],
                'required': [
                    'role_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'role_id',
                ]
            },
            root_map={
                'validations': {
                    ('role_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'role_id':
                        (str,),
                },
                'attribute_map': {
                    'role_id': 'roleId',
                },
                'location_map': {
                    'role_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_role_by_id
        )

        def __get_roles(
            self,
            **kwargs
        ):
            """List all roles  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_roles(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListRolesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_roles = _Endpoint(
            settings={
                'response_type': (ListRolesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/roles',
                'operation_id': 'get_roles',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_roles
        )

        def __remove_access_group_account_id(
            self,
            access_group_id,
            account_id,
            **kwargs
        ):
            """Remove the account from the access group.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remove_access_group_account_id(access_group_id, account_id, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                account_id (int): The ID of the account.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.remove_access_group_account_id = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/account-ids/{accountId}',
                'operation_id': 'remove_access_group_account_id',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'account_id',
                ],
                'required': [
                    'access_group_id',
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'account_id':
                        (int,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                    'account_id': 'accountId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'account_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__remove_access_group_account_id
        )

        def __remove_access_group_account_tags(
            self,
            access_group_id,
            **kwargs
        ):
            """Remove account tags from an access group.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remove_access_group_account_tags(access_group_id, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.

            Keyword Args:
                delete_tag (DeleteTag): The parameters to delete tags. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            return self.call_with_http_info(**kwargs)

        self.remove_access_group_account_tags = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/tags/delete',
                'operation_id': 'remove_access_group_account_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'delete_tag',
                ],
                'required': [
                    'access_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'delete_tag':
                        (DeleteTag,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'delete_tag': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__remove_access_group_account_tags
        )

        def __remove_access_group_scope(
            self,
            access_group_id,
            scope_id,
            **kwargs
        ):
            """Remove the scope from the Access group.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remove_access_group_scope(access_group_id, scope_id, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                scope_id (str): The ID of the Access group scope.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['scope_id'] = \
                scope_id
            return self.call_with_http_info(**kwargs)

        self.remove_access_group_scope = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/scopes/{scopeId}',
                'operation_id': 'remove_access_group_scope',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'scope_id',
                ],
                'required': [
                    'access_group_id',
                    'scope_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                    'scope_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                    ('scope_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'scope_id':
                        (str,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                    'scope_id': 'scopeId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'scope_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__remove_access_group_scope
        )

        def __remove_always_allowed_permissions(
            self,
            access_group_id,
            scope_id,
            always_allowed_permission_request,
            **kwargs
        ):
            """Remove always allowed permissions for given object type.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remove_always_allowed_permissions(access_group_id, scope_id, always_allowed_permission_request, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                scope_id (str): The ID of the Access group scope.
                always_allowed_permission_request (AlwaysAllowedPermissionRequest): Remove always allowed permissions for given object type.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroupScope
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['scope_id'] = \
                scope_id
            kwargs['always_allowed_permission_request'] = \
                always_allowed_permission_request
            return self.call_with_http_info(**kwargs)

        self.remove_always_allowed_permissions = _Endpoint(
            settings={
                'response_type': (AccessGroupScope,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/scopes/{scopeId}/always_allowed_permissions/delete',
                'operation_id': 'remove_always_allowed_permissions',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'scope_id',
                    'always_allowed_permission_request',
                ],
                'required': [
                    'access_group_id',
                    'scope_id',
                    'always_allowed_permission_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                    'scope_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                    ('scope_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'scope_id':
                        (str,),
                    'always_allowed_permission_request':
                        (AlwaysAllowedPermissionRequest,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                    'scope_id': 'scopeId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'scope_id': 'path',
                    'always_allowed_permission_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__remove_always_allowed_permissions
        )

        def __remove_role_permissions(
            self,
            role_id,
            permissions_request,
            **kwargs
        ):
            """Remove permissions from a role.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remove_role_permissions(role_id, permissions_request, async_req=True)
            >>> result = thread.get()

            Args:
                role_id (str): The ID of the role.
                permissions_request (PermissionsRequest): Permissions to remove from the role.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Role
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['role_id'] = \
                role_id
            kwargs['permissions_request'] = \
                permissions_request
            return self.call_with_http_info(**kwargs)

        self.remove_role_permissions = _Endpoint(
            settings={
                'response_type': (Role,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/roles/{roleId}/permissions/delete',
                'operation_id': 'remove_role_permissions',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'role_id',
                    'permissions_request',
                ],
                'required': [
                    'role_id',
                    'permissions_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'role_id',
                ]
            },
            root_map={
                'validations': {
                    ('role_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'role_id':
                        (str,),
                    'permissions_request':
                        (PermissionsRequest,),
                },
                'attribute_map': {
                    'role_id': 'roleId',
                },
                'location_map': {
                    'role_id': 'path',
                    'permissions_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__remove_role_permissions
        )

        def __search_access_groups(
            self,
            **kwargs
        ):
            """Search for access groups.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_access_groups(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchAccessGroupsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_access_groups = _Endpoint(
            settings={
                'response_type': (SearchAccessGroupsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/search',
                'operation_id': 'search_access_groups',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_access_groups
        )

        def __search_roles(
            self,
            **kwargs
        ):
            """Search for roles.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_roles(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchRolesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_roles = _Endpoint(
            settings={
                'response_type': (SearchRolesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/roles/search',
                'operation_id': 'search_roles',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "DESCRIPTION": "description",
                        "-DESCRIPTION": "-description"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_roles
        )

        def __update_access_group(
            self,
            access_group_id,
            **kwargs
        ):
            """Update an Access group.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_access_group(access_group_id, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.

            Keyword Args:
                access_group_update_parameters (AccessGroupUpdateParameters): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            return self.call_with_http_info(**kwargs)

        self.update_access_group = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}',
                'operation_id': 'update_access_group',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'access_group_update_parameters',
                ],
                'required': [
                    'access_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'access_group_update_parameters':
                        (AccessGroupUpdateParameters,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'access_group_update_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_access_group
        )

        def __update_access_group_scope(
            self,
            access_group_id,
            scope_id,
            update_access_group_scope,
            **kwargs
        ):
            """Update access group scope.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_access_group_scope(access_group_id, scope_id, update_access_group_scope, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                scope_id (str): The ID of the Access group scope.
                update_access_group_scope (UpdateAccessGroupScope): Access group scope to update.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroupScope
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['scope_id'] = \
                scope_id
            kwargs['update_access_group_scope'] = \
                update_access_group_scope
            return self.call_with_http_info(**kwargs)

        self.update_access_group_scope = _Endpoint(
            settings={
                'response_type': (AccessGroupScope,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/scopes/{scopeId}',
                'operation_id': 'update_access_group_scope',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'scope_id',
                    'update_access_group_scope',
                ],
                'required': [
                    'access_group_id',
                    'scope_id',
                    'update_access_group_scope',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                    'scope_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                    ('scope_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'scope_id':
                        (str,),
                    'update_access_group_scope':
                        (UpdateAccessGroupScope,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                    'scope_id': 'scopeId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'scope_id': 'path',
                    'update_access_group_scope': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_access_group_scope
        )

        def __update_role(
            self,
            role_id,
            **kwargs
        ):
            """Update a Role.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_role(role_id, async_req=True)
            >>> result = thread.get()

            Args:
                role_id (str): The ID of the role.

            Keyword Args:
                role_update_parameters (RoleUpdateParameters): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Role
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['role_id'] = \
                role_id
            return self.call_with_http_info(**kwargs)

        self.update_role = _Endpoint(
            settings={
                'response_type': (Role,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/roles/{roleId}',
                'operation_id': 'update_role',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'role_id',
                    'role_update_parameters',
                ],
                'required': [
                    'role_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'role_id',
                ]
            },
            root_map={
                'validations': {
                    ('role_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'role_id':
                        (str,),
                    'role_update_parameters':
                        (RoleUpdateParameters,),
                },
                'attribute_map': {
                    'role_id': 'roleId',
                },
                'location_map': {
                    'role_id': 'path',
                    'role_update_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_role
        )
