# oapi

[![test](https://github.com/enorganic/oapi/actions/workflows/test.yml/badge.svg?branch=main)](https://github.com/enorganic/oapi/actions/workflows/test.yml)
[![PyPI version](https://badge.fury.io/py/oapi.svg?icon=si%3Apython)](https://badge.fury.io/py/oapi)

`oapi` is a library for authoring python client libraries for web APIs
based on an OpenAPI specification (both
OpenAPI/Swagger [version 2
](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/2.0.md)
and [version 3
](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.1.1.md)
are supported).

`oapi`-generated packages/modules differ from those generated by other tools
(including but not limited to
[swagger-codegen](https://github.com/swagger-api/swagger-codegen)) in that
`oapi` generates a data model which enforces the schemas defined
in the OpenAPI specification. This means that request and response objects,
and their properties/items/members, cannot comprise data types which differ
from those specified in their OpenAPI document. Additionally, request and
response objects can be validated using `sob.validate` to verify that they
were not parsed from an object having attributes *not* defined in the
element's JSON schema, and *have* all required attributes. `oapi`
fully supports polymorphism when a schema has an "anyOf", "allOf", or
"oneOf" attribute (although `oapi` does not *require* a [discriminator
](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.1.1.md#discriminator-object)
to be defined).

Notable features of an `oapi` generated client/model library include:

- `oapi` generated data models and clients are fully type-annotated
- `oapi` generated data models and clients adhere to PEP-8 formatting
- `oapi` generated data models and clients include docstrings for all models,
  model properties, client methods, and client method parameters, inferred
  from "description" and "summary" attributes of elements within the
  specification
- `oapi` generated clients will handle the most common server-to-server
  authentication methods out-of-box, including the OAuth2 authorization
  code flow (client_id/client_secret), API keys, bearer tokens, HTTP basic
  auth, and most cookie-based authentication patterns. Custom authentication
  methods are also easily accomplished by specifying custom base classes
  and/or passing initialization decorators to `oapi.write_client_module`.
- `oapi` generated clients and models are easily updated. For instance: `oapi`
  generated data model classes can be renamed using your favorite IDE's
  refactoring tools, and subsequent updates to that data model (such as
  to reflect minor-version updates to the spec which add endpoints, schemas,
  parameters, etc.) will retain your new class names, so long as the
  schema from which the class was generated remains in the same location
  within the spec. Class naming can also be customized by passing a custom
  hook to the *get_class_name_from_pointer* parameter for
  `oapi.write_model_module`.