from recombee_api_client.api_requests.request import Request
import uuid

DEFAULT = uuid.uuid4()

class DeleteCartAddition(Request):
    """
    Deletes an existing cart addition uniquely specified by `userId`, `itemId`, and `timestamp` or all the cart additions with given `userId` and `itemId` if `timestamp` is omitted.
    
    Required parameters:
    
    :param user_id: ID of the user who made the cart addition.
    
    :param item_id: ID of the item of which was added to cart.
    
    
    Optional parameters:
    
    :param timestamp: Unix timestamp of the cart addition. If the `timestamp` is omitted, then all the cart additions with given `userId` and `itemId` are deleted.
    

    """

    def __init__(self, user_id, item_id, timestamp=DEFAULT):
        self.user_id = user_id
        self.item_id = item_id
        self.timestamp = timestamp
        self.timeout = 1000
        self.ensure_https = False
        self.method = 'delete'
        self.path = "/cartadditions/" % ()

    def get_body_parameters(self):
        """
        Values of body parameters as a dictionary (name of parameter: value of the parameter).
        """
        p = dict()
        return p

    def get_query_parameters(self):
        """
        Values of query parameters as a dictionary (name of parameter: value of the parameter).
        """
        params = dict()
        params['userId'] = self.user_id
        params['itemId'] = self.item_id
        if self.timestamp is not DEFAULT:
            params['timestamp'] = self.timestamp
        return params
