![](logo.png)

[![CodeFactor](https://www.codefactor.io/repository/github/everlookneversee/diagtomodel/badge)](https://www.codefactor.io/repository/github/everlookneversee/diagtomodel)
[![MIT License](https://img.shields.io/apm/l/atomic-design-ui.svg?)](https://github.com/tterb/atomic-design-ui/blob/master/LICENSEs)
[![CodeQL](https://github.com/EverLookNeverSee/diag2model/actions/workflows/codeql-analysis.yml/badge.svg)](https://github.com/EverLookNeverSee/diagtomodel/actions/workflows/codeql-analysis.yml)
![GitHub language count](https://img.shields.io/github/languages/count/EverLookNeverSee/diagtomodel)
![GitHub top language](https://img.shields.io/github/languages/top/EverLookNeverSee/diagtomodel)
![GitHub code size in bytes](https://img.shields.io/github/languages/code-size/EverLookNeverSee/diagtomodel)
![Lines of code](https://img.shields.io/tokei/lines/github/EverLookNeverSee/diagtomodel)
![GitHub all releases](https://img.shields.io/github/downloads/EverLookNeverSee/diagtomodel/total)
![GitHub issues](https://img.shields.io/github/issues-raw/EverLookNeverSee/diagtomodel)
![GitHub pull requests](https://img.shields.io/github/issues-pr-raw/EverLookNeverSee/diagtomodel)
![GitHub release (latest by date)](https://img.shields.io/github/v/release/EverLookNeverSee/diagtomodel)
![GitHub contributors](https://img.shields.io/github/contributors/EverLookNeverSee/diagtomodel)
![GitHub last commit](https://img.shields.io/github/last-commit/EverLookNeverSee/diagtomodel)

### Implementations of Artificial Neural Networks Based on their Diagrams

## Authors
* Milad Sadeghi DM - [EverlookNeverSee@GitHub](https://github.com/EverLookNeverSee)
* List of [all contributors](https://github.com/EverLookNeverSee/diagtomodel/graphs/contributors) to this repository

## Implemented Models
* [PLNet](diagtomodel/pl_net/pl_net.py) - Convolutional Neural Network with Parallel Layers
* [MLANet](diagtomodel/mla_net/mla_net.py) - Convolutional Neural Network with Multiple Layer Additions
* [LeNet-5](diagtomodel/lenet_5/lenet-5.py) - Gradient-Based Learning Applied to Document Recognition
* [AlexNet](diagtomodel/alexnet/alexnet.py) - ImageNet Classification with Deep Convolutional
Neural Networks
* [VGG-16](diagtomodel/vgg_16/vgg-16.py) - Very Deep Convolutional Networks For Large Scale Image Recognition
* [Inception-v1](diagtomodel/inception_v1/inception-v1.py) - Going Deeper With Convolutions
* [Xception](diagtomodel/xception/xception.py) - Deep Learning with Depthwise Separable Convolutions


## License
This project licensed under the MIT License - see the [LICENSE](LICENSE) file for more details.
