from setuptools import setup

setup(name='nnunet',
      packages=["nnunet",
                "nnunet.dataset_conversion",
                "nnunet.evaluation",
                "nnunet.evaluation.model_selection",
                "nnunet.experiment_planning",
                "nnunet.inference",
                "nnunet.network_architecture",
                "nnunet.preprocessing",
                "nnunet.run",
                "nnunet.training",
                "nnunet.training.cascade_stuff",
                "nnunet.training.data_augmentation",
                "nnunet.training.dataloading",
                "nnunet.training.loss_functions",
                "nnunet.training.network_training",
                "nnunet.training.network_training.nnUNet_variants",
                "nnunet.utilities",
                ],
      version='0.4',
      description='no new-net. Framework for out-of-the box medical image segmentation.',
      url='https://github.com/MIC-DKFZ/nnUNet',
      author='Division of Medical Image Computing, German Cancer Research Center',
      author_email='f.isensee@dkfz-heidelberg.de',
      license='Apache License Version 2.0, January 2004',
      install_requires=[
            "torch",
            "tqdm",
            "dicom2nifti",
            "scikit-image>=0.14",
            "medpy",
            "scipy",
            "batchgenerators>=0.19.3",
            "numpy",
            "sklearn",
            "SimpleITK",
            "pandas",
      ],
      keywords=['deep learning', 'image segmentation', 'medical image analysis',
                'medical image segmentation', 'nnU-Net', 'nnunet']
      )
