# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FusionAuthIdpTwitchArgs', 'FusionAuthIdpTwitch']

@pulumi.input_type
class FusionAuthIdpTwitchArgs:
    def __init__(__self__, *,
                 button_text: pulumi.Input[str],
                 client_id: pulumi.Input[str],
                 client_secret: pulumi.Input[str],
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpTwitchApplicationConfigurationArgs']]]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpTwitchTenantConfigurationArgs']]]] = None):
        """
        The set of arguments for constructing a FusionAuthIdpTwitch resource.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] client_id: TThe top-level Xbox client id for your Application. This value is retrieved from the Xbox developer website when you setup your Xbox developer account.
        :param pulumi.Input[str] client_secret: The top-level client secret to use with the Xbox Identity Provider when retrieving the long-lived token. This value is retrieved from the Xbox developer website when you setup your Xbox developer account.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpTwitchApplicationConfigurationArgs']]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] idp_id: The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] scope: The top-level scope that you are requesting from Xbox.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpTwitchTenantConfigurationArgs']]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        pulumi.set(__self__, "button_text", button_text)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        if application_configurations is not None:
            pulumi.set(__self__, "application_configurations", application_configurations)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idp_id is not None:
            pulumi.set(__self__, "idp_id", idp_id)
        if lambda_reconcile_id is not None:
            pulumi.set(__self__, "lambda_reconcile_id", lambda_reconcile_id)
        if linking_strategy is not None:
            pulumi.set(__self__, "linking_strategy", linking_strategy)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if tenant_configurations is not None:
            pulumi.set(__self__, "tenant_configurations", tenant_configurations)

    @property
    @pulumi.getter(name="buttonText")
    def button_text(self) -> pulumi.Input[str]:
        """
        The top-level button text to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_text")

    @button_text.setter
    def button_text(self, value: pulumi.Input[str]):
        pulumi.set(self, "button_text", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        TThe top-level Xbox client id for your Application. This value is retrieved from the Xbox developer website when you setup your Xbox developer account.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[str]:
        """
        The top-level client secret to use with the Xbox Identity Provider when retrieving the long-lived token. This value is retrieved from the Xbox developer website when you setup your Xbox developer account.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpTwitchApplicationConfigurationArgs']]]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @application_configurations.setter
    def application_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpTwitchApplicationConfigurationArgs']]]]):
        pulumi.set(self, "application_configurations", value)

    @property
    @pulumi.getter
    def debug(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        """
        return pulumi.get(self, "debug")

    @debug.setter
    def debug(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_id", value)

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @lambda_reconcile_id.setter
    def lambda_reconcile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_reconcile_id", value)

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        """
        return pulumi.get(self, "linking_strategy")

    @linking_strategy.setter
    def linking_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linking_strategy", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level scope that you are requesting from Xbox.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpTwitchTenantConfigurationArgs']]]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

    @tenant_configurations.setter
    def tenant_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpTwitchTenantConfigurationArgs']]]]):
        pulumi.set(self, "tenant_configurations", value)


@pulumi.input_type
class _FusionAuthIdpTwitchState:
    def __init__(__self__, *,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpTwitchApplicationConfigurationArgs']]]] = None,
                 button_text: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpTwitchTenantConfigurationArgs']]]] = None):
        """
        Input properties used for looking up and filtering FusionAuthIdpTwitch resources.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpTwitchApplicationConfigurationArgs']]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] client_id: TThe top-level Xbox client id for your Application. This value is retrieved from the Xbox developer website when you setup your Xbox developer account.
        :param pulumi.Input[str] client_secret: The top-level client secret to use with the Xbox Identity Provider when retrieving the long-lived token. This value is retrieved from the Xbox developer website when you setup your Xbox developer account.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] idp_id: The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] scope: The top-level scope that you are requesting from Xbox.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpTwitchTenantConfigurationArgs']]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        if application_configurations is not None:
            pulumi.set(__self__, "application_configurations", application_configurations)
        if button_text is not None:
            pulumi.set(__self__, "button_text", button_text)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idp_id is not None:
            pulumi.set(__self__, "idp_id", idp_id)
        if lambda_reconcile_id is not None:
            pulumi.set(__self__, "lambda_reconcile_id", lambda_reconcile_id)
        if linking_strategy is not None:
            pulumi.set(__self__, "linking_strategy", linking_strategy)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if tenant_configurations is not None:
            pulumi.set(__self__, "tenant_configurations", tenant_configurations)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpTwitchApplicationConfigurationArgs']]]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @application_configurations.setter
    def application_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpTwitchApplicationConfigurationArgs']]]]):
        pulumi.set(self, "application_configurations", value)

    @property
    @pulumi.getter(name="buttonText")
    def button_text(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level button text to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_text")

    @button_text.setter
    def button_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "button_text", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        TThe top-level Xbox client id for your Application. This value is retrieved from the Xbox developer website when you setup your Xbox developer account.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level client secret to use with the Xbox Identity Provider when retrieving the long-lived token. This value is retrieved from the Xbox developer website when you setup your Xbox developer account.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def debug(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        """
        return pulumi.get(self, "debug")

    @debug.setter
    def debug(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_id", value)

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @lambda_reconcile_id.setter
    def lambda_reconcile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_reconcile_id", value)

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        """
        return pulumi.get(self, "linking_strategy")

    @linking_strategy.setter
    def linking_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linking_strategy", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level scope that you are requesting from Xbox.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpTwitchTenantConfigurationArgs']]]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

    @tenant_configurations.setter
    def tenant_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpTwitchTenantConfigurationArgs']]]]):
        pulumi.set(self, "tenant_configurations", value)


class FusionAuthIdpTwitch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpTwitchApplicationConfigurationArgs']]]]] = None,
                 button_text: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpTwitchTenantConfigurationArgs']]]]] = None,
                 __props__=None):
        """
        ## # Twitch Identity Provider Resource

        The Twitch identity provider type will use the Twitch OAuth v2.0 login API. It will also provide a Login with Twitch button on FusionAuth’s login page that will direct a user to the Twitch login page.

        This identity provider will call Twitch’s API to load the user’s email and preferred_username and use those as email and username to lookup or create a user in FusionAuth depending on the linking strategy configured for this identity provider. Additional claims returned by Twitch can be used to reconcile the user to FusionAuth by using a Twitch Reconcile Lambda.

        FusionAuth will also store the Twitch refresh_token returned from the Twitch API in the link between the user and the identity provider. This token can be used by an application to make further requests to Twitch APIs on behalf of the user.

        [Twitch Identity Provider APIs](https://fusionauth.io/docs/v1/tech/apis/identity-providers/twitch/)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        twitch = fusionauth.FusionAuthIdpTwitch("twitch",
            application_configurations=[fusionauth.FusionAuthIdpTwitchApplicationConfigurationArgs(
                application_id=fusionauth_application["my_app"]["id"],
                create_registration=True,
                enabled=True,
            )],
            button_text="Login with Twitch",
            client_id="0eb1ce3c-2fb1-4ae9-b361-d49fc6e764cc",
            client_secret="693s000cbn66k0mxtqzr_c_NfLy3~6_SEA",
            scope="Xboxlive.signin Xboxlive.offline_access")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpTwitchApplicationConfigurationArgs']]]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] client_id: TThe top-level Xbox client id for your Application. This value is retrieved from the Xbox developer website when you setup your Xbox developer account.
        :param pulumi.Input[str] client_secret: The top-level client secret to use with the Xbox Identity Provider when retrieving the long-lived token. This value is retrieved from the Xbox developer website when you setup your Xbox developer account.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] idp_id: The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] scope: The top-level scope that you are requesting from Xbox.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpTwitchTenantConfigurationArgs']]]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthIdpTwitchArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Twitch Identity Provider Resource

        The Twitch identity provider type will use the Twitch OAuth v2.0 login API. It will also provide a Login with Twitch button on FusionAuth’s login page that will direct a user to the Twitch login page.

        This identity provider will call Twitch’s API to load the user’s email and preferred_username and use those as email and username to lookup or create a user in FusionAuth depending on the linking strategy configured for this identity provider. Additional claims returned by Twitch can be used to reconcile the user to FusionAuth by using a Twitch Reconcile Lambda.

        FusionAuth will also store the Twitch refresh_token returned from the Twitch API in the link between the user and the identity provider. This token can be used by an application to make further requests to Twitch APIs on behalf of the user.

        [Twitch Identity Provider APIs](https://fusionauth.io/docs/v1/tech/apis/identity-providers/twitch/)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        twitch = fusionauth.FusionAuthIdpTwitch("twitch",
            application_configurations=[fusionauth.FusionAuthIdpTwitchApplicationConfigurationArgs(
                application_id=fusionauth_application["my_app"]["id"],
                create_registration=True,
                enabled=True,
            )],
            button_text="Login with Twitch",
            client_id="0eb1ce3c-2fb1-4ae9-b361-d49fc6e764cc",
            client_secret="693s000cbn66k0mxtqzr_c_NfLy3~6_SEA",
            scope="Xboxlive.signin Xboxlive.offline_access")
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthIdpTwitchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthIdpTwitchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpTwitchApplicationConfigurationArgs']]]]] = None,
                 button_text: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpTwitchTenantConfigurationArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthIdpTwitchArgs.__new__(FusionAuthIdpTwitchArgs)

            __props__.__dict__["application_configurations"] = application_configurations
            if button_text is None and not opts.urn:
                raise TypeError("Missing required property 'button_text'")
            __props__.__dict__["button_text"] = button_text
            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            if client_secret is None and not opts.urn:
                raise TypeError("Missing required property 'client_secret'")
            __props__.__dict__["client_secret"] = client_secret
            __props__.__dict__["debug"] = debug
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["idp_id"] = idp_id
            __props__.__dict__["lambda_reconcile_id"] = lambda_reconcile_id
            __props__.__dict__["linking_strategy"] = linking_strategy
            __props__.__dict__["scope"] = scope
            __props__.__dict__["tenant_configurations"] = tenant_configurations
        super(FusionAuthIdpTwitch, __self__).__init__(
            'fusionauth:index/fusionAuthIdpTwitch:FusionAuthIdpTwitch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpTwitchApplicationConfigurationArgs']]]]] = None,
            button_text: Optional[pulumi.Input[str]] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            client_secret: Optional[pulumi.Input[str]] = None,
            debug: Optional[pulumi.Input[bool]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            idp_id: Optional[pulumi.Input[str]] = None,
            lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
            linking_strategy: Optional[pulumi.Input[str]] = None,
            scope: Optional[pulumi.Input[str]] = None,
            tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpTwitchTenantConfigurationArgs']]]]] = None) -> 'FusionAuthIdpTwitch':
        """
        Get an existing FusionAuthIdpTwitch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpTwitchApplicationConfigurationArgs']]]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] client_id: TThe top-level Xbox client id for your Application. This value is retrieved from the Xbox developer website when you setup your Xbox developer account.
        :param pulumi.Input[str] client_secret: The top-level client secret to use with the Xbox Identity Provider when retrieving the long-lived token. This value is retrieved from the Xbox developer website when you setup your Xbox developer account.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] idp_id: The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] scope: The top-level scope that you are requesting from Xbox.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpTwitchTenantConfigurationArgs']]]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthIdpTwitchState.__new__(_FusionAuthIdpTwitchState)

        __props__.__dict__["application_configurations"] = application_configurations
        __props__.__dict__["button_text"] = button_text
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["debug"] = debug
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["idp_id"] = idp_id
        __props__.__dict__["lambda_reconcile_id"] = lambda_reconcile_id
        __props__.__dict__["linking_strategy"] = linking_strategy
        __props__.__dict__["scope"] = scope
        __props__.__dict__["tenant_configurations"] = tenant_configurations
        return FusionAuthIdpTwitch(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.FusionAuthIdpTwitchApplicationConfiguration']]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @property
    @pulumi.getter(name="buttonText")
    def button_text(self) -> pulumi.Output[str]:
        """
        The top-level button text to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_text")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        TThe top-level Xbox client id for your Application. This value is retrieved from the Xbox developer website when you setup your Xbox developer account.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[str]:
        """
        The top-level client secret to use with the Xbox Identity Provider when retrieving the long-lived token. This value is retrieved from the Xbox developer website when you setup your Xbox developer account.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def debug(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        """
        return pulumi.get(self, "debug")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "idp_id")

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> pulumi.Output[Optional[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> pulumi.Output[str]:
        """
        The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        """
        return pulumi.get(self, "linking_strategy")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[str]]:
        """
        The top-level scope that you are requesting from Xbox.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.FusionAuthIdpTwitchTenantConfiguration']]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

