# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['FusionAuthGroupArgs', 'FusionAuthGroup']

@pulumi.input_type
class FusionAuthGroupArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a FusionAuthGroup resource.
        :param pulumi.Input[str] tenant_id: The unique Id of the tenant used to scope this API request.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Group that should be persisted.
        :param pulumi.Input[str] group_id: The Id to use for the new Group. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] name: The name of the Group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_ids: The Application Roles to assign to this group.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_ids is not None:
            pulumi.set(__self__, "role_ids", role_ids)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The unique Id of the tenant used to scope this API request.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An object that can hold any information about the Group that should be persisted.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id to use for the new Group. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="roleIds")
    def role_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Application Roles to assign to this group.
        """
        return pulumi.get(self, "role_ids")

    @role_ids.setter
    def role_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "role_ids", value)


@pulumi.input_type
class _FusionAuthGroupState:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FusionAuthGroup resources.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Group that should be persisted.
        :param pulumi.Input[str] group_id: The Id to use for the new Group. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] name: The name of the Group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_ids: The Application Roles to assign to this group.
        :param pulumi.Input[str] tenant_id: The unique Id of the tenant used to scope this API request.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_ids is not None:
            pulumi.set(__self__, "role_ids", role_ids)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An object that can hold any information about the Group that should be persisted.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id to use for the new Group. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="roleIds")
    def role_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Application Roles to assign to this group.
        """
        return pulumi.get(self, "role_ids")

    @role_ids.setter
    def role_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "role_ids", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the tenant used to scope this API request.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class FusionAuthGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Group Resource

        A FusionAuth Group is a named object that optionally contains one to many Application Roles.

        When a Group does not contain any Application Roles it can still be utilized to logically associate users. Assigning Application Roles to a group allow it to be used to dynamically manage Role assignment to registered Users. In this second scenario as long as a User is registered to an Application the Group membership will allow them to inherit the corresponding Roles from the Group.

        [Groups API](https://fusionauth.io/docs/v1/tech/apis/groups)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        my_group = fusionauth.FusionAuthGroup("myGroup",
            tenant_id=fusionauth_tenant["my_tenant"]["id"],
            role_ids=[fusionauth_application_role["admins"]["id"]])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Group that should be persisted.
        :param pulumi.Input[str] group_id: The Id to use for the new Group. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] name: The name of the Group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_ids: The Application Roles to assign to this group.
        :param pulumi.Input[str] tenant_id: The unique Id of the tenant used to scope this API request.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Group Resource

        A FusionAuth Group is a named object that optionally contains one to many Application Roles.

        When a Group does not contain any Application Roles it can still be utilized to logically associate users. Assigning Application Roles to a group allow it to be used to dynamically manage Role assignment to registered Users. In this second scenario as long as a User is registered to an Application the Group membership will allow them to inherit the corresponding Roles from the Group.

        [Groups API](https://fusionauth.io/docs/v1/tech/apis/groups)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        my_group = fusionauth.FusionAuthGroup("myGroup",
            tenant_id=fusionauth_tenant["my_tenant"]["id"],
            role_ids=[fusionauth_application_role["admins"]["id"]])
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthGroupArgs.__new__(FusionAuthGroupArgs)

            __props__.__dict__["data"] = data
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["name"] = name
            __props__.__dict__["role_ids"] = role_ids
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(FusionAuthGroup, __self__).__init__(
            'fusionauth:index/fusionAuthGroup:FusionAuthGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            group_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            role_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'FusionAuthGroup':
        """
        Get an existing FusionAuthGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Group that should be persisted.
        :param pulumi.Input[str] group_id: The Id to use for the new Group. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] name: The name of the Group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_ids: The Application Roles to assign to this group.
        :param pulumi.Input[str] tenant_id: The unique Id of the tenant used to scope this API request.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthGroupState.__new__(_FusionAuthGroupState)

        __props__.__dict__["data"] = data
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["name"] = name
        __props__.__dict__["role_ids"] = role_ids
        __props__.__dict__["tenant_id"] = tenant_id
        return FusionAuthGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        An object that can hold any information about the Group that should be persisted.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        """
        The Id to use for the new Group. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleIds")
    def role_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The Application Roles to assign to this group.
        """
        return pulumi.get(self, "role_ids")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The unique Id of the tenant used to scope this API request.
        """
        return pulumi.get(self, "tenant_id")

