# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_google_sso', 'django_google_sso.migrations', 'django_google_sso.tests']

package_data = \
{'': ['*'], 'django_google_sso': ['templates/admin_sso/*']}

install_requires = \
['django>=3.2',
 'google-auth',
 'google-auth-httplib2',
 'google-auth-oauthlib',
 'loguru']

setup_kwargs = {
    'name': 'django-google-sso',
    'version': '1.0.0',
    'description': 'Easily add Google SSO login to Django Admin',
    'long_description': '## Welcome to Django Google SSO\n[![PyPI](https://img.shields.io/pypi/v/django-google-sso)](https://pypi.org/project/django-google-sso/)\n[![Build](https://github.com/chrismaille/django-google-sso/workflows/tests/badge.svg)](https://github.com/chrismaille/django-google-sso/actions)\n[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/django-google-sso)](https://www.python.org)\n[![PyPI - Django Version](https://img.shields.io/pypi/djversions/django-google-sso)](https://www.djangoproject.com/)\n[![Conventional Commits](https://img.shields.io/badge/Conventional%20Commits-1.0.0-yellow.svg)](https://conventionalcommits.org)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)\n\nThis library aims to simplify the process of authenticating users with Google in Django Admin pages,\ninspired by libraries like [django_microsoft_auth](https://github.com/AngellusMortis/django_microsoft_auth) and [django-admin-sso](https://github.com/matthiask/django-admin-sso/)\n\n### Why another library?\n\n* This library aims for _simplicity_ and ease of use. [django-allauth](https://github.com/pennersr/django-allauth) is _de facto_ solution for Authentication in Django,\nbut add lots of boilerplate, specially the html templates. **Django-Google-SSO** just add the "Login with Google" button in the default login page.\n* [django-admin-sso](https://github.com/matthiask/django-admin-sso/) is a good solution, but it uses a deprecated google `auth2client` version.\n\n### Install\n\n```shell\n$ pip install django-google-sso\n```\n\n### Configuration\n\n1. Add the following to your `settings.py` `INSTALLED_APPS`:\n\n```python\nINSTALLED_APPS = [\n    # other django apps\n    "django.contrib.messages",  # Need for Auth messages\n    "django.contrib.sites",  # Add Sites framework\n    "django_google_sso",  # Add django_google_sso\n]\n```\n\n2. In [Google Console](https://console.cloud.google.com/apis/credentials) at _Api -> Credentials_, retrieve your\nProject Credentials and add them in your `settings.py`:\n```python\nGOOGLE_SSO_CLIENT_ID = "your client id here"\nGOOGLE_SSO_PROJECT_ID = "your project id here"\nGOOGLE_SSO_CLIENT_SECRET = "your client secret here"\n```\n\n3. Add the default site and allowed domains to auto-create users:\n```python\nSITE_ID = 1  # Optional, just add if you want to use sites without request.\nGOOGLE_SSO_ALLOWABLE_DOMAINS = ["example.com"]\n```\n\n4. In `urls.py` please add the **Django-Google-SSO** views:\n```python\nfrom django.urls import include, path\n\nurlpatterns = [\n    # other urlpatterns...\n    path(\n        "google_sso/", include("django_google_sso.urls", namespace="django_google_sso")\n    ),\n]\n```\n5. In [Google Console](https://console.cloud.google.com/apis/credentials) at _Api -> Credentials -> Oauth2 Client_,\nplease add **Django-Google-SSO** callback url, using this format: `https://your-domain.com/google_sso/callback/`,\nwhere `your-domain.com` is the domain you defined in Django Sites Framework. For example, if you change your\nSite object domain to `localhost:8000`, then your callback must be `http://localhost:8000/google_sso/callback/`.\n\n6. Run migrations:\n```shell\n$ python manage.py migrate\n```\n\n### How Django-Google-SSO works\n\nFirst, the user is redirected to the Google login page. If settings `GOOGLE_SSO_ENABLED` is True, the\n"Login with Google" button will be added to default form.\n\nOn click, **Django-Google-SSO** will add, in current session, the `next_path` and Google Flow `state`.\nThis session will expire in 10 minutes. Then user will be redirected to Google login page.\n\nOn callback, **Django-Google-SSO** will check `code` and `state` received. If they are valid,\nGoogle\'s UserInfo will be retrieved. If the user is already registered in Django, the user\nwill be logged in. Otherwise, the user will be created and logged in, if his email domain,\nmatches one of the `GOOGLE_SSO_ALLOWABLE_DOMAINS`. On creation only, this user can be set the\n`staff` or `superuser` status, if his email are in `GOGGLE_SSO_STAFF_LIST` or\n`GOGGLE_SSO_SUPERUSER_LIST` respectively.\n\nPlease note if you add an email to one of these lists, the email domain must be added to `GOOGLE_SSO_ALLOWABLE_DOMAINS` too.\n\nThis session will expire in 1 hour, or the time defined, in seconds, in `GOOGLE_SSO_SESSION_COOKIE_AGE`.\n\nBrowser will be redirected to `next_path` if operation succeeds, or the `login` page, if operation fails.\n\n### Further customization\n\nPlease add the following variables to your `settings.py`:\n\n```python\nGOOGLE_SSO_ENABLED = True  # default value\nGOOGLE_SSO_SESSION_COOKIE_AGE = 3600  # default value\n\n# Mark as True, to add superuser status to first user\n# created with email in `GOOGLE_SSO_ALLOWABLE_DOMAINS`\nGOGGLE_SSO_AUTO_CREATE_FIRST_SUPERUSER = True\n\nGOGGLE_SSO_STAFF_LIST = ["email@example.com"]\nGOGGLE_SSO_SUPERUSER_LIST = ["another-email@example.com"]\nGOOGLE_SSO_TIMEOUT = 10  # Time before timeout Google requests. Default value: 10 seconds\nGOOGLE_SSO_SCOPES = [  # Google default scope\n    "openid",\n    "https://www.googleapis.com/auth/userinfo.email",\n    "https://www.googleapis.com/auth/userinfo.profile",\n]\n```\n\n### Running behind a Reverse Proxy\nPlease make sure you\'re passing the correct `X-Forwarded-Proto` header.\n\n### Example App\nTo test this library please check the `Example App` provided [here](/example_app).\n\n### Not working?\nDon\'t panic. Get a towel and, please, open an [issue](https://github.com/chrismaille/django-google-sso/issues).\n',
    'author': 'Chris Maillefaud',
    'author_email': 'chrismaillefaud@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/chrismaille/django-google-sso',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
