# Generated by Django 2.2.7 on 2019-11-15 09:31

from django.db import migrations, models
import django.db.models.deletion
import patchwork.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [("patchwork", "0036_project_commit_url_format")]

    operations = [
        migrations.CreateModel(
            name="BridgedSubmission",
            fields=[
                (
                    "submission",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        serialize=False,
                        to="patchwork.Submission",
                    ),
                ),
                ("merge_request", models.IntegerField()),
                (
                    "commit",
                    models.CharField(
                        blank=True, max_length=128, null=True, unique=True
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="GitForge",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "host",
                    models.CharField(
                        help_text="The hostname of the Git forge; this is used to find the correct configuration section in the python-gitlab.cfg file.",
                        max_length=255,
                    ),
                ),
                (
                    "forge_id",
                    models.IntegerField(
                        help_text="The unique ID of the project in the Git forge. For Gitlab, this is prominently displayed on the project home page."
                    ),
                ),
                (
                    "project",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="git_forge",
                        to="patchwork.Project",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Branch",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "subject_prefix",
                    models.CharField(
                        help_text="The prefix to include in emails in addition to 'PATCHvN'. The default will just be PATCH.",
                        max_length=64,
                    ),
                ),
                (
                    "subject_match",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Regex to match the subject against if the Patchwork project maps to multiple development branches. That is, perhaps you have a project where patches are prefixed with PROJ FEATURE for features and PROJ BUGFIX for bugfixes and pull requests should be opened against different branches depending on whether the patch is a feature or a bugfix. Like the project match, this will be used with IGNORECASE and MULTILINE flags. The first git forge returned from the database with a matching rule is used.",
                        max_length=64,
                        validators=[patchwork.models.validate_regex_compiles],
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        default="master",
                        help_text="The development branch name; This is used to determine the email prefix when bridging a merge request to email, as well as the correct branch to apply incoming patches to when bridging email to merge requests",
                        max_length=255,
                    ),
                ),
                (
                    "git_forge",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="branches",
                        to="patchlab.GitForge",
                    ),
                ),
            ],
        ),
        migrations.AddIndex(
            model_name="gitforge",
            index=models.Index(
                fields=["host", "forge_id"], name="patchlab_gi_host_469b50_idx"
            ),
        ),
        migrations.AlterUniqueTogether(
            name="gitforge", unique_together={("host", "forge_id")}
        ),
        migrations.AddIndex(
            model_name="branch",
            index=models.Index(fields=["name"], name="patchlab_br_name_fbc1d2_idx"),
        ),
    ]
