import youtube_dl, requests
from bgeditor.common.utils import get_dir, download_file,normal_audio
from bgeditor.dao.FFmpeg import create_loop_audio_times
import uuid,json, shutil,os
from moviepy.editor import *
def download_audio(url,ext='mp3'):
    file_name = str(uuid.uuid4()) + "." + ext
    rs = get_dir('download') + file_name
    ydl_opts = {
        'outtmpl': rs,
        'format': 'bestaudio/m4a',
    }
    with youtube_dl.YoutubeDL(ydl_opts) as ydl:
        ydl.download([url])
    return rs
def create_compilation_songs(data):
    #[{"type":3,"url":"","repeat":1}]
    #3: youtube_video
    #7: deezer
    #8: link direct
    arr_songs=data
    file_merg_path = get_dir('coolbg_ffmpeg') + str(uuid.uuid4())
    file_merg = open(file_merg_path, "a")
    final_clip_path = get_dir('coolbg_ffmpeg') + str(uuid.uuid4()) + '-final.mp3'
    try:
        for song in arr_songs:
            try:
                arr_tmp=song['url'].split(":")
                if arr_tmp[0] == "youtube":#youtube
                    song['local']=download_audio(arr_tmp[1])
                if arr_tmp[0] == "direct":#direct
                    song['local']=download_file(arr_tmp[1])
                if arr_tmp[0] == "deezer":#deezer
                    song_info=requests.get("http://source.automusic.win/deezer/track/get/"+arr_tmp[1], timeout=180).json()
                    song['local']=download_file(song_info['url_128'])
                if arr_tmp[0] == "spotify":  # spotify
                    arr_song_info = requests.get("http://source.automusic.win/spotify/track/get/" + arr_tmp[1], timeout=180).json()
                    if len(arr_song_info)>0:
                        deezer_id=arr_song_info[0]['deezer_id']
                        if int(deezer_id)>0:
                            song_info = requests.get("http://source.automusic.win/deezer/track/get/" + deezer_id, timeout=180).json()
                            song['local'] = download_file(song_info['url_128'])

                #after download song, re-check song
                try:
                    audio_test=AudioFileClip(song['local'])
                    audioduration=audio_test.duration
                    audio_test.close()
                    if audioduration < 1:
                        continue
                except:
                    continue
                    pass

                if len(arr_songs) > 1:
                    song['local']=normal_audio(song['local'])
                if song['repeat'] > 1:
                    song['local']= create_loop_audio_times(song['local'], song['repeat'])

                if not "coolbg_ffmpeg" in song['local']:
                    tmp_clip_path = get_dir('coolbg_ffmpeg') + str(uuid.uuid4()) + '-' + os.path.basename(song['local'])
                    shutil.copyfile(song['local'], tmp_clip_path)
                    os.remove(song['local'])
                    song['local']=tmp_clip_path

                file_merg.write("file '%s'\n" % os.path.basename(song['local']))
            except:
                pass
        file_merg.close()
        cmd = "ffmpeg -y -f concat -safe 0 -i \"%s\" -codec copy \"%s\"" % (file_merg_path, final_clip_path)
        os.system(cmd)
        os.remove(file_merg_path)
        for song in arr_songs:
            os.remove(song['local'])
    except:
        pass
    return final_clip_path




