"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainConfig = exports.DomainConfigProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const waf_generated_1 = require("./waf.generated");
Object.defineProperty(exports, "DomainConfigProperty", { enumerable: true, get: function () { return waf_generated_1.RosDomainConfig; } });
/**
 * A ROS resource type:  `ALIYUN::WAF::DomainConfig`
 */
class DomainConfig extends ros.Resource {
    /**
     * Create a new `ALIYUN::WAF::DomainConfig`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDomainConfig = new waf_generated_1.RosDomainConfig(this, id, {
            httpToUserIp: props.httpToUserIp,
            httpPort: props.httpPort,
            isAccessProduct: props.isAccessProduct,
            rsType: props.rsType,
            protocols: props.protocols,
            instanceId: props.instanceId,
            sourceIps: props.sourceIps,
            httpsRedirect: props.httpsRedirect,
            region: props.region,
            domain: props.domain,
            loadBalancing: props.loadBalancing,
            httpsPort: props.httpsPort,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDomainConfig;
        this.attrCname = rosDomainConfig.attrCname;
        this.attrProtocolType = rosDomainConfig.attrProtocolType;
    }
}
exports.DomainConfig = DomainConfig;
//# sourceMappingURL=data:application/json;base64,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