# coding: utf-8

"""
    Stitch Connect

    https://www.stitchdata.com/docs/developers/stitch-connect/api  # noqa: E501

    The version of the OpenAPI document: 0.4.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from stitch_connect_client.configuration import Configuration


class GoogleAnalyticsSourceFormProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "anchor_time": "str",
        "client_id": "str",
        "client_secret": "str",
        "cron_expression": "str",
        "frequency_in_minutes": "str",
        "quota_user": "str",
        "refresh_token": "str",
        "report_definitions": "list[GoogleAnalyticsSourceFormPropertiesReportDefinitions]",
        "start_date": "str",
    }

    attribute_map = {
        "anchor_time": "anchor_time",
        "client_id": "client_id",
        "client_secret": "client_secret",
        "cron_expression": "cron_expression",
        "frequency_in_minutes": "frequency_in_minutes",
        "quota_user": "quota_user",
        "refresh_token": "refresh_token",
        "report_definitions": "report_definitions",
        "start_date": "start_date",
    }

    def __init__(
        self,
        anchor_time=None,
        client_id=None,
        client_secret=None,
        cron_expression=None,
        frequency_in_minutes=None,
        quota_user=None,
        refresh_token=None,
        report_definitions=None,
        start_date=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """GoogleAnalyticsSourceFormProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._anchor_time = None
        self._client_id = None
        self._client_secret = None
        self._cron_expression = None
        self._frequency_in_minutes = None
        self._quota_user = None
        self._refresh_token = None
        self._report_definitions = None
        self._start_date = None
        self.discriminator = None

        if anchor_time is not None:
            self.anchor_time = anchor_time
        if client_id is not None:
            self.client_id = client_id
        if client_secret is not None:
            self.client_secret = client_secret
        if cron_expression is not None:
            self.cron_expression = cron_expression
        if frequency_in_minutes is not None:
            self.frequency_in_minutes = frequency_in_minutes
        if quota_user is not None:
            self.quota_user = quota_user
        if refresh_token is not None:
            self.refresh_token = refresh_token
        if report_definitions is not None:
            self.report_definitions = report_definitions
        if start_date is not None:
            self.start_date = start_date

    @property
    def anchor_time(self):
        """Gets the anchor_time of this GoogleAnalyticsSourceFormProperties.  # noqa: E501

        Defines the time that frequency_in_minutes is \"anchored\" to, which Stitch will use to create the integration's replication schedule. In Stitch, this is referred to as Anchor Scheduling. This field must contain an ISO 8601-compliant date. Note: When Stitch stores this value, it will be in UTC. You should provide this value in UTC to ensure the desired anchor time is retained. For example: You want to create a schedule that is anchored to 1:00PM EST and runs every 6 hours (360 minutes). To do this, you can set anchor_time to something like 2018-04-30T17:00:00Z and frequency_in_minutes to 360. This means jobs would run at 23:00:00, 05:00:00, 11:00:00, and so on.   # noqa: E501

        :return: The anchor_time of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :rtype: str
        """
        return self._anchor_time

    @anchor_time.setter
    def anchor_time(self, anchor_time):
        """Sets the anchor_time of this GoogleAnalyticsSourceFormProperties.

        Defines the time that frequency_in_minutes is \"anchored\" to, which Stitch will use to create the integration's replication schedule. In Stitch, this is referred to as Anchor Scheduling. This field must contain an ISO 8601-compliant date. Note: When Stitch stores this value, it will be in UTC. You should provide this value in UTC to ensure the desired anchor time is retained. For example: You want to create a schedule that is anchored to 1:00PM EST and runs every 6 hours (360 minutes). To do this, you can set anchor_time to something like 2018-04-30T17:00:00Z and frequency_in_minutes to 360. This means jobs would run at 23:00:00, 05:00:00, 11:00:00, and so on.   # noqa: E501

        :param anchor_time: The anchor_time of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :type: str
        """

        self._anchor_time = anchor_time

    @property
    def client_id(self):
        """Gets the client_id of this GoogleAnalyticsSourceFormProperties.  # noqa: E501

        The secure OAuth 2.0 identifier for the client application.   # noqa: E501

        :return: The client_id of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :rtype: str
        """
        return self._client_id

    @client_id.setter
    def client_id(self, client_id):
        """Sets the client_id of this GoogleAnalyticsSourceFormProperties.

        The secure OAuth 2.0 identifier for the client application.   # noqa: E501

        :param client_id: The client_id of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :type: str
        """

        self._client_id = client_id

    @property
    def client_secret(self):
        """Gets the client_secret of this GoogleAnalyticsSourceFormProperties.  # noqa: E501

        The secure OAuth 2.0 secret key for the client application.   # noqa: E501

        :return: The client_secret of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :rtype: str
        """
        return self._client_secret

    @client_secret.setter
    def client_secret(self, client_secret):
        """Sets the client_secret of this GoogleAnalyticsSourceFormProperties.

        The secure OAuth 2.0 secret key for the client application.   # noqa: E501

        :param client_secret: The client_secret of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :type: str
        """

        self._client_secret = client_secret

    @property
    def cron_expression(self):
        """Gets the cron_expression of this GoogleAnalyticsSourceFormProperties.  # noqa: E501

        Note: Advanced Scheduling using Cron is not yet supported for this source. A value may be submitted for this property if the account is on an Enterprise plan, but Stitch will not use the expression submitted. A valid Quartz cron expression representing the replication schedule for the integration. Refer to the Advanced Scheduling documentation for more info. Note: If neither a cron_expression or frequency_in_minutes property is provided, Stitch will use the source's default frequency_in_minutes value (60).   # noqa: E501

        :return: The cron_expression of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :rtype: str
        """
        return self._cron_expression

    @cron_expression.setter
    def cron_expression(self, cron_expression):
        """Sets the cron_expression of this GoogleAnalyticsSourceFormProperties.

        Note: Advanced Scheduling using Cron is not yet supported for this source. A value may be submitted for this property if the account is on an Enterprise plan, but Stitch will not use the expression submitted. A valid Quartz cron expression representing the replication schedule for the integration. Refer to the Advanced Scheduling documentation for more info. Note: If neither a cron_expression or frequency_in_minutes property is provided, Stitch will use the source's default frequency_in_minutes value (60).   # noqa: E501

        :param cron_expression: The cron_expression of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :type: str
        """

        self._cron_expression = cron_expression

    @property
    def frequency_in_minutes(self):
        """Gets the frequency_in_minutes of this GoogleAnalyticsSourceFormProperties.  # noqa: E501

        Defines how often, in minutes, Stitch should attempt to replicate data from Google Analytics. Accepted values are: - 30 - 60 - 360 - 720 - 1440   # noqa: E501

        :return: The frequency_in_minutes of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :rtype: str
        """
        return self._frequency_in_minutes

    @frequency_in_minutes.setter
    def frequency_in_minutes(self, frequency_in_minutes):
        """Sets the frequency_in_minutes of this GoogleAnalyticsSourceFormProperties.

        Defines how often, in minutes, Stitch should attempt to replicate data from Google Analytics. Accepted values are: - 30 - 60 - 360 - 720 - 1440   # noqa: E501

        :param frequency_in_minutes: The frequency_in_minutes of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :type: str
        """

        self._frequency_in_minutes = frequency_in_minutes

    @property
    def quota_user(self):
        """Gets the quota_user of this GoogleAnalyticsSourceFormProperties.  # noqa: E501

        Note: This is a read-only property and will be returned when the Google Analytics object is successfully created. Including it in POST or PUT requests will result in InvalidProperties errors.   # noqa: E501

        :return: The quota_user of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :rtype: str
        """
        return self._quota_user

    @quota_user.setter
    def quota_user(self, quota_user):
        """Sets the quota_user of this GoogleAnalyticsSourceFormProperties.

        Note: This is a read-only property and will be returned when the Google Analytics object is successfully created. Including it in POST or PUT requests will result in InvalidProperties errors.   # noqa: E501

        :param quota_user: The quota_user of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :type: str
        """

        self._quota_user = quota_user

    @property
    def refresh_token(self):
        """Gets the refresh_token of this GoogleAnalyticsSourceFormProperties.  # noqa: E501

        The OAuth 2.0 refresh token used to access the Google API.  # noqa: E501

        :return: The refresh_token of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :rtype: str
        """
        return self._refresh_token

    @refresh_token.setter
    def refresh_token(self, refresh_token):
        """Sets the refresh_token of this GoogleAnalyticsSourceFormProperties.

        The OAuth 2.0 refresh token used to access the Google API.  # noqa: E501

        :param refresh_token: The refresh_token of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :type: str
        """

        self._refresh_token = refresh_token

    @property
    def report_definitions(self):
        """Gets the report_definitions of this GoogleAnalyticsSourceFormProperties.  # noqa: E501

        An array of objects, each object pertaining to a custom report you want to create. Note: Metrics and dimensions for each report can be selected when the source proceeds to the field_selection step.   # noqa: E501

        :return: The report_definitions of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :rtype: list[GoogleAnalyticsSourceFormPropertiesReportDefinitions]
        """
        return self._report_definitions

    @report_definitions.setter
    def report_definitions(self, report_definitions):
        """Sets the report_definitions of this GoogleAnalyticsSourceFormProperties.

        An array of objects, each object pertaining to a custom report you want to create. Note: Metrics and dimensions for each report can be selected when the source proceeds to the field_selection step.   # noqa: E501

        :param report_definitions: The report_definitions of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :type: list[GoogleAnalyticsSourceFormPropertiesReportDefinitions]
        """

        self._report_definitions = report_definitions

    @property
    def start_date(self):
        """Gets the start_date of this GoogleAnalyticsSourceFormProperties.  # noqa: E501

        The date from which Stitch should begin replicating data from Salesforce. Data from this date forward will be replicated. This field must contain an ISO 8601-compliant date, and the timestamp must be midnight. For example: 2018-01-01T00:00:00Z   # noqa: E501

        :return: The start_date of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :rtype: str
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this GoogleAnalyticsSourceFormProperties.

        The date from which Stitch should begin replicating data from Salesforce. Data from this date forward will be replicated. This field must contain an ISO 8601-compliant date, and the timestamp must be midnight. For example: 2018-01-01T00:00:00Z   # noqa: E501

        :param start_date: The start_date of this GoogleAnalyticsSourceFormProperties.  # noqa: E501
        :type: str
        """

        self._start_date = start_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GoogleAnalyticsSourceFormProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GoogleAnalyticsSourceFormProperties):
            return True

        return self.to_dict() != other.to_dict()
