# Al Adhan - Islamic prayer times API in Python!

Without any API keys, authentication, or registration, you can use this API to get the Islamic Adhan (_a call to prayer_) times  for any location in the world for free using Python, this project uses the [aladhan.com official prayer times API](https://aladhan.com/prayer-times-api) (thanks to them for the great work and free API). I have made this API to convert the JSON responses from the aladhan.com API and simplify them to a Python objects and classes, so you can use them in your Python projects and they are easy to use. 

**This is still the alpha version, there is a lot of coming features, also note that any big changes in the API will happen at any time!** If you find any bugs or problems, please report them in the [issues](https://www.github.com/Kh4lidMD/AlAdhan/issues) page.

<br>

_Learn more about Adhan in [Wikipedia](https://en.wikipedia.org/wiki/Adhan)_

<br>

# Features

- Get the prayer times for any location in the world.
- Get the prayer times for any date.
- No API keys, authentication, or registration required.
- Converting the JSON responses to Python objects and OOP based.
- More adhan metadata made by the module, such as the number of rakat in salah, sunnan al rawatib rakat number, is hijri or secret salah, etc.

<br>

# Installation

The project is available on [PyPI](https://pypi.org/project/aladhan-api/), so you can install it using [pip](https://www.w3schools.com/python/python_pip.asp):

```bash
pip install aladhan-api
```

If you have an older version of the API, you can update it to the latest version using:

```bash
pip install aladhan-api --upgrade
```

<br>

# Documentation

Detailed documentation for the API can be found at [Read the Docs](https://aladhan.readthedocs.io/en/latest/).

<br>

# Versioning

[v6.1.0 (Alpha) **Latest**](https://github.com/Kh4lidMD/AlAdhan/releases/tag/v6.1.0-alpha)

[v6.0.0 (Alpha)](https://github.com/Kh4lidMD/AlAdhan/releases/tag/v6.0.0-alpha)

[v5.0.0 (Alpha)](https://github.com/Kh4lidMD/AlAdhan/releases/tag/v5.0.0-alpha)

[v4.1.0 (Alpha)](https://github.com/Kh4lidMD/AlAdhan/releases/tag/v4.1.0-alpha)

[v4.0.0 (Alpha)](https://github.com/Kh4lidMD/AlAdhan/releases/tag/v4.0.0-alpha)

[v3.0.0 (Alpha)](https://github.com/Kh4lidMD/AlAdhan/releases/tag/v3.0.0-alpha)

[v2.2.0 (Alpha)](https://github.com/Kh4lidMD/AlAdhan/releases/tag/v2.2.0-alpha)

[v2.0.1 (Alpha)](https://github.com/Kh4lidMD/AlAdhan/releases/tag/v2.0.1-alpha)

[v2.0.0 (Alpha)](https://github.com/Kh4lidMD/AlAdhan/releases/tag/v2.0.0-alpha)

v1.0.0 (Alpha) - initial release

<br>

See all the releases [here](https://www.github.com/Kh4lidMD/AlAdhan/releases).